/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.dnd.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.dnd.AbstractEAnnotationDnDHandler;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.IServiceBinding;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.BpmnEditorExtensionActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ServiceBindingTreeElement;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWithServiceBindingDndHandler
extends AbstractEAnnotationDnDHandler {
    private String serviceName = null;
    private String runtimeID = null;
    private String serviceBindingName = null;

    public ServiceWithServiceBindingDndHandler(ServiceBindingTreeElement serviceBindingTreeElement) {
        this.runtimeID = serviceBindingTreeElement.getRuntimeId();
        this.serviceName = serviceBindingTreeElement.getParent().getName();
        this.serviceBindingName = serviceBindingTreeElement.getName();
    }

    public Command getDropCommand(IGraphicalEditPart hoverPart, int index, Point dropLocation) {
        String value;
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("im.pool.runtimeID", this.runtimeID);
        details.put("im.servicename", this.serviceName);
        details.put("im.servicebindingname", this.serviceBindingName);
        IRuntime runtime = ImRuntimeActivator.getRuntime((String)this.runtimeID);
        IServiceBinding serviceBinding = (IServiceBinding)runtime.getServiceBindings().get(this.serviceBindingName);
        for (IProperty property : serviceBinding.getDefinedProperties()) {
            if (property.isMap() || property.isVisibleUnderCondition()) continue;
            value = property.getDefaultValue() != null ? property.getDefaultValue() : "";
            details.put(property.getName(), value);
        }
        for (IProperty property : serviceBinding.getDefinedProperties()) {
            if (!property.isVisibleUnderCondition() || !this.evaluateVisibilityCondition(property.getVisibleCondition(), details)) continue;
            value = property.getDefaultValue() != null ? property.getDefaultValue() : "";
            details.put(property.getName(), value);
        }
        return this.createEAnnotationDropCommand(this.createAnnotation("im", details), (EModelElement)hoverPart.resolveSemanticElement());
    }

    protected boolean evaluateVisibilityCondition(String visibleCondition, Map<String, String> details) {
        if (visibleCondition.startsWith("if-is-true")) {
            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
            String value = details.get(propName);
            return Boolean.valueOf(value);
        }
        if (visibleCondition.startsWith("if-is-false")) {
            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
            String value = details.get(propName);
            return Boolean.valueOf(value) == false;
        }
        if (visibleCondition.startsWith("if-has-value")) {
            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
            String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
            String value = details.get(propName);
            return valueToEnableVisibility.equalsIgnoreCase(value);
        }
        if (visibleCondition.startsWith("if-isone-of")) {
            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
            String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
            String arrValues = valueToEnableVisibility.substring(1, valueToEnableVisibility.length() - 1);
            System.out.println("values -> " + arrValues);
            String[] splitterArr = arrValues.split(";");
            List<String> splittedValues = Arrays.asList(splitterArr);
            String value = details.get(propName);
            return splittedValues.contains(value);
        }
        return false;
    }

    public int getItemCount() {
        return 1;
    }

    public Image getMenuItemImage(IGraphicalEditPart hoverPart, int index) {
        return BpmnEditorExtensionActivator.getImageDescriptor("icons/spagic.gif").createImage();
    }

    public String getMenuItemLabel(IGraphicalEditPart hoverPart, int index) {
        EObject element = hoverPart.resolveSemanticElement();
        String suffix = " on " + this.getShapeLabel((NamedBpmnObject)element);
        return "Attach Service[" + this.serviceName + "] with Binding (" + this.serviceBindingName + ") on " + suffix;
    }

    public int getPriority() {
        return 0;
    }

    protected String getShapeLabel(NamedBpmnObject namedElement) {
        String name;
        String string = name = namedElement.getName() != null && namedElement.getName().length() > 0 ? namedElement.getName() : "";
        if (name.length() > 18) {
            name = String.valueOf(name.substring(0, 12)) + "...";
        }
        if (namedElement instanceof Pool) {
            if (name.indexOf("pool") == -1) {
                return "pool " + name;
            }
            return name;
        }
        if (namedElement instanceof Activity) {
            String shape = ((Activity)namedElement).getActivityType().getLiteral();
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof MessagingEdge) {
            String shape = "message";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof SequenceEdge) {
            String shape = "sequence";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof Diagram) {
            String shape = "diagram";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof TextAnnotation) {
            String shape = "annotation";
            if (name.indexOf(shape) == -1) {
                return "text " + shape + " " + name;
            }
            return name;
        }
        if (namedElement instanceof DataObject) {
            String shape = "object";
            if (name.indexOf(shape) == -1) {
                return "data " + shape + " " + name;
            }
            return name;
        }
        return name;
    }

    public boolean isEnabled(IGraphicalEditPart hoverPart, int index) {
        EModelElement emodelElement = (EModelElement)hoverPart.resolveSemanticElement();
        if (emodelElement instanceof Pool) {
            return false;
        }
        if (emodelElement instanceof Activity) {
            Graph g = ((Activity)emodelElement).getGraph();
            EAnnotation technologyAnnotation = g.getEAnnotation("technology");
            if (g instanceof Pool && technologyAnnotation == null) {
                return false;
            }
        }
        return true;
    }
}

