/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtils {
    private static final Logger log = Logger.getLogger(StringUtils.class);
    private static HashMap compiledRegEx = new HashMap();

    private StringUtils() {
    }

    public static String getStringFromStream(InputStream is) {
        if (is != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                log.error((Object)"Unexpected exception in getStreamFromString", (Throwable)e1);
                return null;
            }
            StringBuffer sb = new StringBuffer();
            char[] b = new char[1024];
            try {
                int n;
                while ((n = reader.read(b)) > 0) {
                    sb.append(b, 0, n);
                }
            }
            catch (IOException e) {
                log.error((Object)("Can't read String from " + is), (Throwable)e);
            }
            return sb.toString();
        }
        return null;
    }

    public static InputStream getStreamFromString(String in) {
        ByteArrayInputStream ret = null;
        try {
            byte[] ba = in.getBytes("UTF-8");
            ret = new ByteArrayInputStream(ba);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unexpected exception: ", (Throwable)e);
        }
        return ret;
    }

    public static String replace(String source, String sub, String replacement, boolean replaceAll) {
        int pos;
        if (source == null || sub == null || sub.length() == 0 || replacement == null) {
            throw new IllegalArgumentException("null or empty String");
        }
        StringBuffer result = new StringBuffer();
        int oldpos = 0;
        while ((pos = source.indexOf(sub, oldpos)) >= 0) {
            result.append(source.substring(oldpos, pos));
            result.append(replacement);
            oldpos = pos += sub.length();
            if (replaceAll) continue;
        }
        if (oldpos == 0) {
            return source;
        }
        result.append(source.substring(oldpos));
        return new String(result);
    }

    public static boolean validatePattern(String pattern, String testString) {
        if (pattern == null || testString == null || pattern.equals("")) {
            return false;
        }
        Pattern patternObj = null;
        patternObj = (Pattern)compiledRegEx.get(pattern);
        if (patternObj == null) {
            patternObj = Pattern.compile(pattern);
            compiledRegEx.put(pattern, patternObj);
        }
        Matcher matcher = patternObj.matcher(testString);
        return matcher.matches();
    }

    public static String getPrefixForColonizedName(String colonizedString) {
        String prefix = "";
        int colonIndex = colonizedString.indexOf(":");
        if (-1 != colonIndex) {
            prefix = colonizedString.substring(0, colonIndex);
        }
        return prefix;
    }

    public static String getLocalForColonizedName(String colonizedString) {
        String local = "";
        int colonIndex = colonizedString.indexOf(":");
        local = -1 != colonIndex ? colonizedString.substring(colonIndex + 1) : colonizedString;
        return local;
    }
}

