/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.stp.policy.wtp.editor.Activator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int EDIT_STYLE = 2052;
    private Text _schemaPathText = null;
    public static final String SCHEMA_PATH = "org.eclipse.stp.policy.wtp.editor.schema.path";
    public static final String DEFAULT_SCHEMA_PATH = "schemas";

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        IPreferenceStore store = this.getPreferenceStore();
        String schemaPath = store.getString(SCHEMA_PATH);
        if (schemaPath.length() == 0) {
            schemaPath = DEFAULT_SCHEMA_PATH;
            store.setValue(SCHEMA_PATH, schemaPath);
        }
        GeneralPreferences.createLabel(result, "Schema directory relative path:");
        this._schemaPathText = GeneralPreferences.createText(result, schemaPath);
        return result;
    }

    private static Label createLabel(Composite parent, String label) {
        Label controlLabel = new Label(parent, 0);
        controlLabel.setText(label);
        return controlLabel;
    }

    private static Text createText(Composite parent, String text) {
        Text controlText = new Text(parent, 2052);
        controlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (text != null) {
            controlText.setText(text);
        }
        return controlText;
    }

    protected void performApply() {
        super.performApply();
        this.savePrefs();
    }

    public boolean performOk() {
        boolean bRet = super.performOk();
        this.savePrefs();
        return bRet;
    }

    private void savePrefs() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(SCHEMA_PATH, this._schemaPathText.getText().replace('\\', '/'));
        Activator.getDefault().savePluginPreferences();
    }
}

