/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.popup.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.ValidatorTypeEnum;
import org.eclipse.stp.common.validator.core.impl.ValidatorFactoryDefImpl;
import org.eclipse.stp.common.validator.exception.ConfigurationException;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.eclipse.stp.policy.wtp.validation.popup.actions.CommonValidationAction;

public class ValidationAction
extends CommonValidationAction {
    public ValidationAction(IFile file) {
        super(file);
    }

    public ValidationAction(File file) {
        super(file);
    }

    public void validate() throws SOPValidationException {
        super.validate();
        try {
            IValidationContext context = this.getValidationContext();
            if (context != null) {
                IValidator msvValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.MULTISCHEMA_VALIDATOR);
                msvValidator.validate(context, this.getReporter());
                if (this.getErrorsCount() == 0 && (this.getObjectType().equals("SDX") || this.getObjectType().equals("SPDX"))) {
                    IValidator genericValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.GENERIC_VALIDATOR);
                    genericValidator.validate(context, this.getReporter());
                }
            }
        }
        catch (ContextInitializationException e) {
            throw new SOPValidationException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new SOPValidationException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

