/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.views;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.CommonResources;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.annotations.ScJDTAnnUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.views.AnnotationViewerContentProvider;
import org.eclipse.stp.sc.common.views.AnnotationViewerLabelProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class AnnotationView
extends ViewPart {
    public static final String ANNOTATION_VIEW_ID = "org.eclipse.stp.sc.common.views.AnnotationView";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnotationView.class);
    protected TreeEditor treeEditor;
    protected Combo combo = null;
    protected Text text = null;
    Image iconOff = CommonResources.getImageDescriptor("obj16/annotation_false_obj.gif").createImage();
    Image iconOn = CommonResources.getImageDescriptor("obj16/annotation_true_obj.gif").createImage();
    Map<String, Annotation> annotationNodesMap;
    public TreeViewer annotationsviewer;
    public ISelectionListener workbenchSelectionListener = new AnnotationSelectionListener();
    protected IPartListener2 workbenchPartListener = new JavaEditorListener();
    private IMember selectedJdtMember;
    private SingleVariableDeclaration selectedJdtMethodParam;
    private boolean editSupportEnabled;
    private CompilationUnit compilationUnitAstNode;
    private ICompilationUnit compilationUnitMember;
    private IFile javaEditorInputFile;
    static final String JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    private int offset;
    private String originalValue;

    public void createPartControl(Composite parent) {
        IEditorPart editor;
        this.annotationsviewer = new TreeViewer(parent, 65538);
        this.annotationsviewer.getTree().setHeaderVisible(true);
        TreeColumn column = new TreeColumn(this.annotationsviewer.getTree(), 16384);
        column.setText(CommonResources.getString("annotation.view.Col1.lbl"));
        column.setResizable(true);
        column.setWidth(300);
        column = new TreeColumn(this.annotationsviewer.getTree(), 16384);
        column.setText(CommonResources.getString("annotation.view.Col2.lbl"));
        column.setResizable(true);
        column.setWidth(700);
        this.annotationsviewer.setLabelProvider((IBaseLabelProvider)new AnnotationViewerLabelProvider(this));
        this.annotationsviewer.setContentProvider((IContentProvider)new AnnotationViewerContentProvider(this));
        this.annotationsviewer.setSorter(new ViewerSorter());
        this.treeEditor = new TreeEditor(this.annotationsviewer.getTree());
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.grabVertical = true;
        this.annotationsviewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnnotationView.this.activateEditSupport(event);
            }
        });
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getSelectionService().addPostSelectionListener(this.workbenchSelectionListener);
        window.getPartService().addPartListener(this.workbenchPartListener);
        if (window.getActivePage() != null && (editor = window.getActivePage().getActiveEditor()) != null) {
            ISelection selection = window.getActivePage().getSelection();
            this.workbenchSelectionListener.selectionChanged((IWorkbenchPart)editor, selection);
        }
    }

    public void setFocus() {
        this.annotationsviewer.getControl().setFocus();
    }

    public void dispose() {
        this.iconOff.dispose();
        this.iconOn.dispose();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getSelectionService().removePostSelectionListener(this.workbenchSelectionListener);
        window.getPartService().removePartListener(this.workbenchPartListener);
        super.dispose();
    }

    private void activateEditSupport(SelectionEvent event) {
        if (!this.editSupportEnabled) {
            LOG.debug((Object)"edit support disabld");
            return;
        }
        this.disposeEditWidgets();
        TreeItem item = null;
        Tree tree = (Tree)event.getSource();
        if (tree.getSelectionCount() != 1) {
            return;
        }
        item = tree.getSelection()[0];
        Object element = item.getData();
        this.activateEditSupport(element, item);
    }

    private void activateEditSupport(Object element, TreeItem item) {
        if (element instanceof Class) {
            this.handleEditOnAnnotation(item);
        } else if (element instanceof Method) {
            if ("false".equals(item.getParentItem().getText(1))) {
                this.disposeEditWidgets();
                return;
            }
            Class<?> returnTypeClass = ((Method)element).getReturnType();
            if (returnTypeClass.isEnum()) {
                this.handleEditOnEnumAttribute(item, returnTypeClass);
            } else if (returnTypeClass.isArray()) {
                this.handleEditOnArrayAttribute(item, returnTypeClass);
            } else if (returnTypeClass.equals(String.class)) {
                this.handleEditOnStringAttribute(item);
            } else if (returnTypeClass.equals(Boolean.TYPE) || returnTypeClass.equals(Boolean.class)) {
                this.handleEditOnBooleanAttribute(item);
            } else if (returnTypeClass.equals(Integer.TYPE) || returnTypeClass.equals(Integer.class) || returnTypeClass.equals(Long.TYPE) || returnTypeClass.equals(Long.class) || returnTypeClass.equals(Float.TYPE) || returnTypeClass.equals(Float.class) || returnTypeClass.equals(Double.TYPE) || returnTypeClass.equals(Double.class)) {
                this.handleEditOnNumericAttribute(item);
            } else {
                this.handleEditOnStringAttribute(item);
            }
        } else if (element instanceof Object[]) {
            Object[] pair = (Object[])element;
            if (pair[0] instanceof String) {
                if (item.getParentItem().getParentItem().getText(1).equals("true")) {
                    this.handleEditOnArrayElement(item);
                }
            } else if (pair[0] instanceof Method) {
                Method method = (Method)pair[0];
                this.activateEditSupport(method, item);
            }
        }
    }

    private void handleEditOnArrayElement(TreeItem item) {
        if (!this.editSupportEnabled) {
            LOG.debug((Object)"edit support disabld");
            return;
        }
        this.combo = new Combo((Composite)this.annotationsviewer.getTree(), 8);
        this.combo.setItems(new String[]{"true", "false"});
        this.combo.setFocus();
        this.treeEditor.minimumHeight = this.combo.getSize().y;
        this.treeEditor.setEditor((Control)this.combo, item, 1);
        this.combo.select(this.combo.indexOf(this.treeEditor.getItem().getText(1)));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Loose catch block
             */
            public void widgetSelected(SelectionEvent event) {
                try {
                    try {
                        String originalValue = AnnotationView.this.treeEditor.getItem().getText(1);
                        String updatedValueStr = ((Combo)event.getSource()).getText();
                        AnnotationView.this.disposeEditWidgets();
                        if (!originalValue.equals(updatedValueStr)) {
                            Object[] data;
                            Boolean value = new Boolean(updatedValueStr);
                            AnnotationView.this.treeEditor.getItem().setText(1, updatedValueStr);
                            AnnotationView.this.treeEditor.getItem().setImage(value != false ? AnnotationView.this.iconOn : AnnotationView.this.iconOff);
                            Class topAnnoClass = (Class)AnnotationView.this.treeEditor.getItem().getParentItem().getParentItem().getData();
                            NormalAnnotation topAnnoNode = (NormalAnnotation)AnnotationView.this.annotationNodesMap.get(topAnnoClass.getSimpleName());
                            MemberValuePair mvp = null;
                            Method declaringMethod = (Method)AnnotationView.this.treeEditor.getItem().getParentItem().getData();
                            int i = 0;
                            while (i < topAnnoNode.values().size()) {
                                MemberValuePair pair = (MemberValuePair)topAnnoNode.values().get(i);
                                if (pair.getName().getIdentifier().equals(declaringMethod.getName())) {
                                    mvp = pair;
                                    break;
                                }
                                ++i;
                            }
                            List expList = ((ArrayInitializer)mvp.getValue()).expressions();
                            if (value.booleanValue()) {
                                try {
                                    data = (Object[])AnnotationView.this.treeEditor.getItem().getData();
                                    String className = (String)data[0];
                                    className = className.substring(0, className.indexOf(":"));
                                    Class<?> itemClass = Class.forName(className);
                                    NormalAnnotation anno = (NormalAnnotation)ScAnnotationSupportUtils.getDefaultedAnnotationNode(itemClass, AnnotationView.this.compilationUnitAstNode, AnnotationView.this.selectedJdtMember, AnnotationView.this.selectedJdtMethodParam);
                                    expList.add(anno);
                                    data[1] = anno;
                                }
                                catch (ClassNotFoundException data2) {}
                            } else {
                                data = (Object[])AnnotationView.this.treeEditor.getItem().getData();
                                String extraInfo = (String)data[0];
                                int pos = extraInfo.indexOf(":Existing");
                                String posStr = extraInfo.substring(pos + ":Existing".length());
                                expList.remove(Integer.valueOf(posStr));
                                data[1] = null;
                            }
                            ScJDTAnnUtils.addAnnotationToCu(AnnotationView.this.compilationUnitMember, AnnotationView.this.compilationUnitAstNode, (Annotation)topAnnoNode, AnnotationView.this.selectedJdtMember, AnnotationView.this.selectedJdtMethodParam);
                            AnnotationView.this.refreshViewContent();
                        }
                    }
                    catch (JavaModelException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        AnnotationView.this.disposeEditWidgets();
                    }
                    catch (MalformedTreeException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        AnnotationView.this.disposeEditWidgets();
                    }
                    catch (BadLocationException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        AnnotationView.this.disposeEditWidgets();
                    }
                }
                finally {
                    AnnotationView.this.disposeEditWidgets();
                }
            }
        });
    }

    private void handleEditOnAnnotation(TreeItem item) {
        if (!this.editSupportEnabled) {
            LOG.debug((Object)"edit support disabld");
            return;
        }
        this.combo = new Combo((Composite)this.annotationsviewer.getTree(), 8);
        this.combo.setItems(new String[]{"true", "false"});
        this.combo.setFocus();
        this.treeEditor.minimumHeight = this.combo.getSize().y;
        this.treeEditor.setEditor((Control)this.combo, item, 1);
        this.combo.select(this.combo.indexOf(this.treeEditor.getItem().getText(1)));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Loose catch block
             */
            public void widgetSelected(SelectionEvent event) {
                try {
                    try {
                        String originalValue = AnnotationView.this.treeEditor.getItem().getText(1);
                        String updatedValueStr = ((Combo)event.getSource()).getText();
                        AnnotationView.this.disposeEditWidgets();
                        if (!originalValue.equals(updatedValueStr)) {
                            Boolean value = new Boolean(updatedValueStr);
                            AnnotationView.this.treeEditor.getItem().setText(1, updatedValueStr);
                            AnnotationView.this.treeEditor.getItem().setImage(value != false ? AnnotationView.this.iconOn : AnnotationView.this.iconOff);
                            Class annotationClass = (Class)AnnotationView.this.treeEditor.getItem().getData();
                            String annotationName = annotationClass.getSimpleName();
                            if (value.booleanValue()) {
                                Annotation annotationNode = ScAnnotationSupportUtils.getDefaultedAnnotationNode(annotationClass, AnnotationView.this.compilationUnitAstNode, AnnotationView.this.selectedJdtMember, AnnotationView.this.selectedJdtMethodParam);
                                ScJDTAnnUtils.addAnnotationToCu(AnnotationView.this.compilationUnitMember, AnnotationView.this.compilationUnitAstNode, annotationNode, AnnotationView.this.selectedJdtMember, AnnotationView.this.selectedJdtMethodParam);
                            } else {
                                Annotation annotationNode = AnnotationView.this.annotationNodesMap.get(annotationName);
                                JDTUtils.removeAnnotationFromCu(AnnotationView.this.compilationUnitMember, AnnotationView.this.compilationUnitAstNode, annotationNode, AnnotationView.this.selectedJdtMember, AnnotationView.this.selectedJdtMethodParam);
                            }
                            AnnotationView.this.refreshViewContent();
                        }
                    }
                    catch (JavaModelException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        AnnotationView.this.disposeEditWidgets();
                    }
                    catch (MalformedTreeException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        AnnotationView.this.disposeEditWidgets();
                    }
                    catch (BadLocationException e) {
                        LOG.error((Object)"Java model update failed: ", (Throwable)e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        AnnotationView.this.disposeEditWidgets();
                    }
                }
                finally {
                    AnnotationView.this.disposeEditWidgets();
                }
            }
        });
    }

    private void handleEditOnStringAttribute(TreeItem item) {
        if (!this.editSupportEnabled) {
            return;
        }
        this.text = new Text((Composite)this.annotationsviewer.getTree(), 2048);
        this.text.setForeground(item.getForeground());
        this.text.setEditable(true);
        this.text.selectAll();
        this.text.setFocus();
        this.treeEditor.minimumWidth = this.text.getBounds().width;
        this.treeEditor.setEditor((Control)this.text, item, 1);
        this.text.setText(this.treeEditor.getItem().getText(1));
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!(AnnotationView.this.text == null || AnnotationView.this.text.isDisposed() || e.keyCode != 13 && e.keyCode != 0x1000050)) {
                    AnnotationView.this.processUpdateOnTextAttribute();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                AnnotationView.this.processUpdateOnTextAttribute();
            }
        });
    }

    private void handleEditOnNumericAttribute(TreeItem item) {
        if (!this.editSupportEnabled) {
            return;
        }
        this.text = new Text((Composite)this.annotationsviewer.getTree(), 2048);
        this.text.setForeground(item.getForeground());
        this.text.setEditable(true);
        this.text.selectAll();
        this.text.setFocus();
        this.treeEditor.minimumWidth = this.text.getBounds().width;
        this.treeEditor.setEditor((Control)this.text, item, 1);
        this.text.setText(this.treeEditor.getItem().getText(1));
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    AnnotationView.this.processUpdateOnNumericAttribute();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                AnnotationView.this.processUpdateOnNumericAttribute();
            }
        });
    }

    private void handleEditOnArrayAttribute(TreeItem item, Class returnTypeClass) {
        if (!this.editSupportEnabled) {
            return;
        }
        this.text = new Text((Composite)this.annotationsviewer.getTree(), 2048);
        this.text.setForeground(item.getForeground());
        this.text.setEditable(false);
        this.text.selectAll();
        this.text.setFocus();
        this.treeEditor.minimumWidth = this.text.getBounds().width;
        this.treeEditor.setEditor((Control)this.text, item, 1);
        this.text.setText(this.treeEditor.getItem().getText(1));
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!(AnnotationView.this.text == null || AnnotationView.this.text.isDisposed() || e.keyCode != 13 && e.keyCode != 0x1000050)) {
                    AnnotationView.this.processUpdateOnTextAttribute();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                AnnotationView.this.processUpdateOnTextAttribute();
            }
        });
    }

    private void handleEditOnEnumAttribute(TreeItem item, Class returnTypeClass) {
        if (!this.editSupportEnabled) {
            return;
        }
        final Object[] enumsConstants = returnTypeClass.getEnumConstants();
        this.combo = new Combo((Composite)this.annotationsviewer.getTree(), 8);
        this.combo.setBackground(item.getBackground());
        this.combo.setForeground(item.getForeground());
        this.combo.setFocus();
        String[] comboValues = new String[enumsConstants.length];
        int i = 0;
        while (i < enumsConstants.length) {
            comboValues[i] = enumsConstants[i].toString();
            ++i;
        }
        this.combo.setItems(comboValues);
        this.treeEditor.minimumHeight = this.combo.getSize().y;
        this.treeEditor.setEditor((Control)this.combo, item, 1);
        this.combo.select(this.combo.indexOf(this.treeEditor.getItem().getText(1)));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String originalValue = AnnotationView.this.treeEditor.getItem().getText(1);
                String updatedValueStr = ((Combo)event.getSource()).getText();
                AnnotationView.this.disposeEditWidgets();
                if (!originalValue.equals(updatedValueStr)) {
                    AnnotationView.this.treeEditor.getItem().setText(1, updatedValueStr);
                    int i = 0;
                    while (i < enumsConstants.length) {
                        if (enumsConstants[i].toString().endsWith(updatedValueStr)) {
                            AnnotationView.this.applyAnnotationAttributeUpdate(enumsConstants[i]);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void handleEditOnBooleanAttribute(TreeItem item) {
        if (!this.editSupportEnabled) {
            return;
        }
        this.combo = new Combo((Composite)this.annotationsviewer.getTree(), 8);
        this.combo.setBackground(item.getBackground());
        this.combo.setForeground(item.getForeground());
        this.combo.setFocus();
        this.combo.setItems(new String[]{new Boolean(true).toString().toLowerCase(), new Boolean(false).toString().toLowerCase()});
        this.treeEditor.minimumHeight = this.combo.getSize().y;
        this.treeEditor.setEditor((Control)this.combo, item, 1);
        this.combo.select(this.combo.indexOf(this.treeEditor.getItem().getText(1).toLowerCase()));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String originalValue = AnnotationView.this.treeEditor.getItem().getText(1);
                String updatedValueStr = ((Combo)event.getSource()).getText();
                AnnotationView.this.disposeEditWidgets();
                if (!originalValue.equals(updatedValueStr)) {
                    AnnotationView.this.treeEditor.getItem().setText(1, updatedValueStr);
                    AnnotationView.this.applyAnnotationAttributeUpdate(new Boolean(updatedValueStr));
                }
            }
        });
    }

    private void disposeEditWidgets() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
            this.text = null;
        }
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
            this.combo = null;
        }
    }

    private void updateViewContent(IMember selectedItem, int anOffset, boolean enableEditSupport) {
        if (selectedItem == null) {
            return;
        }
        LOG.debug((Object)("view updated, edit enabled : " + enableEditSupport));
        this.editSupportEnabled = enableEditSupport;
        this.selectedJdtMember = selectedItem;
        this.compilationUnitAstNode = JDTUtils.getDomRootCompilationUnit(this.selectedJdtMember);
        this.compilationUnitMember = this.selectedJdtMember.getCompilationUnit();
        this.offset = anOffset;
        this.selectedJdtMethodParam = selectedItem instanceof IMethod && this.offset > 0 ? JDTUtils.getMethodParamDeclaration(this.compilationUnitAstNode, (IMethod)this.selectedJdtMember, this.offset) : null;
        this.updateViewDescription();
        List<Annotation> annotationNodes = this.selectedJdtMethodParam != null ? JDTUtils.getAnnotationsFromParamDecl(this.selectedJdtMethodParam) : JDTUtils.getAnnotations(this.compilationUnitAstNode, this.selectedJdtMember);
        this.annotationNodesMap = new HashMap<String, Annotation>(annotationNodes.size());
        for (Annotation currentAnnotationNode : annotationNodes) {
            this.annotationNodesMap.put(currentAnnotationNode.getTypeName().getFullyQualifiedName(), currentAnnotationNode);
        }
        this.updateTreeContent();
        this.disposeEditWidgets();
    }

    private void refreshViewContent() {
        this.updateViewContent(this.selectedJdtMember, this.offset, this.editSupportEnabled);
    }

    private void updateViewDescription() {
        if (this.selectedJdtMember == null) {
            this.setContentDescription(CommonResources.getString("annotation.view.clear.lbl"));
            return;
        }
        int javaElementTypeId = this.selectedJdtMember.getElementType();
        String javaElementTypeLabel = javaElementTypeId == 7 ? CommonResources.getString("annotation.view.java.element.type.lbl") : (javaElementTypeId == 9 && this.selectedJdtMethodParam == null ? CommonResources.getString("annotation.view.java.element.method.lbl") : (javaElementTypeId == 9 && this.selectedJdtMethodParam != null ? CommonResources.getString("annotation.view.java.element.param.lbl") : (javaElementTypeId == 8 ? CommonResources.getString("annotation.view.java.element.field.lbl") : "")));
        StringBuffer desc = new StringBuffer(javaElementTypeLabel).append(" : ").append(this.selectedJdtMember.getElementName()).append(this.selectedJdtMethodParam != null ? " - " + this.selectedJdtMethodParam.getName().getIdentifier() : "").append(" --- ").append(this.selectedJdtMember.getCompilationUnit().getPath().lastSegment());
        if (!this.editSupportEnabled) {
            desc.append(" --- ").append(CommonResources.getString("annotation.view.view.mode.lbl"));
        }
        this.setContentDescription(desc.toString());
    }

    private void clearView() {
        this.annotationsviewer.setInput(null);
        this.annotationsviewer.refresh();
        this.setContentDescription(CommonResources.getString("annotation.view.clear.lbl"));
    }

    private void updateTreeContent() {
        Object[] expandedElements = this.annotationsviewer.getExpandedElements();
        SingleVariableDeclaration relevantInput = this.selectedJdtMethodParam != null ? this.selectedJdtMethodParam : this.selectedJdtMember;
        this.annotationsviewer.setInput((Object)relevantInput);
        this.annotationsviewer.refresh();
        this.annotationsviewer.setExpandedElements(expandedElements);
    }

    private void addOrUpdateAttributeInAnnotation(String attributeName, Object value, NormalAnnotation normalAnnotationNode) {
        List attributes = normalAnnotationNode.values();
        for (Object next : attributes) {
            MemberValuePair property;
            if (!(next instanceof MemberValuePair) || !(property = (MemberValuePair)next).getName().getIdentifier().equals(attributeName)) continue;
            normalAnnotationNode.values().remove(property);
            break;
        }
        if (value != null) {
            MemberValuePair valPair = JDTUtils.newMemberValuePair(this.compilationUnitAstNode, attributeName, value);
            attributes.add(valPair);
        }
    }

    private void applyAnnotationAttributeUpdate(Object formatedValue) {
        block24: {
            try {
                String attributeName = this.treeEditor.getItem().getText();
                if (this.treeEditor.getItem().getData() instanceof Method) {
                    Class annotationClass = (Class)this.treeEditor.getItem().getParentItem().getData();
                    Annotation annotationNode = this.annotationNodesMap.get(annotationClass.getSimpleName());
                    if (annotationNode == null) {
                        annotationNode = this.annotationNodesMap.get(annotationClass.getName());
                    }
                    if (annotationNode.isMarkerAnnotation()) {
                        return;
                    }
                    NormalAnnotation normalAnnotationNode = (NormalAnnotation)annotationNode;
                    Class<?> attributeType = annotationClass.getMethod(attributeName, null).getReturnType();
                    if (attributeType.equals(Class.class)) {
                        String attributeValue = (String)formatedValue;
                        if (attributeValue.endsWith(".class")) {
                            attributeValue = attributeValue.substring(0, attributeValue.length() - ".class".length());
                        }
                        try {
                            formatedValue = Class.forName(attributeValue);
                        }
                        catch (ClassNotFoundException e) {
                            try {
                                LOG.error((Object)("error to find class: " + attributeValue));
                                String originalClass = this.originalValue.substring(0, this.originalValue.length() - ".class".length());
                                formatedValue = Class.forName(originalClass);
                            }
                            catch (ClassNotFoundException originalClass) {}
                        }
                    } else {
                        attributeType.isArray();
                    }
                    this.addOrUpdateAttributeInAnnotation(attributeName, formatedValue, normalAnnotationNode);
                    ScJDTAnnUtils.addAnnotationToCu(this.compilationUnitMember, this.compilationUnitAstNode, (Annotation)normalAnnotationNode, this.selectedJdtMember, this.selectedJdtMethodParam);
                    this.refreshViewContent();
                    break block24;
                }
                if (this.treeEditor.getItem().getData() instanceof Object[]) {
                    Object[] pair = (Object[])this.treeEditor.getItem().getData();
                    Class annotationClass = null;
                    if (pair[0] instanceof Method) {
                        MemberValuePair mvp = (MemberValuePair)pair[1];
                        if (mvp != null && ((Method)pair[0]).getReturnType().equals(Class.class)) {
                            String substring;
                            String className = (String)formatedValue;
                            if (className.endsWith(".class")) {
                                className = className.substring(0, className.length() - ".class".length());
                            }
                            AST ast = this.compilationUnitAstNode.getAST();
                            int previousIndex = -1;
                            int nextIndex = className.indexOf(46);
                            SimpleType theType = nextIndex == -1 ? ast.newSimpleType((Name)ast.newSimpleName(className)) : ast.newSimpleType((Name)ast.newSimpleName(className.substring(1 + previousIndex, nextIndex)));
                            previousIndex = nextIndex;
                            nextIndex = className.indexOf(46, previousIndex + 1);
                            while (nextIndex != -1) {
                                substring = className.substring(1 + previousIndex, nextIndex);
                                theType = ast.newQualifiedType((Type)theType, ast.newSimpleName(substring));
                                previousIndex = nextIndex;
                                nextIndex = className.indexOf(46, previousIndex + 1);
                            }
                            if (previousIndex != -1) {
                                substring = className.substring(1 + previousIndex);
                                theType = ast.newQualifiedType((Type)theType, ast.newSimpleName(substring));
                            }
                            formatedValue = theType;
                        }
                        MemberValuePair tmp = JDTUtils.newMemberValuePair(this.compilationUnitAstNode, attributeName, formatedValue);
                        Object[] arrayItem = (Object[])this.treeEditor.getItem().getParentItem().getData();
                        NormalAnnotation na = (NormalAnnotation)arrayItem[1];
                        List list = na.values();
                        int i = 0;
                        while (i < list.size()) {
                            MemberValuePair item = (MemberValuePair)list.get(i);
                            if (item.getName().getIdentifier().equals(attributeName)) {
                                list.remove(i);
                                break;
                            }
                            ++i;
                        }
                        list.add(tmp);
                        pair[1] = tmp;
                        annotationClass = (Class)this.treeEditor.getItem().getParentItem().getParentItem().getParentItem().getData();
                    } else {
                        boolean cfr_ignored_0 = pair[0] instanceof String;
                    }
                    Annotation annotationNode = this.annotationNodesMap.get(annotationClass.getSimpleName());
                    NormalAnnotation normalAnnotationNode = (NormalAnnotation)annotationNode;
                    ScJDTAnnUtils.addAnnotationToCu(this.compilationUnitMember, this.compilationUnitAstNode, (Annotation)normalAnnotationNode, this.selectedJdtMember, this.selectedJdtMethodParam);
                    this.refreshViewContent();
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)"Java model update failed: ", (Throwable)e);
            }
            catch (MalformedTreeException e) {
                LOG.error((Object)"Java model update failed: ", (Throwable)e);
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Java model update failed: ", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"Java model update failed: ", (Throwable)e);
            }
        }
    }

    private void processUpdateOnNumericAttribute() {
        String originalValue = this.treeEditor.getItem().getText(1);
        String updatedValue = this.text.getText();
        this.disposeEditWidgets();
        if (!originalValue.equals(updatedValue)) {
            this.treeEditor.getItem().setText(1, updatedValue);
            Double value = updatedValue.trim().length() > 0 ? new Double(updatedValue) : null;
            this.applyAnnotationAttributeUpdate(value);
        }
    }

    private void processUpdateOnTextAttribute() {
        this.originalValue = this.treeEditor.getItem().getText(1);
        String updatedValue = this.text.getText().trim().length() > 0 ? this.text.getText() : null;
        this.disposeEditWidgets();
        if (!this.originalValue.equals(updatedValue) && (updatedValue != null || this.originalValue != null && this.originalValue != "")) {
            this.treeEditor.getItem().setText(1, updatedValue != null ? updatedValue : "");
            this.applyAnnotationAttributeUpdate(updatedValue);
        }
    }

    private class AnnotationSelectionListener
    implements INullSelectionListener {
        private AnnotationSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            try {
                if (sourcepart == null || sourcepart == AnnotationView.this) {
                    return;
                }
                if (sourcepart != AnnotationView.this && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((IStructuredSelection)selection).getFirstElement() instanceof IMember) {
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    IMember javaMember = (IMember)firstElement;
                    IResource javaResource = javaMember.getResource();
                    if (javaResource == null) {
                        AnnotationView.this.updateViewContent(javaMember, -1, false);
                    } else {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        int editorCount = activePage.findEditors((IEditorInput)new FileEditorInput((IFile)javaResource), AnnotationView.JAVA_EDITOR_ID, 3).length;
                        AnnotationView.this.updateViewContent(javaMember, -1, editorCount > 0);
                    }
                } else if (selection instanceof ITextSelection) {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage activePage = workbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    IEditorPart editor = activePage.getActiveEditor();
                    if (editor == null || editor.getSite().getPart() != sourcepart || !(editor.getEditorInput() instanceof IFileEditorInput)) {
                        AnnotationView.this.clearView();
                    }
                    AnnotationView.this.javaEditorInputFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
                    int offset = ((ITextSelection)selection).getOffset();
                    IJavaElement javaElement = JDTUtils.getJavaElementFromFile(AnnotationView.this.javaEditorInputFile, offset);
                    if (javaElement == null || !(javaElement instanceof IMember)) {
                        AnnotationView.this.clearView();
                    } else {
                        AnnotationView.this.updateViewContent((IMember)javaElement, offset, true);
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)"failed to handle selection change event", (Throwable)e);
                AnnotationView.this.clearView();
            }
        }
    }

    private class JavaEditorListener
    implements IPartListener2 {
        private JavaEditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            LOG.debug((Object)" part listener : 1");
            if (this.isEditorRelevant(partRef)) {
                AnnotationView.this.editSupportEnabled = true;
                AnnotationView.this.updateViewDescription();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            LOG.debug((Object)" part listener : 2");
            if (this.isEditorRelevant(partRef)) {
                AnnotationView.this.editSupportEnabled = false;
                AnnotationView.this.disposeEditWidgets();
                AnnotationView.this.updateViewDescription();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            LOG.debug((Object)" part listener : 3");
            if (this.isEditorRelevant(partRef)) {
                AnnotationView.this.clearView();
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            LOG.debug((Object)" part listener : 4");
            if (this.isEditorRelevant(partRef)) {
                AnnotationView.this.editSupportEnabled = true;
                AnnotationView.this.updateViewDescription();
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        private boolean isEditorRelevant(IWorkbenchPartReference partRef) {
            IWorkbenchPart part;
            if (AnnotationView.JAVA_EDITOR_ID.equals(partRef.getId()) && (part = partRef.getPart(false)) != null && part instanceof IEditorPart) {
                IEditorPart javaEditor = (IEditorPart)part;
                IFileEditorInput fileInput = (IFileEditorInput)javaEditor.getEditorInput();
                boolean a = fileInput.getFile().equals((Object)AnnotationView.this.javaEditorInputFile);
                LOG.debug((Object)(" isEditorRelevant : " + a));
                return a;
            }
            return false;
        }
    }
}

