/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.actions.CreateActionBase;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateWebMethodAction
extends CreateActionBase {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CreateWebMethodAction.class);

    public void dispose() {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            try {
                if (!(this.selection.getFirstElement() instanceof IMember)) {
                    return;
                }
                IMember selMember = (IMember)this.selection.getFirstElement();
                IResource javaFileResource = selMember.getResource();
                if (javaFileResource != null && !this.isJavaEditorOpen(javaFileResource)) {
                    this.openJavaEditor(javaFileResource);
                }
                CreateWebMethodWizard wizard = new CreateWebMethodWizard(selMember);
                if (PreferencesAccessor.areAnnWizardsDisplaied() || selMember instanceof IType) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new ScWizardDialog(shell, (IWizard)wizard).open();
                } else {
                    wizard.performFinish();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"exception on wizard run", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        Object selectedObject;
        super.selectionChanged(action, sel);
        if (sel != null && sel instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)sel).getFirstElement()) instanceof IMethod) {
            try {
                action.setEnabled(false);
                IJavaElement parent = ((IMethod)selectedObject).getParent();
                if (parent instanceof IType && ((IType)parent).isInterface()) {
                    action.setEnabled(true);
                } else {
                    int flags = ((IMethod)selectedObject).getFlags();
                    if (Flags.isPublic((int)flags)) {
                        action.setEnabled(true);
                    }
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)"error during checking method flags", (Throwable)e);
            }
        }
    }
}

