/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.FacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxWsFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWsFacetInstallDelegate.class);
    public static String MODULE_TYPE = "stp.jaxws.component";
    public static String MODULE_VERSION = "2.0";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("Installing JAX-WS facet", 1);
        }
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            WtpUtils.addNatures((IProject)project);
            IVirtualComponent c = ComponentCore.createComponent((IProject)project);
            c.create(0, null);
            c.setMetaProperty("java-output-path", "/classes/");
            IVirtualFolder jaxwsRoot = c.getRootFolder();
            Object srcFolder = null;
            jaxwsRoot.createLink((IPath)new Path("/src"), 0, null);
            jaxwsRoot.createLink((IPath)new Path("/wsdl"), 0, null);
            jaxwsRoot.createLink((IPath)new Path("/Webcontext/WEB-INF"), 0, null);
            jaxwsRoot.createLink((IPath)new Path("/Webcontext/META-INF/lib"), 0, null);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addJaxWsFacet(IProject project) {
        try {
            WtpUtils.addNatures((IProject)project);
            FacetUtils.addFacetNature((IProject)project);
            FacetUtils.addFacet((IProject)project, (String)FacetUtils.JAVA_FACET, (String)FacetUtils.JAVA_FACET_VERSION);
            FacetUtils.addFacet((IProject)project, (String)MODULE_TYPE, (String)MODULE_VERSION);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)"error when setup jaxws facet.", (Throwable)e);
        }
    }
}

