/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.annotations.ScJDTAnnUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.utils.JaxBindAnnotationUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScJDTUtils
extends ScJDTAnnUtils {
    public static IPath[] getProjectSrcPaths(IProject project) {
        ArrayList<IPath> srcPaths = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpaths = javaProject.getRawClasspath();
            int i = 0;
            while (i < classpaths.length) {
                if (classpaths[i].getEntryKind() == 3) {
                    srcPaths.add(classpaths[i].getPath());
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (srcPaths.size() == 0) {
            srcPaths.add(JaxWsWorkspaceManager.getSrcFolder(project).getProjectRelativePath());
        }
        return srcPaths.toArray(new IPath[0]);
    }

    public static void addAnnotationImport(CompilationUnit compilationUnitAstNode, Annotation annotationNode, ASTRewrite rewrite) {
        String fullAnno = ScAnnotationSupportUtils.getAnnotationImport((Annotation)annotationNode);
        if (fullAnno == null) {
            fullAnno = JaxBindAnnotationUtils.getAnnotationImport(annotationNode);
        }
        if (fullAnno != null) {
            JDTUtils.addImport((CompilationUnit)compilationUnitAstNode, (String)fullAnno, (ASTRewrite)rewrite);
        }
    }

    public static IFile getFileFromContainer(IContainer container, String fileName) {
        if (container instanceof IProject) {
            return ((IProject)container).getFile(fileName);
        }
        return ((IFolder)container).getFile(fileName);
    }
}

