/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.facet.JaxWsFacetInstallDelegate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IEnableJaxwsHook;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;

public class EnableWizardBase
extends Wizard {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableWizardBase.class);
    public static final String RUNTIME_PAGE = "runtimePage";
    IProject project;
    RuntimeSelectionPage runtimeSelectionPage;

    public EnableWizardBase(IProject project) {
        this.project = project;
    }

    public void addPages() {
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        if (!runtimeMgr.getUseDefaultRuntime()) {
            this.runtimeSelectionPage = new RuntimeSelectionPage(RUNTIME_PAGE, ScJaxWsResources.getString("runtimepage.title"), null);
            this.addPage((IWizardPage)this.runtimeSelectionPage);
        }
    }

    public boolean performFinish() {
        try {
            JaxWsFacetInstallDelegate.addJaxWsFacet(this.project);
            RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
            String runtimeType = null;
            String runtimeID = null;
            if (!runtimeMgr.getUseDefaultRuntime()) {
                runtimeType = this.runtimeSelectionPage.getRuntimeType();
                RuntimeCore.setRuntimeType((IProject)this.project, (String)runtimeType);
                runtimeID = this.runtimeSelectionPage.getRuntimeID();
                RuntimeCore.setRuntimeID((IProject)this.project, (String)runtimeID);
            } else {
                runtimeType = runtimeMgr.getDefaultRuntimeType();
                RuntimeCore.setRuntimeType((IProject)this.project, (String)runtimeType);
                runtimeID = runtimeMgr.getDefaultRuntimeID();
                RuntimeCore.setRuntimeID((IProject)this.project, (String)runtimeID);
            }
            ScNature.addToProject(this.project, null);
            this.doAnother();
            IEnableJaxwsHook enableHook = runtimeMgr.getEnableJaxwsHook(runtimeType);
            if (enableHook != null) {
                enableHook.run(this.project);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error whilc enabling jaxws", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected void doAnother() {
    }
}

