/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIResources;

public class JaxwsriStartingPointPageContents
extends AbstractStartingPointPageContents {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxwsriStartingPointPageContents.class);
    public static final String PAGE_NAME = "JAX-WS RI Starting Point Page";

    public String validateStartingPoint(String startingPoint) {
        String returnValue = null;
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            try {
                File file = new File(startingPoint);
                reader = new FileReader(file);
                br = new BufferedReader(reader);
                String s1 = null;
                while ((s1 = br.readLine()) != null) {
                    buffer.append(String.valueOf(s1) + "\n");
                }
                char[] charSet = new char[buffer.length()];
                buffer.getChars(0, buffer.length() - 1, charSet, 0);
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(charSet);
                CompilationUnit domCu = (CompilationUnit)parser.createAST(null);
                List types = domCu.types();
                boolean isValid = false;
                int i = 0;
                while (i < types.size()) {
                    Object type = types.get(i);
                    if (type instanceof TypeDeclaration) {
                        if (((TypeDeclaration)type).isInterface()) {
                            returnValue = "Interface cannot be set as starting point in JAX-WS RI runtime.";
                            break;
                        }
                        int modifiers = ((TypeDeclaration)type).getModifiers();
                        if (Modifier.isPublic((int)modifiers)) {
                            if (Modifier.isAbstract((int)modifiers)) {
                                returnValue = "Abstract class cannot be set as starting point in JAX-WS RI runtime.";
                                break;
                            }
                            isValid = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (returnValue == null && !isValid) {
                    returnValue = "this is invalid java class file";
                }
            }
            catch (Exception ex) {
                returnValue = "error while validating the starting point file: " + startingPoint;
                LOG.error((Object)returnValue, (Throwable)ex);
                try {
                    reader.close();
                    br.close();
                    buffer = null;
                }
                catch (Exception ex2) {
                    LOG.error((Object)ex2);
                }
            }
        }
        finally {
            try {
                reader.close();
                br.close();
                buffer = null;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
        return returnValue;
    }

    public String getDescription() {
        return JAXWSRIResources.getString("Wizard.StartingPoint.Page.Description");
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public String getTitle() {
        return JAXWSRIResources.getString("Wizard.StartingPoint.Page.Title");
    }
}

