/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sca.diagram.part.Messages;
import org.eclipse.stp.sca.diagram.part.ScaCreationWizardPage;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ScaCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected ScaCreationWizardPage diagramModelFilePage;
    protected ScaCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.ScaCreationWizardTitle);
        this.setDefaultPageImageDescriptor(ScaDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewScaWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new ScaCreationWizardPage("DiagramModelFile", this.getSelection(), "composite_diagram");
        this.diagramModelFilePage.setTitle(Messages.ScaCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.ScaCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    private Resource getDomainModelFilePage() {
        URI uri = URI.createURI((String)this.diagramModelFilePage.getURI().toString().replaceAll("composite_diagram", "composite"));
        ResourceImpl domainModelFilePage = new ResourceImpl(uri);
        return domainModelFilePage;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                ScaCreationWizard.this.diagram = ScaDiagramEditorUtil.createDiagram(ScaCreationWizard.this.diagramModelFilePage.getURI(), ScaCreationWizard.this.getDomainModelFilePage().getURI(), monitor);
                if (ScaCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && ScaCreationWizard.this.diagram != null) {
                    try {
                        ScaDiagramEditorUtil.openDiagram(ScaCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)ScaCreationWizard.this.getContainer().getShell(), (String)Messages.ScaCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ScaCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                ScaDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

