/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class DeployConfigurationDeployAPIAdapter
extends AdapterImpl
implements IDeployAPIAdapter {
    public boolean isAdapterForType(Object type) {
        return type == IDeployAPIAdapter.class;
    }

    public IDeployTarget asDeployTarget() {
        IPackageConstructorExtension idde;
        IDeployTarget idt = null;
        IPackage ip = this.asPackage();
        IServer server = this.asServer();
        IServerType serverType = DeploymentUtil.convertWTPServerTypeToSTPServerType(server.getServerType());
        if (ip instanceof IServiceDescriptor && (idde = DeploymentExtensionManager.getInstance().getPackageConstructor((IServiceDescriptor)ip, serverType)) != null) {
            idt = idde.adaptServer(server);
        }
        return idt;
    }

    public IServiceDescriptor asLogicalPackage() {
        IFile file = this.getFile();
        IServiceDescriptor ilp = file == null ? null : DeploymentExtensionManager.getInstance().getLogicalPackage(file);
        return ilp;
    }

    public IConfigurablePackage asConfigurablePackage() {
        IFile file = this.getFile();
        IConfigurablePackage icp = file == null ? null : DeploymentExtensionManager.getInstance().getConfigurablePackage(file);
        return icp;
    }

    public IPackage asPackage() {
        IPackage ip;
        IFile file = this.getFile();
        if (file == null) {
            ip = null;
        } else {
            ip = DeploymentExtensionManager.getInstance().getPackage(file);
            if (ip instanceof IPhysicalPackage) {
                ip = this.asPhysicalPackage();
            }
        }
        return ip;
    }

    public IPhysicalPackage asPhysicalPackage() {
        IFile file = this.getFile();
        if (file == null) {
            Object ipp = null;
        } else {
            IServer server;
            IPhysicalPackage ipp = DeploymentExtensionManager.getInstance().getPhysicalPackage(file);
            List packageExtensions = DeploymentExtensionManager.getInstance().getPhysicalPackageExtensions(file.getFileExtension());
            if (ipp != null && packageExtensions.size() > 0 && (server = this.asServer()) != null) {
                return ipp;
            }
        }
        return null;
    }

    public IServer asServer() {
        DeployServer server = ((DeployConfiguration)this.getTarget()).getTargetServer();
        if (server == null) {
            return null;
        }
        return ServerCore.findServer((String)server.getServerId());
    }

    private IFile getFile() {
        try {
            DeployPackage dp = ((DeployConfiguration)this.getTarget()).getSourcePackage();
            String path = dp.getPackageFile();
            URL url = FileLocator.toFileURL((URL)new URL(dp.eResource().getURI().toString()));
            IFile deployFile = DeployCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(url.getPath()));
            IProject project = deployFile.getProject();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile retVal = project.getFile(path);
            Iterator<IProject> it = Arrays.asList(project.getReferencedProjects()).iterator();
            while (!retVal.exists() && it.hasNext()) {
                project = it.next();
                retVal = project.getFile(path);
            }
            if (!retVal.exists()) {
                retVal = root.getFile((IPath)new Path(path));
            }
            if (retVal.exists()) {
                return retVal;
            }
        }
        catch (MalformedURLException retVal) {
        }
        catch (IOException retVal) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

