/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.runtime.cxf.internal.simplefrontend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.deploy.DeployException;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.utils.PackageHelper;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.deploy.runtime.cxf.internal.simplefrontend.SimpleWebDeployDescriptor;
import org.eclipse.stp.soas.deploy.tomcat.WarPackageOutputDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePackageConstructor
implements IPackageConstructor {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(SimplePackageConstructor.class);
    private static String WAR_FILE_EXTENSION = ".war";
    private IProject project;
    private PackageHelper pkgHelper;

    public List<IPackageOutputDescriptor> createPackage(IServiceDescriptor pkg, IPackageCreationContext context, IPackageConfiguration configuration) throws CoreException {
        block4: {
            IFile tempFile = pkg.getFile();
            this.project = tempFile.getProject();
            File outputFolder = context.getOutputFolder();
            try {
                IContainer container = JaxWsWorkspaceManager.getWSDLFolder((IProject)this.project);
                IFile webXmlFile = ScJDTUtils.getFileFromContainer((IContainer)container, (String)"web.xml");
                if (!webXmlFile.exists()) {
                    IPath path = RuntimeCore.getInstallPath((IProject)this.project);
                    String webXmlFilePath = String.valueOf(path.toOSString()) + File.separator + "etc" + File.separator + "web.xml";
                    LOG.debug((Object)("web.xml file to copy:" + webXmlFilePath));
                    JaxWsWorkspaceManager.copyFile((String)webXmlFilePath, (IFile)webXmlFile, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                }
                LOG.debug((Object)"generating cxf_servlet.xml...");
                this.generateServletConf(this.project);
                this.project.refreshLocal(2, null);
                LOG.debug((Object)"generating war file");
                this.pkgHelper = new PackageHelper(this.project.getFile(String.valueOf(this.project.getName()) + ".wsdl"), WAR_FILE_EXTENSION);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(URIUtil.toPath((URI)outputFolder.toURI()));
                IFolder folder = tempFile.getProject().getFolder(file.getProjectRelativePath());
                this.pkgHelper.startToPackage(folder);
                this.pkgHelper.stopPackage();
                this.project.refreshLocal(2, null);
                if (context.getTarget() != null) break block4;
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"deploy error", (Throwable)e);
                LOG.error((Object)"create package error", (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stp.soas.deploy.runtime.cxf", 0, ScJaxWsResources.getString((String)"error.deploy.assemble"), (Throwable)e));
            }
        }
        IServerType ist = DeploymentUtil.convertWTPServerTypeToSTPServerType((org.eclipse.wst.server.core.IServerType)context.getTarget().getServerType());
        ArrayList<IPackageOutputDescriptor> rtnValue = new ArrayList<IPackageOutputDescriptor>();
        rtnValue.add((IPackageOutputDescriptor)new WarPackageOutputDescriptor(this.pkgHelper.getPackageFile(), pkg.getTechnologyType(), ist, this.pkgHelper.getPackageFile().getPath(), this.pkgHelper.getPackageFile().getName()));
        return rtnValue;
    }

    private void generateServletConf(IProject proj) throws DeployException {
        try {
            LinkedList<SimpleWebDeployDescriptor> descList = new LinkedList<SimpleWebDeployDescriptor>();
            descList.add(this.generateEndpointConf(proj));
            IFile configFile = JaxWsWorkspaceManager.getServletConfigFile((IProject)proj);
            this.writeServletConfig(configFile.getRawLocation().toOSString(), descList);
        }
        catch (CoreException coreE) {
            LOG.error((Object)coreE);
            throw new DeployException("Error during generate servlet config:" + coreE.toString(), (Throwable)coreE);
        }
    }

    private SimpleWebDeployDescriptor generateEndpointConf(IProject proj) throws CoreException {
        SimpleWebDeployDescriptor desc = new SimpleWebDeployDescriptor();
        desc.setEndpointName(proj.getName());
        desc.setPattern(proj.getName());
        String interfaceName = "";
        String implName = "";
        String startPoint = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
        IFile startPointFile = proj.getFile(startPoint);
        ICompilationUnit icu = JDTUtils.getJavaUnitFromFile((IFile)startPointFile);
        IType type = icu.findPrimaryType();
        if (type.isInterface()) {
            interfaceName = type.getFullyQualifiedName();
            implName = String.valueOf(interfaceName) + "PortTypeImpl";
        } else {
            implName = type.getFullyQualifiedName();
            String[] interfaceNames = type.getSuperInterfaceNames();
            if (interfaceNames != null && interfaceNames.length == 1) {
                ITypeHierarchy hi = type.newSupertypeHierarchy(null);
                interfaceName = hi.getSuperInterfaces(type)[0].getFullyQualifiedName();
            } else {
                interfaceName = null;
            }
        }
        desc.setImplClsName(implName);
        desc.setServiceClsName(interfaceName);
        LOG.debug((Object)"------- endponit cfg ------");
        LOG.debug((Object)desc.toString());
        LOG.debug((Object)"------- endponit cfg ------");
        return desc;
    }

    private void writeServletConfig(String fileName, List<SimpleWebDeployDescriptor> descList) throws DeployException {
        try {
            FileOutputStream fos = new FileOutputStream(fileName, false);
            PrintStream ps = new PrintStream(fos);
            ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ps.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
            ps.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            ps.println("xmlns:simple=\"http://cxf.apache.org/simple\"");
            ps.println("xmlns:soap=\"http://cxf.apache.org/bindings/soap\"");
            ps.println("xsi:schemaLocation=\"");
            ps.println("http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd");
            ps.println("http://cxf.apache.org/bindings/soap http://cxf.apache.org/schemas/configuration/soap.xsd");
            ps.println("http://cxf.apache.org/simple http://cxf.apache.org/schemas/simple.xsd\">");
            ps.println("\n");
            for (SimpleWebDeployDescriptor desc : descList) {
                desc.serizlize(fos);
            }
            ps.println("</beans>");
            ps.close();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new DeployException("Error during write cxf-servlet.xml file", (Throwable)e);
        }
    }
}

