/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.runtime.jaxwsri.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stp.soas.deploy.runtime.jaxwsri.JaxwsRIRuntimeResources;
import org.eclipse.stp.soas.deploy.runtime.jaxwsri.core.internal.IJaxwsRIRuntimeWorkingCopy;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class JaxwsRIRuntimeComposite
extends Composite {
    protected final String CXF_RUNTIME_ID = "org.eclipse.stp.soas.deploy.runtime.jaxwsri.212";
    protected IRuntimeWorkingCopy runtimeWC;
    protected IJaxwsRIRuntimeWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text installDir;
    protected Text name;
    protected Combo combo;
    protected List installedJREs;
    protected String[] jreNames;

    protected JaxwsRIRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(JaxwsRIRuntimeResources.getString("wizard.title"));
        wizard.setDescription(JaxwsRIRuntimeResources.getString("wizard.desc"));
        wizard.setImageDescriptor(JaxwsRIRuntimeResources.getImageDescriptor("wizban/wizRI.gif"));
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (IJaxwsRIRuntimeWorkingCopy)newRuntime.loadAdapter(IJaxwsRIRuntimeWorkingCopy.class, null);
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 0);
        label.setText(JaxwsRIRuntimeResources.getString("wizard.name.label"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JaxwsRIRuntimeComposite.this.runtimeWC.setName(JaxwsRIRuntimeComposite.this.name.getText());
                JaxwsRIRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(JaxwsRIRuntimeResources.getString("wizard.install.dir"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JaxwsRIRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(JaxwsRIRuntimeComposite.this.installDir.getText()));
                JaxwsRIRuntimeComposite.this.validate();
            }
        });
        Button browse = new Button((Composite)this, 8);
        browse.setText(JaxwsRIRuntimeResources.getString("wizard.browse.btn"));
        data = new GridData(256);
        browse.setLayoutData((Object)data);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(JaxwsRIRuntimeComposite.this.getShell());
                dialog.setMessage(JaxwsRIRuntimeResources.getString("wizard.browse.dialog.desc"));
                dialog.setFilterPath(JaxwsRIRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    JaxwsRIRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        final IInstallableRuntime ir = ServerPlugin.findInstallableRuntime((String)"org.eclipse.stp.soas.deploy.runtime.jaxwsri.212");
        if (ir != null) {
            label = new Label((Composite)this, 0);
            Button install = new Button((Composite)this, 8);
            install.setText(JaxwsRIRuntimeResources.getString("wizard.Install.btn"));
            data = new GridData(256);
            install.setLayoutData((Object)data);
            install.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    DirectoryDialog dialog = new DirectoryDialog(JaxwsRIRuntimeComposite.this.getShell());
                    dialog.setMessage("Messages.selectInstallDir");
                    dialog.setFilterPath(JaxwsRIRuntimeComposite.this.installDir.getText());
                    String selectedDirectory = dialog.open();
                    if (selectedDirectory != null) {
                        ir.install((IPath)new Path(selectedDirectory));
                        JaxwsRIRuntimeComposite.this.installDir.setText(selectedDirectory);
                    }
                }
            });
        }
        this.updateJREs();
        label = new Label((Composite)this, 0);
        label.setText(JaxwsRIRuntimeResources.getString("wizard.jre.label"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(this.jreNames);
        data = new GridData(256);
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = JaxwsRIRuntimeComposite.this.combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)JaxwsRIRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                JaxwsRIRuntimeComposite.this.runtime.setVMInstall(vmInstall);
                JaxwsRIRuntimeComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = new Button((Composite)this, 8);
        button.setText(JaxwsRIRuntimeResources.getString("wizard.installJre.label"));
        data = new GridData(256);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = JaxwsRIRuntimeComposite.this.combo.getText();
                if (JaxwsRIRuntimeComposite.this.showPreferencePage()) {
                    JaxwsRIRuntimeComposite.this.updateJREs();
                    JaxwsRIRuntimeComposite.this.combo.setItems(JaxwsRIRuntimeComposite.this.jreNames);
                    JaxwsRIRuntimeComposite.this.combo.setText(currentVM);
                    if (JaxwsRIRuntimeComposite.this.combo.getSelectionIndex() == -1) {
                        JaxwsRIRuntimeComposite.this.combo.select(0);
                    }
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = JaxwsRIRuntimeResources.getString("wizard.defaultJre");
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode("org.eclipse.jdt.debug.ui.preferences.VMPreferencePage");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (this.runtime.isUsingDefaultJRE()) {
            this.combo.select(0);
        } else {
            boolean found = false;
            int size = this.installedJREs.size();
            int i = 0;
            while (i < size) {
                IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
                if (vmInstall.equals(this.runtime.getVMInstall())) {
                    this.combo.select(i + 1);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.combo.select(0);
            }
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }
}

