/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.soas.internal.deploy.ui.ISharedGraphicConstants;
import org.eclipse.stp.soas.internal.deploy.ui.ImageDescriptorRegistry;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.graphics.Image;

public class SharedImages
implements ISharedGraphicConstants {
    public static final String ICONS_PATH = "icons/";
    public static final String SIZE_NONE = "0";
    public static final String SIZE_16 = "16";
    public static final String SIZE_32 = "32";
    public static final String SIZE_48 = "48";
    private static Map descriptors = new HashMap();
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry imageDescriptorRegistry;
    private static DeployUtilPlugin plugin;

    static {
        plugin = DeployUtilPlugin.getDefault();
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            SharedImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        SharedImages.loadImages();
        return imageRegistry;
    }

    public static final ImageDescriptor getImageDescriptor(String symbolicName, String size) {
        ImageDescriptor desc = null;
        try {
            String path = size.compareToIgnoreCase(SIZE_NONE) == 0 ? ICONS_PATH + symbolicName + ".gif" : ICONS_PATH + symbolicName + "_" + size + ".gif";
            desc = ImageDescriptor.createFromURL((URL)plugin.getBundle().getEntry(path));
            if (desc.getImageData() == null) {
                desc = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        catch (Exception e) {
            desc = ImageDescriptor.getMissingImageDescriptor();
        }
        return desc;
    }

    private static final void loadImageDescriptor(String key, String size) {
        descriptors.put(String.valueOf(key) + "_" + size, SharedImages.getImageDescriptor(key, size));
    }

    public static final Image getImage(String symbolicName, String size) {
        if (imageRegistry == null) {
            SharedImages.initializeImageRegistry();
        }
        String symName = symbolicName.toUpperCase();
        String key = String.valueOf(symName) + "_" + size;
        Image img = imageRegistry.get(key = key.toUpperCase());
        if (img == null) {
            ImageDescriptor desc = null;
            try {
                desc = (ImageDescriptor)descriptors.get(key);
                img = desc.createImage();
                imageRegistry.put(key, img);
            }
            catch (Exception e) {
                SharedImages.loadImageDescriptor(symName, size);
                desc = (ImageDescriptor)descriptors.get(key);
                img = desc.createImage();
                imageRegistry.put(key, img);
            }
        }
        return img;
    }

    private static void loadImages() {
        SharedImages.loadImageDescriptor("PROPERTIES", SIZE_16);
    }

    public static final synchronized ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (imageDescriptorRegistry == null) {
            imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return imageDescriptorRegistry;
    }
}

