/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPageContainer;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class Dialog
extends TitleAreaDialog
implements IDialogPageContainer {
    public static final int APPLY_ID = 100;
    public static final String APPLY_LABEL = DeployUtilPlugin.getDefault().getResourceString("Dialog.LABEL.apply");
    private IDialogPage mPage;
    private String mPageMessage;
    private String mPageDescription;
    private int mPageMessageType = 0;
    private Button mApply;
    private boolean mWasModified = false;

    public Dialog(Shell parent, IDialogPage page) {
        super(parent.getShell());
        this.mPage = page;
        this.mPage.setContainer(this);
    }

    public Dialog(Shell parent, IDialogPage page, int style) {
        this(parent.getShell(), page);
        this.setShellStyle(this.getShellStyle() | style);
    }

    public boolean wasModified() {
        return this.mWasModified;
    }

    public void closeCancel() {
        this.cancelPressed();
    }

    public void closeOK() {
        this.okPressed();
    }

    protected boolean performOk() {
        boolean success = this.mPage.performOk();
        if (success) {
            this.mWasModified = true;
        }
        return success;
    }

    protected boolean performCancel() {
        return this.mPage.performCancel();
    }

    protected void performApply() {
        if (this.mPage.performApply()) {
            this.mWasModified = true;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (100 == buttonId) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        if (this.performOk()) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.performCancel()) {
            super.cancelPressed();
        }
    }

    protected void applyPressed() {
        this.performApply();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.mPage.needsApplyButton()) {
            this.mApply = this.createButton(parent, 100, APPLY_LABEL, false);
        }
    }

    public void updateButtons() {
        boolean pageValid = this.mPage.isValid();
        this.getButton(0).setEnabled(pageValid);
        this.getButton(1).setEnabled(true);
        if (this.mApply != null) {
            this.mApply.setEnabled(pageValid && this.mPage.isModified());
        }
    }

    public void updateMessage() {
        if (this.getShell() == null) {
            return;
        }
        this.mPageMessage = this.mPage.getMessage();
        this.mPageMessageType = this.mPageMessage != null && this.mPage instanceof IMessageProvider ? ((IMessageProvider)this.mPage).getMessageType() : 0;
        if (this.mPageMessage == null) {
            this.setMessage(this.mPageDescription);
        } else {
            this.setMessage(this.mPageMessage, this.mPageMessageType);
        }
        this.setErrorMessage(this.mPage.getErrorMessage());
    }

    public void updateTitleBar() {
        if (this.getShell() == null) {
            return;
        }
        String s = this.mPage.getTitle();
        if (s == null) {
            s = "";
        }
        this.setTitle(s);
        this.setTitleImage(this.mPage.getImage());
        this.updateDescriptionMessage();
        this.updateMessage();
    }

    private void updateDescriptionMessage() {
        this.mPageDescription = this.mPage.getDescription();
        if (this.mPageMessage == null) {
            this.setMessage(this.mPage.getDescription());
        }
    }

    private void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
    }

    private void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String title = this.mPage.getTitle();
        if (title == null) {
            title = "";
        }
        this.getShell().setText(title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.mPage.createControl((Composite)this.getDialogArea());
        this.update();
        return contents;
    }

    public boolean close() {
        this.mPage.dispose();
        this.mPage.setContainer(null);
        return super.close();
    }
}

