/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLEditPage
extends StructuredTextEditor
implements IFormPage,
IGotoMarker {
    private final String title;
    private XefEditor editor;
    private final String id;
    private Control control;
    private int index;

    public XMLEditPage(XefEditor editor, String id, String t) throws PartInitException {
        this.id = id;
        this.initialize(editor);
        this.init(editor.getEditorSite(), editor.getEditorInput());
        this.title = t;
    }

    public void initialize(FormEditor formEditor) {
        this.editor = (XefEditor)formEditor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            SAXBuilder builder = new SAXBuilder();
            Document xmlDoc = builder.build((InputStream)new ByteArrayInputStream(doc.get().getBytes()));
            doc.set(new XMLOutputter(Format.getPrettyFormat()).outputString(xmlDoc));
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPartName(this.title);
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
        if (active) {
            this.syncFromModel();
        }
    }

    void syncFromModel() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        String xml = this.editor.policyEditPage.getXML();
        if (!xml.equals(doc.get())) {
            try {
                doc.set(xml);
            }
            catch (RuntimeException re) {
                if (System.getProperty("test.mode") != null && re.getClass().getName().equals("org.eclipse.jface.text.Assert$AssertionFailedException")) {
                    re.printStackTrace();
                }
                throw re;
            }
        }
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals(this.editor.getActivePageInstance());
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.fireSaveNeeded(this.getEditorInput(), true);
        } else {
            super.firePropertyChange(type);
        }
    }
}

