/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.editor.AddElementAction;
import org.eclipse.stp.ui.xef.editor.ChangePrefixAction;
import org.eclipse.stp.ui.xef.editor.DeleteElementAction;
import org.eclipse.stp.ui.xef.editor.IXefDetailsPage;
import org.eclipse.stp.ui.xef.editor.MasterContentProvider;
import org.eclipse.stp.ui.xef.editor.MasterLabelProvider;
import org.eclipse.stp.ui.xef.editor.SchemaSelectionDialog;
import org.eclipse.stp.ui.xef.editor.Setting;
import org.eclipse.stp.ui.xef.editor.SnippetDetailsPage;
import org.eclipse.stp.ui.xef.editor.SnippetRepresentingXMLInstanceElements;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefDetailsPage;
import org.eclipse.stp.ui.xef.editor.XefEditPage;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.stp.ui.xef.help.XefHelpView;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.ISchemaProviderExt;
import org.eclipse.stp.xef.SchemaProviderFilterWrapper;
import org.eclipse.stp.xef.ValidationProblem;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.XMLModelFactory;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.XMLUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XefEditMasterDetailsBlock
extends MasterDetailsBlock
implements IDetailsPageProvider {
    private static final String INITIAL_DESCRIPTION = "";
    private static final String RIGHT_CLICK_DESCRIPTION_TEXT = "Right-Click element to specify additional information";
    private static final String RIGHT_CLICK_DESCRIPTION = "[Right-Click element to specify additional information]";
    private static final String VERIFIED_LABEL = "verified";
    private static final String CUSTOMIZED_LABEL = "customized";
    private static final String UNVERIFIABLE = "cannot be verified";
    private static SAXBuilder builder = new SAXBuilder();
    static boolean interactive = true;
    MenuManager menuManager;
    Button addButton;
    AddButtonSelectionListener addButtonListener;
    Button deleteButton;
    final ChangePrefixAction changePrefixAction;
    final DeleteElementAction deleteAction;
    Action helpAction;
    Element baseElement;
    List<XMLInstanceElement> policies = new LinkedList<XMLInstanceElement>();
    static WeakHashMap<XMLInstanceElement, String> policyLabels = new WeakHashMap();
    TreeViewer viewer;
    boolean asyncUpdate = true;
    private final XefEditPage editPage;
    private String original;
    private Section section;
    private boolean dirty;
    private volatile boolean decorationJobScheduled = false;

    public XefEditMasterDetailsBlock(XefEditPage page) {
        this.editPage = page;
        this.changePrefixAction = new ChangePrefixAction(this);
        this.deleteAction = new DeleteElementAction(this, this.editPage);
    }

    protected void createMasterPart(final IManagedForm managedForm, final Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.section = toolkit.createSection(parent, 384);
        this.section.setText("Applied Policies");
        this.section.setDescription(INITIAL_DESCRIPTION);
        this.section.marginWidth = 10;
        this.section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)this.section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Tree t = toolkit.createTree(client, 4);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        gd.verticalSpan = 2;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.addButton = toolkit.createButton(client, "Add Policy...", 8);
        gd = new GridData(258);
        this.addButton.setLayoutData((Object)gd);
        this.deleteButton = toolkit.createButton(client, "Delete", 8);
        gd = new GridData(258);
        this.deleteButton.setLayoutData((Object)gd);
        this.section.setClient((Control)client);
        final SectionPart spart = new SectionPart(this.section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TreeViewer(t);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel;
                Object el;
                IDetailsPage curPage;
                if (!XefEditMasterDetailsBlock.this.validateCurrentDetailsPage() && (curPage = XefEditMasterDetailsBlock.this.getDetailsPart().getCurrentPage()) instanceof XefDetailsPage) {
                    XefEditMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)((XefDetailsPage)curPage).element));
                    return;
                }
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (el = (ssel = (IStructuredSelection)sel).getFirstElement()) instanceof XMLInstanceElement) {
                    XMLInstanceElement pi = (XMLInstanceElement)el;
                    XefEditMasterDetailsBlock.this.updateDescription(pi);
                    XefEditMasterDetailsBlock.this.setHelpText(pi);
                    return;
                }
            }
        });
        this.addButtonListener = new AddButtonSelectionListener(parent);
        this.addButton.addSelectionListener((SelectionListener)this.addButtonListener);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)XefEditMasterDetailsBlock.this.viewer.getSelection();
                if (ssel.size() != 1) {
                    MessageDialog dlg = new MessageDialog(parent.getShell(), "Delete Policy", parent.getShell().getDisplay().getSystemImage(2), "Please select the policy to remove first.", 1, new String[]{"OK"}, 0);
                    dlg.open();
                } else {
                    XefEditMasterDetailsBlock.this.deleteAction.run();
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new MasterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MasterLabelProvider());
        this.viewer.setInput(this.policies);
        this.menuManager = this.initContextMenu(this.viewer);
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private MenuManager initContextMenu(final TreeViewer treeViewer) {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                XefEditMasterDetailsBlock.this.fillContextMenu(treeViewer, mgr);
            }
        });
        return mgr;
    }

    void fillContextMenu(TreeViewer treeViewer, IMenuManager mgr) {
        if (mgr == null) {
            return;
        }
        if (!(this.viewer.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        Object el = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (el instanceof XMLInstanceElement) {
            XMLInstanceElement pi = (XMLInstanceElement)el;
            for (SchemaElement se : XefEditMasterDetailsBlock.getAllowedChildren(pi)) {
                mgr.add((IAction)new AddElementAction("Add " + se.getDisplayName(true), pi, se, treeViewer, this));
            }
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.deleteAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.changePrefixAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.helpAction);
        } else if (el instanceof SnippetRepresentingXMLInstanceElements) {
            mgr.add((IAction)this.deleteAction);
        }
    }

    protected void updateDescription(XMLInstanceElement pi) {
        if (XefEditMasterDetailsBlock.getAllowedChildren(pi).size() > 0) {
            this.section.setDescription(RIGHT_CLICK_DESCRIPTION);
            this.viewer.getTree().setToolTipText(String.valueOf(XefEditMasterDetailsBlock.getLabel(pi)) + " - " + RIGHT_CLICK_DESCRIPTION_TEXT);
        } else {
            this.section.setDescription(INITIAL_DESCRIPTION);
            this.viewer.getTree().setToolTipText(INITIAL_DESCRIPTION);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    IAction getAction(String actionID) {
        if (actionID.equals(ActionFactory.DELETE.getId())) {
            return this.deleteAction;
        }
        return null;
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageLimit(10);
        detailsPart.setPageProvider((IDetailsPageProvider)this);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                XefEditMasterDetailsBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText("Switch to horizonal orientation");
        haction.setImageDescriptor(XefPlugin.getDefault().getImageRegistry().getDescriptor("horizontal"));
        Action vaction = new Action("ver", 8){

            public void run() {
                XefEditMasterDetailsBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText("Switch to vertical orientation");
        vaction.setImageDescriptor(XefPlugin.getDefault().getImageRegistry().getDescriptor("vertical"));
        this.helpAction = new Action("Help", 1){

            public void run() {
                try {
                    XMLInstanceElement pi;
                    String docText;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = page.showView("org.eclipse.stp.ui.xef.help.XefHelpView");
                    if (view instanceof XefHelpView && (docText = (pi = XefEditMasterDetailsBlock.this.getSelectedPolicyInstanceElement()).getTemplate().getDocumentation()) != null) {
                        ((XefHelpView)view).setHTMLText("<h3>" + XefEditMasterDetailsBlock.getLabel(pi) + "</h3>", docText);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.helpAction.setToolTipText("Show Policy Help");
        this.helpAction.setImageDescriptor(XefPlugin.getDefault().getImageRegistry().getDescriptor("help"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
        form.getToolBarManager().add((IAction)this.helpAction);
    }

    public Object getPageKey(Object object) {
        return object;
    }

    public IDetailsPage getPage(Object key) {
        if (key instanceof XMLInstanceElement) {
            return new XefDetailsPage((XefEditor)this.editPage.getEditor(), (XMLInstanceElement)key);
        }
        if (key instanceof SnippetRepresentingXMLInstanceElements) {
            return new SnippetDetailsPage();
        }
        return null;
    }

    public synchronized String getXML() {
        Document document;
        try {
            document = builder.build((InputStream)new ByteArrayInputStream(this.original.getBytes()));
        }
        catch (Exception e) {
            document = new Document();
            document.setRootElement(new Element(this.baseElement.getName(), this.baseElement.getNamespace()));
        }
        Element root = document.getRootElement();
        Element newBase = root.getName().equals(this.baseElement.getName()) && root.getNamespace().equals((Object)this.baseElement.getNamespace()) ? root : root.getChild(this.baseElement.getName(), Namespace.getNamespace((String)this.baseElement.getNamespaceURI()));
        XefEditMasterDetailsBlock.cloneJDOMAttributes(newBase, this.baseElement);
        for (XMLInstanceElement policy : this.policies) {
            newBase.addContent((Content)policy.getJDOMElement());
        }
        return new XMLOutputter(Format.getPrettyFormat()).outputString(document);
    }

    private static void cloneJDOMAttributes(Element newBase, Element oldBase) {
        newBase.removeContent();
        ArrayList attributes = new ArrayList(newBase.getAttributes());
        for (Attribute attr : attributes) {
            newBase.removeAttribute(attr);
        }
        for (Attribute attr : oldBase.getAttributes()) {
            newBase.setAttribute(attr);
        }
    }

    public DetailsPart getDetailsPart() {
        return this.detailsPart;
    }

    void setDirty(boolean value) {
        this.dirty = value;
        this.editPage.getManagedForm().dirtyStateChanged();
        IDetailsPage details = this.detailsPart.getCurrentPage();
        if (details instanceof IXefDetailsPage) {
            ((IXefDetailsPage)details).setDirty(value);
        }
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean validate() {
        if (!this.validateCurrentDetailsPage()) {
            return false;
        }
        IDetailsPage curPage = this.getDetailsPart().getCurrentPage();
        if (curPage != null) {
            curPage.commit(false);
        }
        for (XMLInstanceElement policy : this.policies) {
            IDetailsPage details;
            ValidationProblem vp = policy.validate();
            if (vp == null) continue;
            XMLInstanceElement inst = vp.getXMLInstanceElement();
            this.getViewer().reveal((Object)inst);
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)inst));
            if (interactive) {
                new MessageDialog(this.getViewer().getControl().getShell(), "Value required", null, vp.getMessage(), 2, new String[]{"OK"}, 0).open();
            }
            if ((details = this.detailsPart.getCurrentPage()) instanceof XefDetailsPage) {
                ((XefDetailsPage)details).setFocus(vp.getProblemObject());
            }
            return false;
        }
        return true;
    }

    private boolean validateCurrentDetailsPage() {
        IDetailsPage curPage = this.getDetailsPart().getCurrentPage();
        if (curPage instanceof XefDetailsPage) {
            return ((XefDetailsPage)curPage).validate();
        }
        return true;
    }

    XMLInstanceElement getSelectedPolicyInstanceElement() {
        ISelection sel = this.viewer.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        Object el = ssel.getFirstElement();
        if (!(el instanceof XMLInstanceElement)) {
            return null;
        }
        return (XMLInstanceElement)el;
    }

    static List<SchemaElement> getAllowedChildren(XMLInstanceElement pi) {
        if (pi.getTemplate() == null) {
            return Collections.emptyList();
        }
        LinkedList<SchemaElement> children = new LinkedList<SchemaElement>();
        for (XMLInstanceElement i : pi.getChildren()) {
            children.add(i.getTemplate());
        }
        return pi.getTemplate().getNestedElements(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getLabel(Object element) {
        if (element instanceof XMLInstanceElement) {
            XMLInstanceElement pi = (XMLInstanceElement)element;
            WeakHashMap<XMLInstanceElement, String> weakHashMap = policyLabels;
            synchronized (weakHashMap) {
                String label = policyLabels.get(element);
                if (label == null) {
                    SchemaElement se = pi.getTemplate();
                    if (se != null) {
                        label = se.getDisplayName();
                    }
                    if (label == null) {
                        label = element.toString();
                    }
                    policyLabels.put(pi, label);
                }
                return label;
            }
        }
        return element.toString();
    }

    void initializePolicies(String originalXML, Element root, String rootElementQName, List<XMLInstanceElement> newPolicies) {
        QName qn = QName.valueOf(rootElementQName);
        this.original = originalXML;
        String prefix = XMLUtil.inferNamespacePrefix(qn.getNamespaceURI());
        this.baseElement = root == null ? new Element(qn.getLocalPart(), prefix, qn.getNamespaceURI()) : root;
        this.policies = newPolicies == null ? new LinkedList() : newPolicies;
        this.getViewer().setInput(this.policies);
        this.policiesChanged(newPolicies.toArray(new XMLInstanceElement[newPolicies.size()]));
    }

    private XMLInstanceElement findApplicableDocumentationElement(XMLInstanceElement pi) {
        if (pi.getTemplate() == null) {
            return pi;
        }
        if (pi.getTemplate().getDocumentation() == null && pi.getParent() != null) {
            return this.findApplicableDocumentationElement(pi.getParent());
        }
        return pi;
    }

    protected String constructPath(XMLInstanceElement pi) {
        String path = INITIAL_DESCRIPTION;
        if (pi.getParent() != null) {
            path = String.valueOf(path) + this.constructPath(pi.getParent()) + "/";
        }
        path = String.valueOf(path) + pi.toString();
        return path;
    }

    void setHelpText(final XMLInstanceElement pi) {
        Runnable setHelp = new Runnable(){

            public void run() {
                XMLInstanceElement docEl = XefEditMasterDetailsBlock.this.findApplicableDocumentationElement(pi);
                String path = XefEditMasterDetailsBlock.this.constructPath(docEl);
                path = path.equals(docEl.toString()) ? XefEditMasterDetailsBlock.INITIAL_DESCRIPTION : "(" + path + ")";
                IWorkbenchPage page = XefEditMasterDetailsBlock.this.editPage.getSite().getWorkbenchWindow().getActivePage();
                IViewPart view = page.findView("org.eclipse.stp.ui.xef.help.XefHelpView");
                if (view instanceof XefHelpView) {
                    String docText = docEl.getTemplate().getDocumentation();
                    if (docText == null) {
                        docText = XefEditMasterDetailsBlock.INITIAL_DESCRIPTION;
                    }
                    ((XefHelpView)view).setHTMLText("<font size=\"+1\"><b>" + XefEditMasterDetailsBlock.getLabel(docEl) + "</b></font> <font size=\"-1\">" + path + "</font><p/>", docText);
                }
            }
        };
        if (this.asyncUpdate) {
            this.editPage.getSite().getShell().getDisplay().asyncExec(setHelp);
        } else {
            setHelp.run();
        }
    }

    private ISchemaProvider getSchemaProvider() {
        return ((XMLProviderEditorInput)this.editPage.getEditorInput()).getSchemaProvider();
    }

    void policiesChanged(final XMLInstanceElement ... updatedPolicies) {
        if (this.decorationJobScheduled) {
            return;
        }
        if (updatedPolicies.length == 0) {
            return;
        }
        Job j = new Job("Inspecting XML snippet bases"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    XefEditMasterDetailsBlock.this.decorateSnippets(XefEditMasterDetailsBlock.this.viewer, updatedPolicies);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    XefEditMasterDetailsBlock.this.decorationJobScheduled = false;
                }
            }
        };
        j.setPriority(50);
        j.schedule();
        this.decorationJobScheduled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decorateSnippets(final TreeViewer viewer, XMLInstanceElement ... updatedPolicies) {
        Object l;
        HashMap<String, LinkedList<XMLInstanceElement>> snippets = new HashMap<String, LinkedList<XMLInstanceElement>>();
        XMLInstanceElement[] xMLInstanceElementArray = updatedPolicies;
        int n = updatedPolicies.length;
        int n2 = 0;
        while (n2 < n) {
            XMLInstanceElement policy = xMLInstanceElementArray[n2];
            String basedOn = policy.getBasedOnSnippet();
            if (basedOn != null) {
                l = (LinkedList<XMLInstanceElement>)snippets.get(basedOn);
                if (l == null) {
                    l = new LinkedList<XMLInstanceElement>();
                    snippets.put(basedOn, (LinkedList<XMLInstanceElement>)l);
                }
                l.add(policy);
            }
            ++n2;
        }
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        for (Map.Entry entry : snippets.entrySet()) {
            Document snippetDoc;
            String snippet = "<policies>" + this.getSchemaProvider().getSnippet((String)entry.getKey()) + "</policies>";
            l = this;
            synchronized (l) {
                try {
                    snippetDoc = builder.build((InputStream)new ByteArrayInputStream(snippet.getBytes()));
                }
                catch (Exception e) {
                    snippetDoc = null;
                }
            }
            if (snippetDoc != null) {
                for (XMLInstanceElement pi : (List)entry.getValue()) {
                    StringBuilder sb = new StringBuilder(pi.toString());
                    sb.append(" (");
                    Element root = snippetDoc.getRootElement();
                    Element el = pi.getJDOMElement();
                    if (this.elementsEqual(outputter, el, root.getChild(el.getName(), el.getNamespace()))) {
                        sb.append(VERIFIED_LABEL);
                    } else {
                        sb.append(CUSTOMIZED_LABEL);
                    }
                    sb.append(')');
                    policyLabels.put(pi, sb.toString());
                }
            } else {
                String decoration = " (cannot be verified)";
                for (XMLInstanceElement pi : (List)entry.getValue()) {
                    policyLabels.put(pi, String.valueOf(pi.toString()) + decoration);
                }
            }
            this.editPage.getSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    viewer.refresh(true);
                }
            });
        }
    }

    private boolean elementsEqual(XMLOutputter outputter, Element el1, Element el2) {
        if (el1 == null && el2 == null) {
            return true;
        }
        if (el1 == null || el2 == null) {
            return false;
        }
        this.removeAllComments(el1);
        this.removeAllComments(el2);
        String s1 = outputter.outputString(el1);
        String s2 = outputter.outputString(el2);
        return s1.equals(s2);
    }

    private void removeAllComments(Element el) {
        for (Object obj : new ArrayList(el.getContent())) {
            if (obj instanceof Element) {
                this.removeAllComments((Element)obj);
                continue;
            }
            if (!(obj instanceof Comment)) continue;
            el.removeContent((Content)((Comment)obj));
        }
    }

    final class AddButtonSelectionListener
    extends SelectionAdapter {
        SchemaSelectionDialog currentDialog;
        final Composite parent;
        final XMLProviderEditorInput input;

        private AddButtonSelectionListener(Composite p) {
            this.parent = p;
            IEditorInput i = XefEditMasterDetailsBlock.this.editPage.getEditorInput();
            this.input = i instanceof XMLProviderEditorInput ? (XMLProviderEditorInput)i : null;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean unique = Boolean.parseBoolean(this.input.getSetting(Setting.POLICIES_UNIQUE));
            SchemaProviderFilterWrapper wrapper = new SchemaProviderFilterWrapper(this.input.getSchemaProvider(), XefEditMasterDetailsBlock.this.policies, unique);
            this.widgetSelected(new SchemaSelectionDialog(this.parent.getShell(), (ISchemaProviderExt)wrapper, wrapper.getShadowProvider()), e);
        }

        void widgetSelected(SchemaSelectionDialog dlg, SelectionEvent e) {
            this.currentDialog = dlg;
            dlg.setBlockOnOpen(interactive && Boolean.valueOf(this.input.getSetting(Setting.TESTING_MODE)) == false);
            if (dlg == null) {
                MessageDialog md = new MessageDialog(this.parent.getShell(), "Add Policy", this.parent.getShell().getDisplay().getSystemImage(2), "No policies can be added.", 1, new String[]{"OK"}, 0);
                md.open();
                return;
            }
            if (dlg.open() == 0) {
                XMLInstanceElement[] instances = null;
                Object dialogResult = dlg.getFirstResult();
                if (dialogResult instanceof SchemaElement) {
                    instances = new XMLInstanceElement[]{this.handleAddPolicy((SchemaElement)dialogResult)};
                } else if (dialogResult instanceof XMLSnippet) {
                    instances = this.handleAddSnippet((XMLSnippet)dialogResult);
                }
                XefEditMasterDetailsBlock.this.viewer.refresh();
                if (instances != null && instances.length > 0) {
                    XMLInstanceElement instance = instances[instances.length - 1];
                    if (dialogResult instanceof XMLSnippet) {
                        XefEditMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection(instance.getData(SnippetRepresentingXMLInstanceElements.class)), true);
                    } else {
                        XefEditMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)instance), true);
                    }
                    XefEditMasterDetailsBlock.this.policiesChanged(instances);
                }
                XefEditMasterDetailsBlock.this.setDirty(true);
            }
        }

        private XMLInstanceElement handleAddPolicy(SchemaElement policy) {
            XMLInstanceElement pi = new XMLInstanceElement(policy);
            pi.addMinimalSubElements();
            XefEditMasterDetailsBlock.this.policies.add(pi);
            return pi;
        }

        private XMLInstanceElement[] handleAddSnippet(XMLSnippet snippet) {
            try {
                String ns = "http://www.example.com/2007/03/pe";
                LinkedList<XMLInstanceElement> elements = new LinkedList<XMLInstanceElement>();
                ISchemaProvider schemaProvider = XefEditMasterDetailsBlock.this.getSchemaProvider();
                String snippetContent = snippet.getSnippet();
                snippetContent = "<pe:pe xmlns:pe='" + ns + "'>" + snippetContent + "</pe:pe>";
                XMLModelFactory.createFromXML(snippetContent, "{" + ns + "}pe", elements, true, schemaProvider);
                for (XMLInstanceElement element : elements) {
                    element.setBasedOnSnippet(snippet.getName());
                    XefEditMasterDetailsBlock.this.policies.add(element);
                }
                return elements.toArray(new XMLInstanceElement[elements.size()]);
            }
            catch (Exception ex) {
                Status status = new Status(4, "org.eclipse.stp.xef", 0, "Problem applying selection", (Throwable)ex);
                MessageDialog.openError((Shell)this.parent.getShell(), (String)"There was a problem applying the selection", (String)status.toString());
                XefPlugin.getDefault().getLog().log((IStatus)status);
                return null;
            }
        }
    }
}

