/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaRegistry {
    private static final SchemaRegistry SINGLETON;
    private final SchemaParser parser;
    private Map<String, List<SchemaElement>> schemaToTopElementsMap = new HashMap<String, List<SchemaElement>>();
    private Map<String, List<SchemaElement>> schemaToAllElementsMap = new HashMap<String, List<SchemaElement>>();

    static {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        SINGLETON = new SchemaRegistry();
    }

    public SchemaRegistry() {
        try {
            this.parser = new SchemaParser();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static SchemaRegistry getDefault() {
        return SINGLETON;
    }

    public void clear() {
        this.schemaToTopElementsMap = new HashMap<String, List<SchemaElement>>();
        this.schemaToAllElementsMap = new HashMap<String, List<SchemaElement>>();
    }

    public List<SchemaElement> resolveSchemaFromURL(String url, ISchemaProvider ... providers) throws Exception {
        return this.resolveSchemaFromURL(url, false, providers);
    }

    List<SchemaElement> resolveSchemaFromURL(String url, boolean all, ISchemaProvider ... providers) throws Exception {
        return this.parser.parseAndRegister(url, all, providers);
    }

    public List<SchemaElement> resolveSchemaFromXML(String xml, boolean cache, ISchemaProvider ... providers) throws Exception {
        return this.resolveSchemaFromXML(xml, false, cache, providers);
    }

    List<SchemaElement> resolveSchemaFromXML(String xml, boolean all, boolean cache, ISchemaProvider ... providers) throws Exception {
        File temp = File.createTempFile("temp", "xsd");
        try {
            FileOutputStream os = new FileOutputStream(temp);
            try {
                InputStreamHelper.drain((InputStream)new ByteArrayInputStream(xml.getBytes()), (OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
            LinkedList<SchemaElement> topElements = new LinkedList<SchemaElement>();
            LinkedList<SchemaElement> allElements = new LinkedList<SchemaElement>();
            String ns = this.parser.parse(temp.toURI().toString(), topElements, allElements, providers);
            if (cache) {
                this.registerSchema(ns, topElements, allElements);
            }
            LinkedList<SchemaElement> linkedList = all ? allElements : topElements;
            return linkedList;
        }
        finally {
            temp.delete();
        }
    }

    public static List<String> getEntryElementsFromURL(String url, ISchemaProvider ... providers) throws Exception {
        SchemaRegistry temp = new SchemaRegistry();
        List<SchemaElement> elements = temp.resolveSchemaFromURL(url, false, providers);
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (SchemaElement el : elements) {
            result.add(el.getName());
        }
        return result;
    }

    public static List<String> getEntryElementsFromXML(String xml, String targetNamespace, ISchemaProvider ... providers) throws Exception {
        SchemaRegistry temp = new SchemaRegistry();
        List<SchemaElement> elements = temp.resolveSchemaFromXML(xml, false, false, providers);
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (SchemaElement el : elements) {
            if (targetNamespace != null && !el.getNameSpace().equals(targetNamespace)) continue;
            result.add(el.getName());
        }
        return result;
    }

    private void registerSchema(String uri, List<SchemaElement> topElements, List<SchemaElement> allElements) {
        this.schemaToTopElementsMap.put(uri, topElements);
        this.schemaToAllElementsMap.put(uri, allElements);
    }

    public List<SchemaElement> getEntryElements(String uri, boolean resolve, boolean cache, ISchemaProvider ... providers) {
        return this.getElements(false, uri, resolve, cache, providers);
    }

    public List<SchemaElement> getAllElements(String uri, boolean resolve, boolean cache, ISchemaProvider ... providers) {
        return this.getElements(true, uri, resolve, cache, providers);
    }

    private List<SchemaElement> getElements(boolean all, String uri, boolean resolve, boolean cache, ISchemaProvider ... providers) {
        List<SchemaElement> els = null;
        if (cache) {
            Map<String, List<SchemaElement>> map = all ? this.schemaToAllElementsMap : this.schemaToTopElementsMap;
            els = map.get(uri);
        }
        if (els == null && resolve) {
            try {
                ISchemaProvider[] iSchemaProviderArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaProvider provider = iSchemaProviderArray[n2];
                    String schema = provider.getSchema(uri);
                    if (schema != null) {
                        return this.resolveSchemaFromXML(schema, all, cache, providers);
                    }
                    ++n2;
                }
                return this.resolveSchemaFromURL(uri, all, providers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return els;
    }

    public SchemaElement getSchemaElement(String uri, String name, boolean cache, ISchemaProvider ... providers) {
        List<SchemaElement> els = this.getAllElements(uri, true, cache, providers);
        if (els != null) {
            for (SchemaElement el : els) {
                if (!el.getName().equals(name)) continue;
                return el;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SchemaParser
    implements DOMErrorHandler {
        private final DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        private final XSImplementation xsImpl = (XSImplementation)this.registry.getDOMImplementation("XS-Loader");
        private final XSLoader schemaLoader = this.xsImpl.createXSLoader(null);
        private final DOMConfiguration domConfig;
        private final SchemaProviderResourceResolver resolver = new SchemaProviderResourceResolver();

        private SchemaParser() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.domConfig = this.schemaLoader.getConfig();
            this.domConfig.setParameter("error-handler", this);
            this.domConfig.setParameter("resource-resolver", this.resolver);
        }

        private synchronized String parse(String uri, List<SchemaElement> elements, List<SchemaElement> allElements, ISchemaProvider ... providers) {
            try {
                this.resolver.setProviders(providers);
                XSModel model = this.schemaLoader.loadURI(uri);
                if (model == null) {
                    throw new NullPointerException("No document found at " + uri);
                }
                elements.addAll(this.initTopLevelEntryElements(model, allElements));
                XSNamespaceItemList nsItems = model.getNamespaceItems();
                int i = 0;
                while (i < nsItems.getLength()) {
                    XSNamespaceItem nsItem = nsItems.item(i);
                    if (!"http://www.w3.org/2001/XMLSchema".equals(nsItem.getSchemaNamespace())) {
                        String string = nsItem.getSchemaNamespace();
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            finally {
                this.resolver.setProviders(new ISchemaProvider[0]);
            }
        }

        private synchronized List<SchemaElement> parseAndRegister(String uri, boolean all, ISchemaProvider ... providers) {
            ArrayList<SchemaElement> entryElements = new ArrayList<SchemaElement>();
            ArrayList<SchemaElement> allElements = new ArrayList<SchemaElement>();
            String ns = this.parse(uri, entryElements, allElements, providers);
            SchemaRegistry.this.registerSchema(ns, entryElements, allElements);
            return all ? allElements : entryElements;
        }

        @Override
        public boolean handleError(DOMError err) {
            System.out.println("*** Error Parsing XML Document - " + err.getMessage());
            ((Throwable)err.getRelatedException()).printStackTrace();
            return false;
        }

        private List<SchemaElement> initTopLevelEntryElements(XSModel model, List<SchemaElement> allElements) {
            SchemaElement se;
            LinkedList<XSElementDeclaration> topElements = new LinkedList<XSElementDeclaration>();
            HashSet<XSElementDeclaration> referencedElements = new HashSet<XSElementDeclaration>();
            XSNamedMap map = model.getComponents((short)2);
            int i = 0;
            while (i < map.getLength()) {
                XSElementDeclaration element = (XSElementDeclaration)map.item(i);
                topElements.add(element);
                this.initTopLevelEntryElements(element, referencedElements);
                ++i;
            }
            for (XSElementDeclaration referenced : referencedElements) {
                topElements.remove(referenced);
            }
            ArrayList<SchemaElement> l = new ArrayList<SchemaElement>(topElements.size());
            for (XSElementDeclaration element : topElements) {
                se = new SchemaElement(element, null, null);
                l.add(se);
                allElements.add(se);
            }
            for (XSElementDeclaration element : referencedElements) {
                se = new SchemaElement(element, null, null);
                allElements.add(se);
            }
            return l;
        }

        private void initTopLevelEntryElements(XSElementDeclaration element, Set<XSElementDeclaration> referencedElements) {
            XSTerm groupTerm;
            XSComplexTypeDefinition ctd;
            XSParticle groupParticle;
            XSTypeDefinition typeDef = element.getTypeDefinition();
            if (typeDef instanceof XSComplexTypeDefinition && (groupParticle = (ctd = (XSComplexTypeDefinition)typeDef).getParticle()) != null && (groupTerm = groupParticle.getTerm()) instanceof XSModelGroup) {
                XSModelGroup group = (XSModelGroup)groupTerm;
                XSObjectList elements = group.getParticles();
                this.initTopLevelEntryElements(elements, referencedElements);
            }
        }

        private void initTopLevelEntryElements(XSObjectList elements, Set<XSElementDeclaration> referencedElements) {
            int i = 0;
            while (i < elements.getLength()) {
                XSObject obj = elements.item(i);
                if (obj instanceof XSParticle) {
                    XSParticle particle = (XSParticle)obj;
                    XSTerm particleTerm = particle.getTerm();
                    if (particleTerm instanceof XSElementDeclaration) {
                        XSElementDeclaration referencedElement = (XSElementDeclaration)particleTerm;
                        if (!referencedElements.contains(referencedElement)) {
                            referencedElements.add(referencedElement);
                            this.initTopLevelEntryElements(referencedElement, referencedElements);
                        }
                    } else if (particleTerm instanceof XSModelGroup) {
                        XSModelGroup group = (XSModelGroup)particleTerm;
                        XSObjectList groupElements = group.getParticles();
                        this.initTopLevelEntryElements(groupElements, referencedElements);
                    }
                }
                ++i;
            }
        }
    }

    private static class SchemaProviderResourceResolver
    implements LSResourceResolver {
        ICatalog wtpXMLCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        private ISchemaProvider[] providers = new ISchemaProvider[0];

        private SchemaProviderResourceResolver() {
        }

        void setProviders(ISchemaProvider ... p) {
            this.providers = p;
        }

        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            String schema;
            block8: {
                schema = null;
                ISchemaProvider[] iSchemaProviderArray = this.providers;
                int n = this.providers.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaProvider p = iSchemaProviderArray[n2];
                    schema = p.getSchema(namespaceURI);
                    if (schema != null) break;
                    ++n2;
                }
                if (schema == null) {
                    String url = null;
                    try {
                        url = this.wtpXMLCatalog.resolvePublic(publicId, systemId);
                        if (url == null) {
                            url = this.wtpXMLCatalog.resolveSystem(systemId);
                        }
                        if (url == null) break block8;
                        InputStream is = null;
                        try {
                            is = new URL(url).openStream();
                            schema = new String(InputStreamHelper.drain((InputStream)is));
                        }
                        catch (Throwable throwable) {
                            InputStreamHelper.close(is);
                            throw throwable;
                        }
                        InputStreamHelper.close((InputStream)is);
                    }
                    catch (IOException e) {
                        Status st = new Status(2, "org.eclipse.stp.xef", 0, "Problem accessing WTP XML Catalog", (Throwable)e);
                        XefPlugin.getDefault().getLog().log((IStatus)st);
                    }
                }
            }
            if (schema != null) {
                return new DOMInputImpl(publicId, systemId, baseURI, schema, null);
            }
            return null;
        }
    }
}

