/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef.util;

import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QNameHelper {
    static final String SEPARATOR = ":";
    private static final String FULLNAME_PATTERN = "\\{.*\\}.*";
    private static final String FULLNAME_START = "{";
    private static final String FULLNAME_END = "}";

    private QNameHelper() {
    }

    public static String convertToQName(String prefix, String local) {
        return String.valueOf(prefix) + SEPARATOR + local;
    }

    public static String getPrefixFromQName(String qname) {
        String prefix = "";
        if (qname.contains(SEPARATOR)) {
            prefix = qname.substring(0, qname.indexOf(SEPARATOR));
        }
        return prefix;
    }

    public static String getLocalFromQName(String qname) {
        String local = qname;
        if (qname.lastIndexOf(SEPARATOR) != -1) {
            local = qname.substring(qname.lastIndexOf(SEPARATOR) + 1);
        }
        return local;
    }

    public static String getNamespaceFromFullName(String fullName) {
        if (!Pattern.matches(FULLNAME_PATTERN, fullName)) {
            return "";
        }
        return fullName.substring(fullName.indexOf(FULLNAME_START) + 1, fullName.lastIndexOf(FULLNAME_END));
    }

    public static String getLocalNameFromFullName(String fullName) {
        String localName = "";
        if (fullName.contains(FULLNAME_END)) {
            localName = fullName.substring(fullName.indexOf(FULLNAME_END) + 1);
        }
        return localName;
    }

    public static String convertToFullName(String ns, String local) {
        String name = "";
        if (ns != null && ns.length() != 0) {
            name = String.valueOf(name) + FULLNAME_START + ns + FULLNAME_END;
        }
        return String.valueOf(name) + local;
    }

    public static String getNamespaceFromQName(Map<String, String> map, String qname) {
        String namespace = "";
        String prefix = QNameHelper.getPrefixFromQName(qname);
        if (map != null && map.get(prefix) != null) {
            namespace = map.get(prefix);
        }
        return namespace;
    }
}

