/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.base.ValidationMessage;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SopwareParticularityValidator
implements IValidator {
    private static final Logger LOG = Logger.getLogger(SopwareParticularityValidator.class);
    private static final QName ASSERTION_CHOICE = new QName("http://www.w3.org/2006/07/ws-policy", "ExactlyOne");
    private static final QName ASSERTION_UNION = new QName("http://www.w3.org/2006/07/ws-policy", "All");
    private static final QName ATTR_ASSERTION_OPTIONAL = new QName("http://www.w3.org/2006/07/ws-policy", "Optional");
    private static final String MSG_BUNDLE_NAME = "messages";

    public void validate(IValidationContext pValidationContext, IReporter pReporter) throws SOPValidationException {
        try {
            LOG.debug((Object)"Perfroming SOPERA Particularity validation");
            IValidationObject valObj = pValidationContext.getObject();
            if (valObj == null) {
                LOG.error((Object)"Empty object for validation");
                throw new SOPValidationException("Empty object for validation");
            }
            if (valObj.getID().getType().equals(ValidationObjectTypeEnum.SDX_TYPE)) {
                this.checkSDX(valObj, pReporter);
            } else if (valObj.getID().getType().equals(ValidationObjectTypeEnum.OPX_TYPE)) {
                this.checkOPDX(valObj, pReporter);
            } else if (valObj.getID().getType().equals(ValidationObjectTypeEnum.PPDX_TYPE)) {
                this.checkPPDX(valObj, pReporter);
            } else if (valObj.getID().getType().equals(ValidationObjectTypeEnum.SPDX_TYPE)) {
                this.checkSPDX(valObj, pReporter);
            }
        }
        catch (SOPValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SOPValidationException("Unexpected problem while performing SOPERA Particularity validation", e);
        }
    }

    private void checkSDX(IValidationObject valObj, IReporter pReporter) throws SOPValidationException {
        Document sdxDocument = this.getInputDocument(valObj);
        NodeList nlDefinitions = sdxDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "definitions");
        if (1 != nlDefinitions.getLength()) {
            this.report(valObj, pReporter, "A Service Description should have a WSDL definitions element.");
        } else {
            List nlPartnerLinkType;
            List nlPortType;
            List nlBinding;
            Element nDefinitions = (Element)nlDefinitions.item(0);
            List nlService = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "service");
            if (nlService.size() != 0) {
                this.report(valObj, pReporter, "A Service Description should not have a service  element.");
            }
            if ((nlBinding = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "binding")).size() != 0) {
                this.report(valObj, pReporter, "A Service Description should not have a binding element.");
            }
            if (1 != (nlPortType = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "portType")).size() && 2 != nlPortType.size()) {
                this.report(valObj, pReporter, "A Service Description should have more than zero and no more than 2 portType element.");
            }
            if ((nlPartnerLinkType = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "partnerLinkType")).size() != 0 && 1 != nlPartnerLinkType.size()) {
                this.report(valObj, pReporter, "A Service Description must have either no partner link types present or 1 when defining callbacks.");
            }
            if (!(1 == nlPortType.size() && nlPartnerLinkType.size() == 0 || 2 == nlPortType.size() && 1 == nlPartnerLinkType.size())) {
                this.report(valObj, pReporter, "A Service Description must provide a partnerPortType when defining two porttypes.");
            }
            if (1 == nlPartnerLinkType.size()) {
                boolean isServicePartnerRolePresents = false;
                boolean isCallbackPartnerRolePresents = false;
                Element elPartnerLinkType = (Element)nlPartnerLinkType.get(0);
                List nlRole = this.getChildElementsByTagNameNS(elPartnerLinkType, "http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "role");
                int count = nlRole.size();
                int i = 0;
                while (i < count) {
                    Element elRole = (Element)nlRole.get(i);
                    if ("service".equals(elRole.getAttribute("name"))) {
                        isServicePartnerRolePresents = true;
                    }
                    if ("callback".equals(elRole.getAttribute("name"))) {
                        isCallbackPartnerRolePresents = true;
                    }
                    ++i;
                }
                if (!isServicePartnerRolePresents) {
                    this.report(valObj, pReporter, "The 'service' role is not specified in the Partner Link.");
                }
                if (!isCallbackPartnerRolePresents) {
                    this.report(valObj, pReporter, "The 'callback' role is not specified in the Partner Link.");
                }
            }
            NodeList nlMessage = nDefinitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "message");
            int count1 = nlMessage.getLength();
            int i = 0;
            while (i < count1) {
                Element elMessage = (Element)nlMessage.item(i);
                int numberMessagePart = this.getChildElementsByTagNameNS(elMessage, "http://schemas.xmlsoap.org/wsdl/", "part").size();
                if (1 < numberMessagePart) {
                    this.report(valObj, pReporter, "Message \"" + elMessage.getAttribute("name") + "\" has " + numberMessagePart + " message parts. SOPERA supports only messages with a single or no part.");
                }
                ++i;
            }
            NodeList nlPart = nDefinitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "part");
            int count2 = nlPart.getLength();
            int i2 = 0;
            while (i2 < count2) {
                Element elPart = (Element)nlPart.item(i2);
                if (!this.checkAttributePresents(elPart, new QName("element")) || this.checkAttributePresents(elPart, new QName("type"))) {
                    this.report(valObj, pReporter, "A Service Description only supports the element attribute in a part element and not the type attribute.");
                }
                ++i2;
            }
            NodeList nlSdxElements = nDefinitions.getElementsByTagNameNS("http://types.sopware.org/service/ServiceDescription/2.0", "*");
            int count3 = nlSdxElements.getLength();
            int i3 = 0;
            while (i3 < count3) {
                String name = nlSdxElements.item(i3).getLocalName();
                this.report(valObj, pReporter, "The \"" + name + "\" element is not an extension element from the service description namespace.");
                ++i3;
            }
            QName wsdlPortType = new QName("http://schemas.xmlsoap.org/wsdl/", "portType");
            QName wsdlOperation = new QName("http://schemas.xmlsoap.org/wsdl/", "operation");
            NodeList nlAnyElements = nDefinitions.getElementsByTagNameNS("*", "*");
            int count4 = nlAnyElements.getLength();
            int i4 = 0;
            while (i4 < count4) {
                Element nAnyElement = (Element)nlAnyElements.item(i4);
                QName qName = new QName(nAnyElement.getNamespaceURI(), nAnyElement.getLocalName());
                if (!wsdlPortType.equals(qName)) {
                    if (this.checkAttributePresents(nAnyElement, new QName("http://types.sopware.org/service/ServiceDescription/2.0", "domain"))) {
                        this.report(valObj, pReporter, "The attribute domain may only be defined within the element portType.");
                    }
                    if (this.checkAttributePresents(nAnyElement, new QName("http://types.sopware.org/service/ServiceDescription/2.0", "version"))) {
                        this.report(valObj, pReporter, "The attribute version may only be defined within the element portType.");
                    }
                    if (this.checkAttributePresents(nAnyElement, new QName("http://types.sopware.org/service/ServiceDescription/2.0", "status"))) {
                        this.report(valObj, pReporter, "The attribute status may only be defined within the element portType.");
                    }
                }
                if (!wsdlOperation.equals(qName)) {
                    if (this.checkAttributePresents(nAnyElement, new QName("http://types.sopware.org/service/ServiceDescription/2.0", "partnerOperation"))) {
                        this.report(valObj, pReporter, "The attribute partnerOperation may only be defined within the element operation.");
                    }
                    if (this.checkAttributePresents(nAnyElement, new QName("http://types.sopware.org/service/ServiceDescription/2.0", "faultOperation"))) {
                        this.report(valObj, pReporter, "The attribute faultOperation may only be defined within the element operation.");
                    }
                }
                ++i4;
            }
        }
    }

    private void checkSPDX(IValidationObject valObj, IReporter pReporter) throws SOPValidationException {
        Document spdxDocument = this.getInputDocument(valObj);
        NodeList nlDefinitions = spdxDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "definitions");
        if (1 != nlDefinitions.getLength()) {
            this.report(valObj, pReporter, "A Service Description should have a WSDL definitions element.");
        } else {
            Attr attrStyle;
            List nlBinding;
            List nlService;
            Element nDefinitions = (Element)nlDefinitions.item(0);
            List nlPortType = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "portType");
            if (nlPortType.size() != 0) {
                this.report(valObj, pReporter, "A Service Description must not have one portType element.");
            }
            if (1 != (nlService = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "service")).size()) {
                this.report(valObj, pReporter, "A Service Provider Description must have exactly one service element.");
            }
            if ((nlBinding = this.getChildElementsByTagNameNS(nDefinitions, "http://schemas.xmlsoap.org/wsdl/", "binding")).size() == 0) {
                this.report(valObj, pReporter, "A Service Provider Description must have at least one binding element.");
            }
            HashMap transportOperations = new HashMap();
            int count1 = nlBinding.size();
            int i = 0;
            while (i < count1) {
                Node nBinding = (Node)nlBinding.get(i);
                List nlSoapBinding = this.getChildElementsByTagNameNS(nBinding, "http://schemas.xmlsoap.org/wsdl/soap/", "binding");
                if (1 != nlSoapBinding.size()) {
                    this.report(valObj, pReporter, "A service description supports only SOAP based bindings.");
                } else {
                    List currentTransportOperations;
                    Element elSoapBinding = (Element)nlSoapBinding.get(0);
                    String transport = elSoapBinding.getAttribute("transport");
                    if (transportOperations.containsKey(transport)) {
                        currentTransportOperations = (List)transportOperations.get(transport);
                    } else {
                        currentTransportOperations = new ArrayList();
                        transportOperations.put(transport, currentTransportOperations);
                    }
                    List nlOperations = this.getChildElementsByTagNameNS(nBinding, "http://schemas.xmlsoap.org/wsdl/", "operation");
                    for (Element elOperation : nlOperations) {
                        String name = elOperation.getAttribute("name");
                        if (!currentTransportOperations.contains(name)) continue;
                        this.report(valObj, pReporter, "An operation \"" + name + "\" may only appear in different bindings if these bindings use different transports.");
                    }
                }
                ++i;
            }
            NodeList nlSoapBinding = nDefinitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
            int count2 = nlSoapBinding.getLength();
            int i2 = 0;
            while (i2 < count2) {
                String transport;
                Element nSoapBinding = (Element)nlSoapBinding.item(i2);
                Node nParent = nSoapBinding.getParentNode();
                if (!"http://schemas.xmlsoap.org/wsdl/".equals(nParent.getNamespaceURI()) || !"binding".equals(nParent.getLocalName())) {
                    this.report(valObj, pReporter, "The element <sch:name/> should only appear inside a WSDL binding element.");
                }
                if (!("http://schemas.xmlsoap.org/soap/http".equals(transport = nSoapBinding.getAttribute("transport")) || "http://schemas.xmlsoap.org/soap/jms".equals(transport) || "http://binding.sopware.org/soap/sbb2".equals(transport))) {
                    this.report(valObj, pReporter, "The SOAP binding is only supported over HTTP, JMS or via the sbb2 binding component.");
                }
                if ((attrStyle = nSoapBinding.getAttributeNode("style")) != null && !"document".equals(attrStyle.getNodeValue())) {
                    this.report(valObj, pReporter, "Only \"document\" communication style is allowed for SOAP binding.");
                }
                ++i2;
            }
            NodeList nlSoapOperation = nDefinitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
            int count3 = nlSoapOperation.getLength();
            int i3 = 0;
            while (i3 < count3) {
                Element nSoapOperation = (Element)nlSoapOperation.item(i3);
                attrStyle = nSoapOperation.getAttributeNode("style");
                if (attrStyle != null && !"document".equals(attrStyle.getNodeValue())) {
                    this.report(valObj, pReporter, "Only \"document\" communication style is allowed for SOAP operations.");
                }
                ++i3;
            }
            NodeList nlJmsAddress = nDefinitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/jms/", "address");
            int count4 = nlJmsAddress.getLength();
            int i4 = 0;
            while (i4 < count4) {
                Element nJmsAddress = (Element)nlJmsAddress.item(i4);
                boolean isDestinationStyle = this.checkAttributePresents(nJmsAddress, new QName("destinationStyle"));
                boolean isJmsImplementationSpecificURI = this.checkAttributePresents(nJmsAddress, new QName("jmsImplementationSpecificURI"));
                boolean isJmsProviderDestinationName = this.checkAttributePresents(nJmsAddress, new QName("jmsProviderDestinationName"));
                boolean isJndiDestinationName = this.checkAttributePresents(nJmsAddress, new QName("jndiDestinationName"));
                boolean isJndiConnectionFactoryName = this.checkAttributePresents(nJmsAddress, new QName("jndiConnectionFactoryName"));
                boolean isJndiProviderURL = this.checkAttributePresents(nJmsAddress, new QName("jndiProviderURL"));
                boolean isInitialContextFactory = this.checkAttributePresents(nJmsAddress, new QName("initialContextFactory"));
                if (isDestinationStyle && isJmsImplementationSpecificURI) {
                    this.report(valObj, pReporter, "destinationStyle and jmsImplementationSpecificURI must not be specified both as attributes in the jms:address element.");
                }
                if (!isDestinationStyle && !isJmsImplementationSpecificURI) {
                    this.report(valObj, pReporter, "Either destinationStyle or jmsImplementationSpecificURI must be specified as attributes in the jms:address element");
                }
                if (isJndiDestinationName && isJmsProviderDestinationName) {
                    this.report(valObj, pReporter, "jndiDestinationName and jmsProviderDestinationName must not be specified both as attributes in the jms:address element.");
                }
                if (isDestinationStyle && !isJndiDestinationName && !isJmsProviderDestinationName) {
                    this.report(valObj, pReporter, "if destinationStyle is specified, then either jndiDestinationName or jmsProviderDestinationName must be specified as attributes in the jms:address element");
                }
                if (isJndiDestinationName && !isJndiConnectionFactoryName) {
                    this.report(valObj, pReporter, "if jndiDestinationName is specified then jndiConnectionFactoryName must also be specified as attributes in the jms:address element");
                }
                if (isDestinationStyle && (!isJndiProviderURL || !isInitialContextFactory) && isJndiProviderURL && isInitialContextFactory) {
                    this.report(valObj, pReporter, "if destinationStyle is specified then either both jndiProviderURL and initialContextFactory or neither must be specified as attributes in the jms:address element");
                }
                ++i4;
            }
        }
    }

    private void checkPPDX(IValidationObject valObj, IReporter pReporter) throws SOPValidationException {
        Document ppdxDocument = this.getInputDocument(valObj);
        HashSet<String> uniqueName = new HashSet<String>();
        List nlOperation = this.getChildElementsByTagNameNS(ppdxDocument.getDocumentElement(), "http://types.sopware.org/qos/ParticipantPolicy/1.1", "Operation");
        Iterator it = nlOperation.iterator();
        while (it.hasNext()) {
            String attrName = ((Element)it.next()).getAttribute("name");
            if (uniqueName.add(attrName)) continue;
            this.report(valObj, pReporter, "The operation \"" + attrName + "\" declared in Participant Policy more than one time");
        }
    }

    private void checkOPDX(IValidationObject valObj, IReporter pReporter) throws SOPValidationException {
        Document opdxDocument = this.getInputDocument(valObj);
        ArrayList<String> report = new ArrayList<String>();
        NodeList nlSOPAExtension = opdxDocument.getDocumentElement().getElementsByTagNameNS("http://types.sopware.org/qos/SOPAssertions/1.1", "*");
        int count1 = nlSOPAExtension.getLength();
        int i = 0;
        while (i < count1) {
            Element nSOPAExtension = (Element)nlSOPAExtension.item(i);
            String name = nSOPAExtension.getLocalName();
            if ("HttpTransport".equals(name) || "HttpsTransport".equals(name) || "JmsTransport".equals(name) || "Sbb2Transport".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_CHOICE)) {
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                        report.add("Only one " + nSOPAExtension.getLocalName() + " assertion is allowed in a Compositor.");
                    }
                } else {
                    report.add("Transport Assertion is allowed only in Assertion Choice compositor.");
                }
                if (this.checkAttributePresents(nSOPAExtension, ATTR_ASSERTION_OPTIONAL)) {
                    report.add("The [" + nSOPAExtension.getLocalName() + "] Assertion cannot be optional");
                }
            } else if ("MaxResponseTime".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_CHOICE)) {
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                        report.add("Only one MaxResponseTime assertion is allowed in a Compositor.");
                    }
                } else {
                    report.add("MaxResponseTime Assertion is allowed only in Assertion Choice compositor.");
                }
            } else if ("Transformation".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_UNION)) {
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "request")) {
                        report.add("More than one Transformation Assertion for the same message type in the same compositor is not allowed.");
                    }
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "response")) {
                        report.add("More than one Transformation Assertion for the same message type in the same compositor is not allowed.");
                    }
                } else {
                    report.add("Transformation Assertion is allowed only in Assertion Union compositor.");
                }
            } else if ("TrackingLevel".equals(name)) {
                Attr attrVal = nSOPAExtension.getAttributeNode("value");
                Attr attrMin = nSOPAExtension.getAttributeNode("min");
                Attr attrMax = nSOPAExtension.getAttributeNode("max");
                if (attrVal != null && attrMin == null && attrMax == null) {
                    report.hashCode();
                } else if (attrVal == null && (attrMin != null || attrMax != null)) {
                    if (attrMin != null && attrMax != null && !this.checkTrackingLevelSeverityBoundaries(attrMin.getNodeValue(), attrMax.getNodeValue())) {
                        report.add("[TrackingLevel] The value of attribute 'max' [" + attrMax.getNodeValue() + "] should be greater than value of 'min' [" + attrMin.getNodeValue() + "]");
                    }
                } else {
                    report.add("[TrackingLevel] The attribute 'value' is mutually exclusive with 'min' and 'max' attributes");
                }
            } else if ("Extension".equals(name)) {
                if (!this.checkParentName(nSOPAExtension, ASSERTION_UNION)) {
                    report.add("Extension Assertion is allowed only in Assertion Union compositor.");
                }
            } else if ("Compression".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_UNION)) {
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, ATTR_ASSERTION_OPTIONAL, null)) {
                        report.add("Only one Compression assertion in the scope of a Compositor can have an Optional attribute specified.");
                    }
                } else {
                    report.add("Compression Assertion is allowed only in Assertion Union compositor.");
                }
                String attrMessage = nSOPAExtension.getAttribute("message");
                String attrOptional = nSOPAExtension.getAttributeNS("http://www.w3.org/2006/07/ws-policy", "Optional");
                if (!(!"none".equals(attrMessage) || "true".equals(attrOptional) && "none".equals(attrMessage))) {
                    report.add("wsp:Optional should be set to 'true' for [Compression] Assertion in case attribute message is 'none'.");
                }
            } else if ("Correlation".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_UNION)) {
                    HashSet<String> uniquePrefix = new HashSet<String>();
                    List nlNamespace = this.getChildElementsByTagNameNS(nSOPAExtension, "http://types.sopware.org/qos/SOPAssertions/1.1", "Namespace");
                    Iterator itNamespace = nlNamespace.iterator();
                    while (itNamespace.hasNext()) {
                        String attrPrefix = ((Element)itNamespace.next()).getAttribute("prefix");
                        if (uniquePrefix.add(attrPrefix)) continue;
                        report.add("The attribute 'prefix' of the Namespace sub-element of Correlation Assertion should be unique (value: " + attrPrefix + ").");
                    }
                    HashSet<String> uniqueName = new HashSet<String>();
                    List nlPart = this.getChildElementsByTagNameNS(nSOPAExtension, "http://types.sopware.org/qos/SOPAssertions/1.1", "Part");
                    Iterator itPart = nlPart.iterator();
                    while (itPart.hasNext()) {
                        String attrName = ((Element)itPart.next()).getAttribute("name");
                        if (uniqueName.add(attrName)) continue;
                        report.add("The attribute 'name' of the Part sub-element of Correlation Assertion should be unique (value: " + attrName + ").");
                    }
                } else {
                    report.add("Correlation Assertion is allowed only in Assertion Union compositor.");
                }
            } else if ("Namespace".equals(name)) {
                report.hashCode();
            } else if ("Part".equals(name)) {
                report.hashCode();
            } else if ("Header".equals(name)) {
                report.hashCode();
            } else if ("CustomValidation".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_UNION)) {
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "request")) {
                        report.add("More than one Custom Validation Assertion for the same message type in the same compositor is not allowed.");
                    }
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "response")) {
                        report.add("More than one Custom Validation Assertion for the same message type in the same compositor is not allowed.");
                    }
                } else {
                    report.add("CustomValidation Assertion is allowed only in Assertion Union compositor.");
                }
                if (this.checkAttributePresents(nSOPAExtension, new QName("location"))) {
                    report.add("'location' attribute for CustomValidation Assertion is allowed only in agreed policy and is forbidden in Operation Policy.");
                }
            } else if ("Priority".equals(name)) {
                Attr attrMax = nSOPAExtension.getAttributeNode("max");
                Attr attrMin = nSOPAExtension.getAttributeNode("min");
                if (attrMin == null || attrMax == null) {
                    report.add("[Priority] 'min' and 'max' are mandatory attributes");
                } else {
                    try {
                        int min = Integer.parseInt(attrMin.getNodeValue());
                        int max = Integer.parseInt(attrMax.getNodeValue());
                        if (max < min) {
                            report.add("[Priority] The value of 'min' attribute cannot be greater than 'max' attribute");
                        }
                    }
                    catch (NumberFormatException e) {
                        report.add("[Priority] The value of 'min' attribute cannot be greater than 'max' attribute");
                    }
                }
                if (this.checkAttributePresents(nSOPAExtension, new QName("value"))) {
                    report.add("'value' attribute for Priority Assertion is allowed only in agreed policy and is forbidden in Operation Policy.");
                }
            } else if ("Subscription".equals(name)) {
                if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                    report.add("More than one Subscription Assertion in the same compositor is not allowed.");
                }
            } else if ("Encryption".equals(name)) {
                if (2 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                    report.add("More than two Encryption Assertion in the same compositor is not allowed.");
                }
            } else if ("Signature".equals(name)) {
                if (this.checkAttributePresents(nSOPAExtension, new QName("verify"))) {
                    report.add("'verify' attribute for Signature Assertion is forbidden in Operation Policy.");
                }
                if (2 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                    report.add("More than two Signature Assertion in the same compositor is not allowed.");
                }
            } else if ("ConversationalBinding".equals(name)) {
                if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, null, null)) {
                    report.add("More than one ConversationalBinding Assertion in the same compositor is not allowed.");
                }
            } else if ("Authentication".equals(name)) {
                if (this.checkParentName(nSOPAExtension, ASSERTION_CHOICE)) {
                    int numberAll;
                    int numberOptional;
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("type"), "UsernameToken")) {
                        report.add("More than one Authentication Assertion of the same type in the same compositor is not allowed.");
                    }
                    if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("type"), "SAMLToken")) {
                        report.add("More than one Authentication Assertion of the same type in the same compositor is not allowed.");
                    }
                    if ((numberOptional = this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, ATTR_ASSERTION_OPTIONAL, "true")) > 0 && numberOptional != (numberAll = this.getChildElementsByTagNameNS(nSOPAExtension.getParentNode(), nSOPAExtension.getNamespaceURI(), nSOPAExtension.getLocalName()).size())) {
                        report.add("wsp:Optional must be the same for different types.");
                    }
                } else {
                    report.add("Authentication Assertion is allowed only in Assertion Choice compositor.");
                }
                if (this.checkAttributePresents(nSOPAExtension, new QName("message"))) {
                    report.add("'message' attribute for Authentication Assertion is allowed only in agreed policy and is forbidden in Operation Policy.");
                }
            } else if ("Authorization".equals(name)) {
                if (!this.checkParentName(nSOPAExtension, ASSERTION_CHOICE)) {
                    report.add("Authorization Assertion is allowed only in Assertion Choice compositor.");
                }
                if (this.checkAttributePresents(nSOPAExtension, new QName("location"))) {
                    report.add("'location' attribute for Authorization Assertion is allowed only in agreed policy and is forbidden in Operation Policy.");
                }
            } else if ("SDXValidation".equals(name)) {
                if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "request")) {
                    report.add("More than one SDXValidation Assertion for the same message type in the same compositor is not allowed.");
                }
                if (1 < this.getNumberTheSameElementsOnTheSameLevel(nSOPAExtension, new QName("message"), "response")) {
                    report.add("More than one SDXValidation Assertion for the same message type in the same compositor is not allowed.");
                }
            } else {
                report.add("The [" + name + "] element is not an extension element from the Operation Policy Description namespace.");
            }
            ++i;
        }
        this.report(valObj, pReporter, report);
    }

    private boolean checkTrackingLevelSeverityBoundaries(String minTrackLevel, String maxTrackLevel) {
        HashMap<String, Integer> severity = new HashMap<String, Integer>(5);
        severity.put("detail", 5);
        severity.put("trace", 4);
        severity.put("operation", 3);
        severity.put("summary", 2);
        severity.put("none", 1);
        if (severity.containsKey(minTrackLevel) && severity.containsKey(maxTrackLevel)) {
            return (Integer)severity.get(minTrackLevel) <= (Integer)severity.get(maxTrackLevel);
        }
        return false;
    }

    private Document getInputDocument(IValidationObject valObj) throws SOPValidationException {
        try {
            return valObj.getInput();
        }
        catch (ContextInitializationException e) {
            throw new SOPValidationException("Unable to load the document model", e);
        }
    }

    private List getChildElementsByTagNameNS(Node parentElement, String childNamespace, String childName) {
        ArrayList<Element> resultChildren = new ArrayList<Element>();
        NodeList childNodes = parentElement.getChildNodes();
        int count = childNodes.getLength();
        int i = 0;
        while (i < count) {
            Node childNode = childNodes.item(i);
            if (1 == childNode.getNodeType() && childNode.getLocalName().equals(childName)) {
                String namespace = childNode.getNamespaceURI();
                if (childNamespace == null && namespace == null || childNamespace != null && childNamespace.equals(namespace)) {
                    resultChildren.add((Element)childNode);
                }
            }
            ++i;
        }
        return resultChildren;
    }

    private int getNumberTheSameElementsOnTheSameLevel(Node element, QName filterAttributeName, String filterAttributeValue) {
        List resultChildren = this.getChildElementsByTagNameNS(element.getParentNode(), element.getNamespaceURI(), element.getLocalName());
        if (filterAttributeName == null) {
            return resultChildren.size();
        }
        int number = 0;
        for (Element child : resultChildren) {
            Attr filterAttribute = this.getAttribute(child, filterAttributeName);
            if (filterAttribute == null || filterAttributeValue != null && !filterAttribute.getNodeValue().equals(filterAttributeValue)) continue;
            ++number;
        }
        return number;
    }

    private boolean checkAttributePresents(Element element, QName attrName) {
        return this.getAttribute(element, attrName) != null;
    }

    private Attr getAttribute(Element element, QName attrName) {
        if (attrName.getNamespaceURI() == null || attrName.getNamespaceURI().length() == 0) {
            return element.getAttributeNode(attrName.getLocalPart());
        }
        return element.getAttributeNodeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
    }

    private boolean checkParentName(Node child, QName parentName) {
        if (parentName == null) {
            throw new IllegalArgumentException("nullable parent name for check");
        }
        Node parent = child.getParentNode();
        return parentName.equals(new QName(parent.getNamespaceURI(), parent.getLocalName()));
    }

    private void report(IValidationObject valObj, IReporter pReporter, String errorMessage) {
        if (pReporter != null && errorMessage != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, 1, MessageTypeEnum.SOP_PARTICULARITY_CONSTRAINT, new String[]{errorMessage});
            msg.setAttribute("source", valObj.getID().getQName());
            LOG.error((Object)msg.getMessageText());
            pReporter.addMessage(msg);
        }
    }

    private void report(IValidationObject valObj, IReporter pReporter, List strErrorMessages) {
        int count = strErrorMessages.size();
        int i = 0;
        while (i < count) {
            this.report(valObj, pReporter, (String)strErrorMessages.get(i));
            ++i;
        }
    }
}

