/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime.property.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.runtime.comboproviders.ComboEntries;
import org.eclipse.stp.im.runtime.comboproviders.IComboProvider;
import org.eclipse.stp.im.runtime.property.listeners.IPropertyListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractParamsMapHandlerListener
implements IPropertyListener {
    private String matchRegexp = "\\$\\w+";
    public static String PLACE_HOLDER_SIGN = "$".intern();

    @Override
    public void handleUpdate(String sourcePropertyValue, String dependentPropertyName, IProperty destinationServiceBindingProperty, EAnnotation ea) {
        String runtimeId = (String)ea.getDetails().get((Object)"im.pool.runtimeID");
        IRuntime imRuntime = ImRuntimeActivator.getRuntime(runtimeId);
        List<String> parametersList = this.getStringParameterNames(sourcePropertyValue);
        if (parametersList.size() >= 0) {
            String basePropertyName = null;
            for (String aParamName : parametersList) {
                basePropertyName = String.valueOf(dependentPropertyName) + "[" + aParamName + "]";
                String propertyToFoundInEAnnotation = String.valueOf(basePropertyName) + "." + destinationServiceBindingProperty.getMapFieldList().get(0);
                if (ea.getDetails().get((Object)propertyToFoundInEAnnotation) != null) continue;
                String destPropertyNameInAnnotation = null;
                Map<String, String> fieldEditorsMap = destinationServiceBindingProperty.getMapFieldsEditorsMap();
                String fieldEditor = null;
                for (String propOfMap : destinationServiceBindingProperty.getMapFieldList()) {
                    fieldEditor = fieldEditorsMap.get(propOfMap);
                    String defaultValue = null;
                    if (fieldEditor != null && fieldEditor.startsWith("combo")) {
                        String comboName = fieldEditor.substring(fieldEditor.indexOf("(") + 1, fieldEditor.indexOf(")"));
                        IComboProvider comboProvider = imRuntime.getNamedComboProvider(comboName);
                        ComboEntries ce = comboProvider.getComboEntries();
                        defaultValue = ce.getValues()[0];
                    }
                    destPropertyNameInAnnotation = String.valueOf(basePropertyName) + "." + propOfMap;
                    if (propOfMap.equalsIgnoreCase(destinationServiceBindingProperty.getMapKey())) {
                        ea.getDetails().put((Object)destPropertyNameInAnnotation, (Object)aParamName);
                        continue;
                    }
                    ea.getDetails().put((Object)destPropertyNameInAnnotation, (Object)(defaultValue != null ? defaultValue : ""));
                }
            }
            String parName = null;
            ArrayList<String> keyToRemove = new ArrayList<String>();
            for (String s : ea.getDetails().keySet()) {
                if (!s.startsWith(dependentPropertyName) || parametersList.contains(parName = s.substring(s.indexOf("[") + 1, s.indexOf("]")))) continue;
                keyToRemove.add(s);
            }
            for (String s : keyToRemove) {
                ea.getDetails().removeKey((Object)s);
            }
        }
    }

    public List<String> getStringParameterNames(String propertyValue) {
        Pattern pattern = Pattern.compile(this.matchRegexp);
        Matcher matcher = pattern.matcher(propertyValue);
        ArrayList<String> toReturn = new ArrayList<String>();
        int idx = 1;
        while (matcher.find()) {
            String placeHolder = matcher.group();
            placeHolder = placeHolder.substring(placeHolder.indexOf(PLACE_HOLDER_SIGN) + 1);
            toReturn.add(placeHolder);
            ++idx;
        }
        return toReturn;
    }
}

