/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils.ui;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.policy.wtp.common.utils.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EclipseUI {
    public static final String SDX_FILE_EXT = "sdx";
    public static final String SPDX_FILE_EXT = "spdx";
    public static final String PPDX_FILE_EXT = "ppdx";
    public static final String OPDX_FILE_EXT = "opdx";
    public static final String WSDL_FILE_EXT = "wsdl";
    public static final String SDX_FILE_DESC = Messages.getString("EclipseUI.SDX_FILE_DESC");
    public static final String SPDX_FILE_DESC = Messages.getString("EclipseUI.SPDX_FILE_DESC");
    public static final String WSDL_FILE_DESC = Messages.getString("EclipseUI.WSDL_FILE_DESC");
    public static final int BTN_STYLE = 8;
    public static final int EDIT_STYLE = 2052;
    private static final Logger log = Logger.getLogger(EclipseUI.class);
    private static final HashMap mappingFileExt = new HashMap();
    private static final String confirmMessage = Messages.getString("EclipseUI.CONFIRM_OVERWRITE");
    private static GridLayout glButtonComposite;
    private static GridData gdButtonComposite;
    private static GridData gdButton;

    static {
        mappingFileExt.put(SDX_FILE_EXT, SDX_FILE_DESC);
        mappingFileExt.put(SPDX_FILE_EXT, SPDX_FILE_DESC);
        mappingFileExt.put(WSDL_FILE_EXT, WSDL_FILE_DESC);
        glButtonComposite = new GridLayout(2, true);
        gdButtonComposite = new GridData(131072, 0, false, false);
        gdButton = new GridData(4, 0, true, false);
        EclipseUI.glButtonComposite.marginHeight = 0;
        EclipseUI.glButtonComposite.marginWidth = 0;
    }

    private EclipseUI() {
    }

    public static GridData getButtonGridData() {
        return gdButton;
    }

    public static boolean hasActiveEditor(String filePath) {
        boolean hasEditor = false;
        try {
            IWorkbenchWindow workbenchWindow = null;
            workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null) {
                IWorkbenchPage[] pages = workbenchWindow.getPages();
                int iPage = 0;
                while (iPage != pages.length && !hasEditor) {
                    IWorkbenchPage thisPage = pages[iPage];
                    IEditorReference[] editors = thisPage.getEditorReferences();
                    int iEditor = 0;
                    while (iEditor != editors.length && !hasEditor) {
                        IPath path;
                        IEditorInput input = editors[iEditor].getEditorInput();
                        File newFile = new File(filePath);
                        if (input instanceof FileEditorInput) {
                            String osString = ((FileEditorInput)input).getFile().getLocation().toOSString();
                            if (newFile.compareTo(new File(osString)) == 0) {
                                hasEditor = true;
                                break;
                            }
                        } else if (input instanceof IPathEditorInput && newFile.compareTo(new File((path = ((IPathEditorInput)input).getPath()).toOSString())) == 0) {
                            hasEditor = true;
                            break;
                        }
                        ++iEditor;
                    }
                    ++iPage;
                }
            }
        }
        catch (Exception err) {
            log.error((Object)("Unhandled exception catched during checking for active editor " + err.toString()), (Throwable)err);
            hasEditor = false;
        }
        return hasEditor;
    }

    public static boolean isResourceInWorkspace(String containerName, String targetFileName) {
        boolean bExists = false;
        IFile file = EclipseUI.getIFile(containerName, targetFileName);
        if (file != null) {
            bExists = file.exists();
        }
        return bExists;
    }

    public static String getDefaultFileSelection(String fileExt) {
        String defSelection = "";
        IWorkbenchPage activeWbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activeWbPage != null) {
            IEditorInput editorInput;
            IEditorPart editorPart;
            ISelection rcSelection;
            ISelection selection;
            ISelectionProvider selectionProvider;
            IWorkbenchPart activeWbPart = activeWbPage.getActivePart();
            Object selObj = null;
            if (activeWbPart != null && (selectionProvider = activeWbPart.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                selObj = ((IStructuredSelection)selection).getFirstElement();
            }
            if (selObj == null && (rcSelection = EclipseUI.getActualSelection()) instanceof IStructuredSelection) {
                selObj = ((IStructuredSelection)rcSelection).getFirstElement();
            }
            IFile inputFile = null;
            if (selObj != null && selObj instanceof IFile) {
                inputFile = (IFile)selObj;
            }
            if (inputFile == null && (editorPart = activeWbPage.getActiveEditor()) != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                inputFile = ((IFileEditorInput)editorInput).getFile();
            }
            if (inputFile != null && inputFile.getFileExtension().equalsIgnoreCase(fileExt)) {
                defSelection = inputFile.getLocation().toString();
            }
        }
        return defSelection;
    }

    public static ISelection getActualSelection() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = activePage.getActivePart();
        IViewPart partResourceNavigator = activePage.findView("org.eclipse.ui.views.ResourceNavigator");
        IViewPart partPackageExplorer = activePage.findView("org.eclipse.jdt.ui.PackageExplorer");
        IViewPart partProjectExplorer = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (!(part == null || part.equals(partResourceNavigator) || part.equals(partPackageExplorer) || part.equals(partProjectExplorer))) {
            part = null;
        }
        if (part == null) {
            part = partResourceNavigator;
        }
        if (part == null) {
            part = partPackageExplorer;
        }
        if (part == null) {
            part = partProjectExplorer;
        }
        ISelection selection = null;
        if (part != null) {
            selection = part.getSite().getSelectionProvider().getSelection();
        }
        return selection;
    }

    public static IContainer getSelectedContainer() {
        IContainer container = null;
        ISelection selection = EclipseUI.getActualSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object select = ((IStructuredSelection)selection).getFirstElement();
            if (select instanceof IContainer) {
                container = (IContainer)select;
            } else if (select instanceof IResource) {
                container = ((IResource)select).getParent();
            } else if (select instanceof IProjectNature) {
                container = ((IProjectNature)select).getProject();
            } else if (select instanceof IJavaElement) {
                try {
                    IResource resource = ((IJavaElement)select).getCorrespondingResource();
                    if (resource instanceof IContainer) {
                        container = (IContainer)resource;
                    }
                }
                catch (JavaModelException e) {
                    log.error((Object)e);
                }
            }
        }
        return container;
    }

    private static String getDefaultContainer() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length > 0) {
            return projects[0].getFullPath().toOSString();
        }
        return "";
    }

    public static String openContainerSelectionDialog() {
        String strDesc = Messages.getString("EclipseUI.TITLE_SELECT_PROJECT");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(EclipseUI.getActiveShell(), (IContainer)root, false, strDesc);
        String strResult = null;
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            strResult = result[0].toString();
        }
        return strResult;
    }

    public static String openProjectSelectionDialog() {
        IResource sel;
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
                Object[] projects = root.getProjects();
                return projects;
            }

            public Object getParent(Object element) {
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                String imageType = "IMG_OBJ_PROJECT";
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getText(Object element) {
                return ((IResource)element).getName();
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(EclipseUI.getActiveShell(), (ILabelProvider)labelProvider, contentProvider);
        dialog.setTitle("Select Project");
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && (sel = (IResource)dialog.getFirstResult()).getType() == 4) {
            return sel.getName();
        }
        return null;
    }

    private static FileDialog getFileSelectionDialog(Shell shell, boolean isOpen) {
        FileDialog fileDialog = new FileDialog(shell, 0x8000 | (isOpen ? 4096 : 8192));
        String strDefaultProject = EclipseUI.getDefaultContainer();
        int index = strDefaultProject.indexOf("/");
        if (index == -1) {
            index = strDefaultProject.indexOf("\\");
        }
        if (index != -1) {
            strDefaultProject = strDefaultProject.substring(index + 1);
        }
        fileDialog.setFilterPath(strDefaultProject);
        return fileDialog;
    }

    private static String selectResourceFromWorkspace(Shell shell, final String extension) {
        IResource sel;
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                String imageType = "IMG_OBJ_FOLDER";
                if (((IResource)element).getType() == 1) {
                    imageType = "IMG_OBJ_ELEMENTS";
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageType);
            }

            public String getText(Object element) {
                return ((IResource)element).getName();
            }
        };
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] result = null;
                String cmpExt = "." + extension;
                if (parentElement instanceof IContainer) {
                    try {
                        ArrayList<IResource> arrFolder = new ArrayList<IResource>();
                        ArrayList<IResource> arrFile = new ArrayList<IResource>();
                        IResource[] res = ((IContainer)parentElement).members();
                        int i = 0;
                        while (i < res.length) {
                            if (res[i].getType() == 1) {
                                if (res[i].getName().endsWith(cmpExt)) {
                                    arrFile.add(res[i]);
                                }
                            } else {
                                arrFolder.add(res[i]);
                            }
                            ++i;
                        }
                        ArrayList<IResource> arr = new ArrayList<IResource>();
                        arr.addAll(arrFolder);
                        arr.addAll(arrFile);
                        result = arr.toArray();
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                return result;
            }

            public Object getParent(Object element) {
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((IResource)element).getType() != 1;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, contentProvider);
        dialog.setTitle(Messages.getString("EclipseUI.TITLE_SELECT_INPUT_FILE"));
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && (sel = (IResource)dialog.getFirstResult()).getType() == 1) {
            return sel.getLocation().toOSString();
        }
        return null;
    }

    public static String getFileDescription(String fileExt) {
        String fileDescription = (String)mappingFileExt.get(fileExt);
        return fileDescription;
    }

    public static String openFileSelectionDialog(Shell shell, String fileExt, boolean isOpen) {
        String extName = (String)mappingFileExt.get(fileExt);
        extName = extName == null ? MessageFormat.format(Messages.getString("EclipseUI.FILTER_EXTENSION"), fileExt) : String.valueOf(extName) + " (*." + fileExt + ")";
        FileDialog fileDialog = EclipseUI.getFileSelectionDialog(shell, isOpen);
        fileDialog.setFilterExtensions(new String[]{"*." + fileExt});
        fileDialog.setFilterNames(new String[]{extName});
        fileDialog.setText(Messages.getString("EclipseUI.MESSAGE_SELECT_FILE"));
        return fileDialog.open();
    }

    private static boolean openDirectoryExportDialog(Text text) {
        DirectoryDialog dialog = new DirectoryDialog(text.getShell());
        dialog.setText(Messages.getString("EclipseUI.TITLE_EXPORT_TO_DIR"));
        dialog.setMessage(Messages.getString("EclipseUI.MESSAGE_EXPORT_TO_DIR"));
        String strDir = text.getText().trim();
        if (strDir.length() == 0) {
            strDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFilterPath(strDir);
        strDir = dialog.open();
        if (strDir != null) {
            text.setText(strDir);
            return true;
        }
        return false;
    }

    public static boolean openOverwriteDialog(String fileName) {
        return MessageDialog.openConfirm((Shell)EclipseUI.getActiveShell(), (String)Messages.getString("EclipseUI.TITLE_OVERWRITE_FILE"), (String)MessageFormat.format(confirmMessage, fileName));
    }

    public static final Shell getActiveShell() {
        Shell shell = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public static Text createFilePath(Composite optionsGroup, String groupLabel, String fileExt) {
        return EclipseUI.createFilePath(optionsGroup, groupLabel, fileExt, true);
    }

    public static Text createFilePath(final Composite optionsGroup, String groupLabel, final String fileExt, boolean isFSButton) {
        GridLayout gl;
        Group sdxGroup = new Group(optionsGroup, 0);
        sdxGroup.setBackgroundMode(2);
        sdxGroup.setText(groupLabel);
        sdxGroup.setLayout((Layout)new GridLayout());
        Layout gridLayout = optionsGroup.getLayout();
        if (gridLayout instanceof GridLayout) {
            int nColumns = ((GridLayout)gridLayout).numColumns;
            GridData groupGridData = new GridData(4, 0, true, false, nColumns, 1);
            sdxGroup.setLayoutData((Object)groupGridData);
        }
        final Text pathText = new Text((Composite)sdxGroup, 2052);
        pathText.setText(EclipseUI.getDefaultFileSelection(fileExt));
        pathText.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite buttonComposite = new Composite((Composite)sdxGroup, 0);
        if (isFSButton) {
            gl = glButtonComposite;
        } else {
            gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
        }
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)gdButtonComposite);
        Button browseFSButton = null;
        Button browseEPButton = null;
        SelectionAdapter adaptor = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = ((Button)e.getSource()).getData("FS") != null ? EclipseUI.openFileSelectionDialog(optionsGroup.getShell(), fileExt, true) : EclipseUI.selectResourceFromWorkspace(optionsGroup.getShell(), fileExt);
                if (fileName != null) {
                    pathText.setText(fileName);
                    pathText.setToolTipText(fileName);
                }
            }
        };
        browseEPButton = new Button(buttonComposite, 8);
        browseEPButton.setText(Messages.getString("EclipseUI.BUTTON_BROWSE_WORKSPACE"));
        EclipseUI.adaptGridData((Control)browseEPButton);
        browseEPButton.setLayoutData((Object)gdButton);
        browseEPButton.addSelectionListener((SelectionListener)adaptor);
        if (isFSButton) {
            browseFSButton = new Button(buttonComposite, 8);
            EclipseUI.adaptGridData((Control)browseFSButton);
            browseFSButton.setLayoutData((Object)gdButton);
            browseFSButton.setText(Messages.getString("EclipseUI.BUTTON_BROWSE_FILE_SYSTEM"));
            browseFSButton.setData("FS", (Object)Boolean.TRUE);
            browseFSButton.addSelectionListener((SelectionListener)adaptor);
        }
        return pathText;
    }

    public static Text createFilePathSdx(Composite optionsGroup, String groupLabel) {
        return EclipseUI.createFilePath(optionsGroup, groupLabel, SDX_FILE_EXT);
    }

    public static Text createFilePathSpdx(Composite optionsGroup, String groupLabel) {
        return EclipseUI.createFilePath(optionsGroup, groupLabel, SPDX_FILE_EXT);
    }

    public static Text createDirectoryPath(Composite compositeParent, final boolean bProject) {
        Group dirGroup = new Group(compositeParent, 0);
        dirGroup.setLayout((Layout)new GridLayout());
        Layout gridLayout = compositeParent.getLayout();
        if (gridLayout instanceof GridLayout) {
            int nColumns = ((GridLayout)gridLayout).numColumns;
            GridData groupGridData = new GridData(4, 0, true, false, nColumns, 1);
            dirGroup.setLayoutData((Object)groupGridData);
        }
        final Text pathText = new Text((Composite)dirGroup, 2052);
        if (bProject) {
            IContainer container = EclipseUI.getSelectedContainer();
            if (container != null) {
                pathText.setText(container.getFullPath().toOSString());
            } else {
                pathText.setText(EclipseUI.getDefaultContainer());
            }
            dirGroup.setText(Messages.getString("EclipseUI.MESSAGE_PROJECT_FOLDER"));
            pathText.setToolTipText(Messages.getString("EclipseUI.TOOLTIP_PROJECT"));
        } else {
            dirGroup.setText(Messages.getString("EclipseUI.MESSAGE_TARGET_DIR"));
            pathText.setToolTipText(Messages.getString("EclipseUI_TOOLTIP_DIR"));
        }
        pathText.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite buttonComposite = new Composite((Composite)dirGroup, 0);
        buttonComposite.setLayoutData((Object)gdButtonComposite);
        buttonComposite.setLayout((Layout)glButtonComposite);
        new Label(buttonComposite, 0);
        Button browseButton = new Button(buttonComposite, 8);
        browseButton.setText(Messages.getString("EclipseUI.BUTTON_BROWSE"));
        EclipseUI.adaptGridData((Control)browseButton);
        browseButton.setLayoutData((Object)gdButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (bProject) {
                    String dirPath = EclipseUI.openContainerSelectionDialog();
                    if (dirPath != null) {
                        pathText.setText(dirPath);
                    }
                } else {
                    EclipseUI.openDirectoryExportDialog(pathText);
                }
            }
        });
        return pathText;
    }

    private static IContainer getContainer(String containerName) {
        IContainer container = null;
        if (containerName == null || containerName.length() == 0) {
            throw new IllegalArgumentException("Container Name must be specified");
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            container = (IContainer)resource;
        }
        return container;
    }

    public static IFile getIFile(String containerName, String fileName) {
        IFile file = null;
        IContainer container = EclipseUI.getContainer(containerName);
        if (container != null) {
            file = container.getFile((IPath)new Path(fileName));
        }
        return file;
    }

    public static IProject getProject(String projectName) {
        IProject project = null;
        IContainer container = EclipseUI.getContainer(projectName);
        if (container != null && container instanceof IProject) {
            project = (IProject)container;
        }
        return project;
    }

    private static final Point getTooltipLocation(Control control) {
        return control.getParent().toDisplay(control.getLocation());
    }

    public static final Point getCaretLocation(Combo ccombo) {
        GC gc = new GC((Drawable)ccombo);
        Point pt = ccombo.getSelection();
        String text = ccombo.getText().substring(0, pt.x);
        Point ptExtent = gc.textExtent(text);
        pt = EclipseUI.getTooltipLocation((Control)ccombo);
        pt.x += ptExtent.x;
        pt.y += ccombo.getTextHeight();
        return pt;
    }

    public static final Point getCaretLocation(Text text) {
        Point ptCaret = text.getCaretLocation();
        Point pt = EclipseUI.getTooltipLocation((Control)text);
        pt.x += ptCaret.x;
        pt.y += text.getLineHeight();
        return pt;
    }

    public static void openEditor(final IFile file) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private static IStatus[] getStatus(Throwable e, String pluginId) {
        ArrayList<Status> alStatus = new ArrayList<Status>();
        alStatus.add(new Status(4, pluginId, 0, e.getClass().getName(), e));
        int i = 0;
        while (i < e.getStackTrace().length) {
            alStatus.add(new Status(4, pluginId, 0, e.getStackTrace()[i].toString(), null));
            ++i;
        }
        IStatus[] arrStatus = new IStatus[alStatus.size()];
        int i2 = 0;
        while (i2 < alStatus.size()) {
            arrStatus[i2] = (IStatus)alStatus.get(i2);
            ++i2;
        }
        return arrStatus;
    }

    public static final void openErrorDialog(String message, Throwable e, String pluginId) {
        String msg = message != null ? message : (e.getMessage() != null ? e.getMessage() : e.getClass().getName());
        MultiStatus status = new MultiStatus(pluginId, 0, EclipseUI.getStatus(e, pluginId), msg, null);
        ErrorDialog.openError((Shell)EclipseUI.getActiveShell(), (String)Messages.getString("EclipseUI.TITLE_ERROR"), null, (IStatus)status);
    }

    private static void adaptGridData(Control control) {
        int widthHint = control.computeSize((int)-1, (int)-1).x;
        if (-1 == EclipseUI.gdButton.widthHint || EclipseUI.gdButton.widthHint < widthHint) {
            EclipseUI.gdButton.widthHint = widthHint;
        }
    }

    public static void setControlAndChildEnabled(Composite control, boolean enabled) {
        control.setEnabled(enabled);
        Control[] controls = control.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                EclipseUI.setControlAndChildEnabled((Composite)controls[i], enabled);
            } else {
                controls[i].setEnabled(enabled);
            }
            ++i;
        }
    }
}

