/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.generator;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.DOMProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpdxGenerator {
    private static final Logger log = Logger.getLogger(OpdxGenerator.class);

    public static final InputStream generateOPDXStream(String pPolicyName, String pPolicyId, boolean isNotification) throws BaseException {
        InputStream stream = OpdxGenerator.class.getResourceAsStream("/org/eclipse/stp/policy/wtp/generator/templates/OperationPolicyTemplate.xml");
        DOMProvider opdxProvider = new DOMProvider(stream);
        Element rootElement = opdxProvider.getDocument().getDocumentElement();
        if (pPolicyName.length() > 0) {
            rootElement.setAttribute("sopwsp:shortname", pPolicyName);
        }
        rootElement.setAttribute("Name", pPolicyId);
        if (isNotification) {
            try {
                NodeList nodes = opdxProvider.getMultiXPathResult("//sopa:HttpTransport | //sopa:HttpsTransport");
                int index = 0;
                while (index < nodes.getLength()) {
                    Node node = nodes.item(index);
                    node.getParentNode().removeChild(node);
                    ++index;
                }
            }
            catch (TransformerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new ByteArrayInputStream(opdxProvider.getDocumentAsString().getBytes());
    }

    public static final void generateOPDX(String pOPDXPath, String pPolicyName, String pPolicyId, boolean isNotification) throws BaseException {
        InputStream inputStream = OpdxGenerator.generateOPDXStream(pPolicyName, pPolicyId, isNotification);
        try {
            DOMProvider domProvider = new DOMProvider(inputStream);
            domProvider.serialize((OutputStream)new FileOutputStream(pOPDXPath));
        }
        catch (BaseException e) {
            throw new BaseException("Unable to open the DOM document on generated OPDX Stream: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BaseException("Unable to serialize the generated OPDX Stream: " + e.getMessage(), (Throwable)e);
        }
    }
}

