/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.validator.core.IMessage;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.policy.wtp.validation.Logger;

public class IDEProblemsReporter
implements IReporter {
    private List messages = new ArrayList();
    private int errorCount = 0;
    private int warnCount = 0;
    private IFile involvedFile = null;
    private static final String OWNER_ATTR_NAME = "owner";
    private static final String OWNER_ATTR_VALUE = "org.eclipse.stp.policy.wtp.validation";

    public IDEProblemsReporter(IFile iFile) {
        this.involvedFile = iFile;
        IDEProblemsReporter.clearMarkers(iFile);
    }

    public void addMessage(IMessage msg) {
        if (1 == msg.getSeverity()) {
            ++this.errorCount;
        } else if (2 == msg.getSeverity()) {
            ++this.warnCount;
        }
        this.messages.add(msg);
        try {
            IMarker marker = this.involvedFile.createMarker("org.eclipse.core.resources.problemmarker");
            String[] attNames = new String[]{OWNER_ATTR_NAME, "lineNumber", "message", "severity"};
            Object[] objectArray = new Object[4];
            objectArray[0] = OWNER_ATTR_VALUE;
            objectArray[1] = msg.getLineNumber();
            objectArray[2] = "SOPERA Validation: " + msg.getMessageText();
            Object[] attValues = objectArray;
            int index = attValues.length - 1;
            attValues[index] = 1 == msg.getSeverity() ? Integer.valueOf(2) : (2 == msg.getSeverity() ? Integer.valueOf(1) : (4 == msg.getSeverity() ? Integer.valueOf(0) : Integer.valueOf(2)));
            marker.setAttributes(attNames, attValues);
        }
        catch (CoreException e) {
            Logger.error(e);
        }
    }

    private static void clearMarkers(IFile file) {
        try {
            IMarker[] markers = file.findMarkers(null, true, 0);
            IMarker[] deleteMarkers = new IMarker[markers.length];
            int deleteindex = 0;
            int i = markers.length - 1;
            while (i >= 0) {
                Object owner = markers[i].getAttribute(OWNER_ATTR_NAME);
                if (owner != null && owner instanceof String && owner.equals(OWNER_ATTR_VALUE)) {
                    deleteMarkers[deleteindex++] = markers[i];
                }
                --i;
            }
            if (deleteindex > 0) {
                IMarker[] todelete = new IMarker[deleteindex];
                System.arraycopy(deleteMarkers, 0, todelete, 0, deleteindex);
                file.getWorkspace().deleteMarkers(todelete);
            }
        }
        catch (CoreException e) {
            Logger.error(e);
        }
    }

    public void cancel() {
    }

    public List getErrorList() {
        ArrayList<IMessage> out = new ArrayList<IMessage>();
        for (IMessage message : this.messages) {
            if (1 != message.getSeverity()) continue;
            out.add(message);
        }
        return out;
    }

    public List getWarningList() {
        ArrayList<IMessage> out = new ArrayList<IMessage>();
        for (IMessage message : this.messages) {
            if (2 != message.getSeverity()) continue;
            out.add(message);
        }
        return out;
    }

    public List getMessages() {
        return null;
    }

    public int getErrorsCount() {
        return this.errorCount;
    }

    public int getWarningsCount() {
        return this.warnCount;
    }

    public boolean isCanceled() {
        return false;
    }

    public void removeAllMessages() {
        this.messages.clear();
    }
}

