/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.popup.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.common.validator.base.MemoryReporter;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.eclipse.stp.policy.wtp.validation.Logger;
import org.eclipse.stp.policy.wtp.validation.impl.IDEProblemsReporter;
import org.eclipse.stp.policy.wtp.validation.impl.IDEValidationContextFactory;
import org.eclipse.stp.policy.wtp.validation.popup.actions.IValidationAction;
import org.w3c.dom.Document;

public abstract class CommonValidationAction
extends Action
implements IRunnableWithProgress,
IValidationAction {
    private IFile resource = null;
    private File extResource = null;
    private IValidationContext context = null;
    private IReporter reporter = null;

    public CommonValidationAction(IFile file) {
        this.resource = file;
    }

    public CommonValidationAction(File file) {
        this.extResource = file;
    }

    public int getWarningsCount() {
        return this.getReporter().getWarningsCount();
    }

    public int getErrorsCount() {
        return this.getReporter().getErrorsCount();
    }

    public List getWarningMessages() {
        return this.getReporter().getWarningList();
    }

    public List getErrorMessages() {
        return this.getReporter().getErrorList();
    }

    public void run() {
        try {
            this.validate();
        }
        catch (SOPValidationException e) {
            Logger.error(e);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String filename = this.resource != null ? this.resource.getName() : this.extResource.getName();
        monitor.beginTask("SOPERA Validation: " + filename, 1);
        try {
            try {
                this.validate();
            }
            catch (SOPValidationException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void validate() throws SOPValidationException {
        this.getReporter().removeAllMessages();
    }

    private void initContext() throws ContextInitializationException {
        if (this.context == null) {
            IDEValidationContextFactory contextFactory = IDEValidationContextFactory.getInstance();
            this.context = this.resource != null ? contextFactory.createContext(this.resource) : contextFactory.createContext(this.extResource);
        }
    }

    private void initContext(Document doc, ValidationObjectTypeEnum type) throws ContextInitializationException {
        if (this.context == null) {
            IDEValidationContextFactory contextFactory = IDEValidationContextFactory.getInstance();
            this.context = contextFactory.createContext(doc, type);
        }
    }

    protected IValidationContext getValidationContext() throws ContextInitializationException {
        this.initContext();
        return this.context;
    }

    protected IValidationContext getValidationContext(Document doc, ValidationObjectTypeEnum type) throws ContextInitializationException {
        this.initContext(doc, type);
        return this.context;
    }

    protected IReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = this.resource != null ? new IDEProblemsReporter(this.resource) : new MemoryReporter();
        }
        return this.reporter;
    }

    protected String getObjectType() {
        String extension;
        if (this.resource != null) {
            extension = this.resource.getFileExtension().toUpperCase();
        } else {
            String filename = this.extResource.getName();
            extension = filename.substring(filename.lastIndexOf(46) + 1).toUpperCase();
        }
        String type = null;
        if (extension.equals("SDX")) {
            type = "SDX";
        } else if (extension.equals("SPDX")) {
            type = "SPDX";
        } else if (extension.equals("PPDX")) {
            type = "PPDX";
        } else if (extension.equals("OPDX")) {
            type = "OPDX";
        }
        return type;
    }
}

