/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.common.jdt.builder.ScaTnsNameCouple;
import org.eclipse.stp.sca.provider.ScaItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaDependencyVertex {
    private IFile file;
    private ScaTnsNameCouple tnsNameCouple;
    private List<ScaTnsNameCouple> includes = new ArrayList<ScaTnsNameCouple>();
    private boolean isValidEmfFile = true;
    private Resource resource;

    protected ScaDependencyVertex(IFile file) {
        this.file = file;
        this.loadResource();
    }

    private void loadResource() {
        try {
            Resource resource = this.getEmfResource();
            if (resource == null) {
                return;
            }
            DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
            if (root.getComposite() != null) {
                this.tnsNameCouple = new ScaTnsNameCouple();
                this.tnsNameCouple.name = root.getComposite().getName();
                this.tnsNameCouple.targetNamespace = root.getComposite().getTargetNamespace();
                if (root.getInclude() != null && root.getInclude().getName() != null) {
                    ScaTnsNameCouple include = new ScaTnsNameCouple();
                    include.name = root.getInclude().getName().getLocalPart();
                    include.targetNamespace = root.getInclude().getName().getNamespaceURI();
                }
            } else {
                this.isValidEmfFile = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Resource getEmfResource() {
        if (this.resource == null && this.isValidEmfFile) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ScaItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            BasicCommandStack commandStack = new BasicCommandStack();
            AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
            try {
                URI uri = URI.createFileURI((String)this.file.getLocation().toString());
                this.resource = editingDomain.getResourceSet().getResource(uri, true);
            }
            catch (Exception e) {
                this.isValidEmfFile = false;
                e.printStackTrace();
            }
        }
        return this.resource;
    }

    public IFile getFile() {
        return this.file;
    }

    public ScaTnsNameCouple getTnsNameCouple() {
        return this.tnsNameCouple;
    }

    public List<ScaTnsNameCouple> getIncludes() {
        return this.includes;
    }

    public boolean isValidEmfFile() {
        return this.isValidEmfFile;
    }
}

