/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.common.jdt.Messages;
import org.eclipse.stp.sca.common.jdt.builder.ScaCustomDiagnostician;
import org.eclipse.stp.sca.common.jdt.builder.ScaDependencyGraph;
import org.eclipse.stp.sca.common.jdt.builder.ScaDependencyVertex;
import org.eclipse.stp.sca.common.jdt.builder.ScaMarkerHelper;
import org.eclipse.stp.sca.common.jdt.builder.extensions.ScaBuilderJavaExtension;
import org.eclipse.stp.sca.common.jdt.utils.ResourceExplorer;
import org.eclipse.stp.sca.common.jdt.utils.filters.SkippedResources;

public class ScaIncrementalBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.stp.sca.common.jdt.scaBuilder";
    public static final String SCA_COMP_MARKER = "org.eclipse.stp.sca.common.jdt.composite";
    public static final String SCA_F_DIAG_MARKER = "org.eclipse.stp.sca.common.jdt.fDiagram";
    public static final String SCA_SIGNATURE_ATTRIBUTE = "signature";
    private ScaDependencyGraph graph = new ScaDependencyGraph();
    private ScaBuilderJavaExtension builderJavaExtension = new ScaBuilderJavaExtension();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            ScaIncrementalBuilder.clearScaMarkers((IResource)this.getProject(), 2);
            List<IFile> compositeFiles = ResourceExplorer.getFiles(this.getProject(), "composite");
            compositeFiles = SkippedResources.filterAllowedFiles(compositeFiles);
            this.graph.clearVertices();
            for (IFile file : compositeFiles) {
                this.graph.loadVertex(file);
            }
            this.performValidation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ScaIncrementalBuilder.clearScaMarkers((IResource)this.getProject(), 2);
        super.clean(monitor);
    }

    public static void clearScaMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers(SCA_COMP_MARKER, true, depth);
            resource.deleteMarkers(SCA_F_DIAG_MARKER, true, depth);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ScaIncrementalBuilder.clearScaMarkers((IResource)this.getProject(), 2);
        ValidatingScaDeltaVisitor visitor = new ValidatingScaDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        if (visitor.javaResourcesChanged) {
            this.fullBuild(monitor);
            return;
        }
        List<IFile> filesToValidate = SkippedResources.filterAllowedFiles(visitor.getAllowedFiles());
        for (IFile file : filesToValidate) {
            this.graph.loadVertex(file);
        }
        this.performValidation();
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    private void performValidation() {
        DocumentRoot root;
        DocumentRoot eObject;
        String message;
        String filename;
        for (ScaDependencyVertex scaDependencyVertex : this.graph.findFilesEmfCouldNotLoad()) {
            filename = scaDependencyVertex.getFile().getName();
            message = NLS.bind((String)Messages.IncrementalBuilder_2, (Object)filename);
            ScaMarkerHelper.createMarker(scaDependencyVertex.getFile(), SCA_COMP_MARKER, message, 2, null);
            ScaMarkerHelper.createFakeDiagMarker(scaDependencyVertex.getFile(), null);
        }
        for (ScaDependencyVertex scaDependencyVertex : this.graph.findFilesWithWrongName()) {
            filename = scaDependencyVertex.getFile().getName();
            message = NLS.bind((String)Messages.IncrementalBuilder_3, (Object)filename);
            eObject = null;
            if (scaDependencyVertex.getEmfResource() != null) {
                root = (DocumentRoot)scaDependencyVertex.getEmfResource().getContents().get(0);
                eObject = root.getComposite() == null ? root : root.getComposite();
            }
            ScaMarkerHelper.createMarker(scaDependencyVertex.getFile(), SCA_COMP_MARKER, message, 2, eObject);
            ScaMarkerHelper.createFakeDiagMarker(scaDependencyVertex.getFile(), null);
        }
        for (ScaDependencyVertex scaDependencyVertex : this.graph.findFilesWithSameIds()) {
            String message2 = NLS.bind((String)Messages.IncrementalBuilder_5, (Object[])new Object[]{scaDependencyVertex.getTnsNameCouple().name, scaDependencyVertex.getTnsNameCouple().targetNamespace});
            DocumentRoot eObject2 = null;
            if (scaDependencyVertex.getEmfResource() != null) {
                DocumentRoot root2 = (DocumentRoot)scaDependencyVertex.getEmfResource().getContents().get(0);
                eObject2 = root2.getComposite() == null ? root2 : root2.getComposite();
            }
            ScaMarkerHelper.createMarker(scaDependencyVertex.getFile(), SCA_COMP_MARKER, message2, 2, eObject2);
            ScaMarkerHelper.createFakeDiagMarker(scaDependencyVertex.getFile(), null);
        }
        for (Map.Entry entry : this.graph.findDependencyCycles().entrySet()) {
            IFile file = ((ScaDependencyVertex)entry.getKey()).getFile();
            message = NLS.bind((String)Messages.IncrementalBuilder_8, entry.getValue());
            eObject = null;
            if (((ScaDependencyVertex)entry.getKey()).getEmfResource() != null) {
                root = (DocumentRoot)((ScaDependencyVertex)entry.getKey()).getEmfResource().getContents().get(0);
                eObject = root.getComposite() == null ? root : root.getComposite();
            }
            ScaMarkerHelper.createMarker(file, SCA_COMP_MARKER, message, 2, (EObject)eObject);
            ScaMarkerHelper.createFakeDiagMarker(file, null);
        }
        for (ScaDependencyVertex scaDependencyVertex : this.graph.getFilesToValidateWithEmf()) {
            String path;
            if (scaDependencyVertex.getEmfResource() == null) continue;
            DocumentRoot root3 = (DocumentRoot)scaDependencyVertex.getEmfResource().getContents().get(0);
            Diagnostic diagnostic = null;
            try {
                diagnostic = new ScaCustomDiagnostician().validate((EObject)root3);
            }
            catch (Exception e) {
                diagnostic = new BasicDiagnostic(4, e.getMessage(), 0, Messages.ScaIncrementalBuilder_3, new Object[0]);
            }
            ScaMarkerHelper.createScaMarkers(diagnostic, scaDependencyVertex.getFile(), SCA_COMP_MARKER);
            if (diagnostic.getSeverity() != 0) {
                ScaMarkerHelper.createFakeDiagMarker(scaDependencyVertex.getFile(), null);
            }
            URI uri = root3.eResource().getURI();
            IResource r = null;
            if (uri.isPlatform()) {
                path = uri.toPlatformString(false);
                path = path.replaceFirst("platform:/resource", "");
                r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            } else {
                path = uri.toFileString();
                path = path.replaceFirst("file:/", "");
                IFile[] resources = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(path));
                if (resources.length == 1) {
                    r = resources[0];
                }
            }
            try {
                IProject p;
                if (r == null || !(r instanceof IFile) || !(p = r.getProject()).hasNature("org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create((IProject)p);
                List<Diagnostic> diagnostics = this.builderJavaExtension.validate(root3, javaProject);
                diagnostic = new BasicDiagnostic("", 0, diagnostics, Messages.ScaIncrementalBuilder_9, new Object[0]);
                ScaMarkerHelper.createScaMarkers(diagnostic, scaDependencyVertex.getFile(), SCA_COMP_MARKER);
                if (diagnostic.getSeverity() == 0) continue;
                ScaMarkerHelper.createFakeDiagMarker(scaDependencyVertex.getFile(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidatingScaDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private List<IFile> allowedFiles = new ArrayList<IFile>();
        private boolean javaResourcesChanged = false;

        public ValidatingScaDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            ScaIncrementalBuilder.this.checkCancel(this.monitor);
            IResource resource = delta.getResource();
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return false;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.getFileExtension().equals("class") || file.getName().equals(".classpath")) {
                    this.javaResourcesChanged = true;
                    return false;
                }
                if (file.getFileExtension().equals("composite")) {
                    ScaIncrementalBuilder.this.graph.removeVertex(file);
                    if (file.exists()) {
                        this.allowedFiles.add(file);
                    }
                }
            }
            return true;
        }

        public List<IFile> getAllowedFiles() {
            return this.allowedFiles;
        }
    }
}

