/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.common.jdt.Messages;
import org.eclipse.stp.sca.common.jdt.utils.ScaSignature;

public class ScaMarkerHelper {
    public static void createScaMarkers(Diagnostic diagnostic, IFile iFile, String markerType) {
        if (diagnostic.getChildren() == null || diagnostic.getChildren().isEmpty()) {
            if (diagnostic.getSeverity() == 0) {
                return;
            }
            try {
                Object o;
                IMarker marker = iFile.createMarker(markerType);
                marker.setAttribute("lineNumber", 1);
                marker.setAttribute("priority", 1);
                if (diagnostic.getSeverity() < 2) {
                    marker.setAttribute("severity", 0);
                } else if (diagnostic.getSeverity() < 4) {
                    marker.setAttribute("severity", 1);
                } else {
                    marker.setAttribute("severity", 2);
                }
                String message = diagnostic.getMessage();
                message = String.valueOf(message) + (message.endsWith(".") ? "" : ".");
                marker.setAttribute("message", (Object)message);
                List data = diagnostic.getData();
                if (data != null && !data.isEmpty() && (o = diagnostic.getData().get(0)) != null && o instanceof EObject) {
                    ScaSignature sig = new ScaSignature((EObject)o);
                    marker.setAttribute("signature", (Object)sig.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                int maxSeverity = 0;
                try {
                    Object o;
                    IMarker marker = iFile.createMarker(markerType);
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("priority", 1);
                    if (childDiagnostic.getSeverity() < 2) {
                        marker.setAttribute("severity", 0);
                        if (maxSeverity < 2) {
                            maxSeverity = 1;
                        }
                    } else if (childDiagnostic.getSeverity() < 4) {
                        marker.setAttribute("severity", 1);
                        if (maxSeverity < 4) {
                            maxSeverity = 2;
                        }
                    } else {
                        marker.setAttribute("severity", 2);
                        maxSeverity = 4;
                    }
                    String message = childDiagnostic.getMessage();
                    message = String.valueOf(message) + (message.endsWith(".") ? "" : ".");
                    marker.setAttribute("message", (Object)message);
                    List data = childDiagnostic.getData();
                    if (data == null || data.isEmpty() || (o = data.get(0)) == null || !(o instanceof EObject)) continue;
                    ScaSignature sig = new ScaSignature((EObject)o);
                    marker.setAttribute("signature", (Object)sig.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void createMarker(IFile file, String markerType, String message, int severity, EObject eObject) {
        try {
            IMarker marker = file.createMarker(markerType);
            marker.setAttribute("severity", severity);
            marker.setAttribute("priority", 1);
            marker.setAttribute("message", (Object)message);
            if (eObject != null) {
                ScaSignature sig = new ScaSignature(eObject);
                marker.setAttribute("signature", (Object)sig.toString());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void createDiagMarker(IFile file, String markerType, String message, int severity, EObject eObject) {
        IFile diagFile = ScaMarkerHelper.getCompositeDiagramFile(file);
        if (diagFile != null) {
            ScaMarkerHelper.createMarker(diagFile, markerType, message, severity, eObject);
        }
    }

    public static void createFakeDiagMarker(IFile file, EObject eObject) {
        IFile diagFile = ScaMarkerHelper.getCompositeDiagramFile(file);
        int severity = 4;
        try {
            severity = file.findMaxProblemSeverity("org.eclipse.stp.sca.common.jdt.composite", true, 0);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            if (diagFile != null) {
                int formerSeverity = diagFile.findMaxProblemSeverity("org.eclipse.stp.sca.common.jdt.fDiagram", true, 0);
                if (formerSeverity < severity) {
                    diagFile.deleteMarkers("org.eclipse.stp.sca.common.jdt.fDiagram", true, 0);
                }
                ScaMarkerHelper.createMarker(diagFile, "org.eclipse.stp.sca.common.jdt.fDiagram", ScaMarkerHelper.getFakeMarkerMessage(file), severity, eObject);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static String getFakeMarkerMessage(IFile compositeFile) {
        return NLS.bind((String)Messages.MarkerHelper_0, (Object)compositeFile.getName());
    }

    public static IFile getCompositeDiagramFile(IFile compositeFile) {
        if (compositeFile == null || !compositeFile.getName().endsWith(".composite")) {
            return null;
        }
        try {
            IPath compPath = compositeFile.getProjectRelativePath().removeFileExtension().addFileExtension("composite_diagram");
            IFile compositeDiagramFile = compositeFile.getProject().getFile(compPath);
            if (compositeDiagramFile.exists()) {
                return compositeDiagramFile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

