/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceExplorer {
    public static List<IFile> getFiles(IProject project) {
        return ResourceExplorer.getFiles(project, "*");
    }

    public static List<IFile> getFiles(IProject project, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(ResourceExplorer.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<IFile> getFiles(IFolder folder) {
        return ResourceExplorer.getFiles(folder, "*");
    }

    public static List<IFile> getFiles(IFolder folder, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(ResourceExplorer.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IFile editedFile = ((FileEditorInput)editorPart.getEditorInput()).getFile();
            return editedFile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IResource[] getDirectValidChildren(IContainer container, List<String> extensions, List<IResource> resourcesToSkip) {
        IResource[] res;
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return new IResource[0];
        }
        try {
            res = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
            res = new IResource[]{};
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] iResourceArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (!resourcesToSkip.contains(r)) {
                String extension;
                if (r instanceof IContainer) {
                    IResource[] subRes = ResourceExplorer.getDirectValidChildren((IContainer)r, extensions, resourcesToSkip);
                    if (subRes.length > 0) {
                        resources.add(r);
                    }
                } else if (r instanceof IFile && extensions.contains(extension = ((IFile)r).getFileExtension())) {
                    resources.add(r);
                }
            }
            ++n2;
        }
        res = new IResource[resources.size()];
        return resources.toArray(res);
    }

    public static IResource[] getDirectValidChildren(IContainer container, String[] extensions, List<IResource> resourcesToSkip) {
        return ResourceExplorer.getDirectValidChildren(container, Arrays.asList(extensions), resourcesToSkip);
    }

    public static File getPluginBinaryPath(String pluginId, String binaryFolderName) {
        if (binaryFolderName == null || binaryFolderName.trim().length() == 0) {
            binaryFolderName = "bin";
        }
        try {
            File binaryFolder;
            File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            if (bundleFile.isFile()) {
                return bundleFile;
            }
            if (bundleFile.isDirectory() && (binaryFolder = new File(bundleFile, binaryFolderName)).exists() && binaryFolder.isDirectory()) {
                return binaryFolder;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

