/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.deployment.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.sca.common.jdt.utils.Base64;
import org.eclipse.stp.sca.common.jdt.utils.ResourceExplorer;
import org.eclipse.stp.sca.deployment.Messages;
import org.eclipse.stp.sca.deployment.ScaDeploymentPlugin;
import org.eclipse.stp.sca.deployment.Utils;
import org.eclipse.stp.sca.deployment.preferences.ScaMasterLaunchConfigDesc;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<ScaMasterLaunchConfigDesc> beans;
    private String scaDeploymentPluginPath;
    private TableViewer masterConfigViewer;
    private TableViewer classpathViewer;
    private Text mainClassText;
    private Text programArgsText;
    private List<Control> enabledWhenConfigSelected = new ArrayList<Control>();
    private List<Control> enabledWhenClasspathSelected = new ArrayList<Control>();
    private ScaMasterLaunchConfigDesc selectedConfig;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ScaDeploymentPlugin.getDefault().getPreferenceStore());
        File f = ResourceExplorer.getPluginBinaryPath((String)"org.eclipse.stp.sca.deployment", null);
        this.scaDeploymentPluginPath = f != null ? f.getAbsolutePath() : null;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setLayout((Layout)new GridLayout());
        this.addMasterConfigTable(container);
        TabFolder tabFolder = new TabFolder(container, 128);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        tabFolder.setLayoutData((Object)gd);
        this.addMainClassText(tabFolder);
        this.addClasspathTable(tabFolder);
        this.masterConfigViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean hasSelection = !ScaRuntimePreferencePage.this.masterConfigViewer.getSelection().isEmpty();
                ScaRuntimePreferencePage.this.classpathViewer.getTable().setEnabled(hasSelection);
                for (Control c : ScaRuntimePreferencePage.this.enabledWhenConfigSelected) {
                    c.setEnabled(hasSelection);
                }
                if (hasSelection) {
                    Object o = ((IStructuredSelection)ScaRuntimePreferencePage.this.masterConfigViewer.getSelection()).getFirstElement();
                    ScaRuntimePreferencePage.this.selectedConfig = (ScaMasterLaunchConfigDesc)o;
                } else {
                    ScaRuntimePreferencePage.this.selectedConfig = null;
                }
                ScaRuntimePreferencePage.this.mainClassText.setText(ScaRuntimePreferencePage.this.selectedConfig == null ? "" : ScaRuntimePreferencePage.this.selectedConfig.getMainClass());
                ScaRuntimePreferencePage.this.programArgsText.setText(ScaRuntimePreferencePage.this.selectedConfig == null ? "" : ScaRuntimePreferencePage.this.selectedConfig.getProgramArguments());
                ScaRuntimePreferencePage.this.classpathViewer.setInput(ScaRuntimePreferencePage.this.selectedConfig == null ? new Object[]{} : ScaRuntimePreferencePage.this.selectedConfig.getClasspath());
            }
        });
        this.classpathViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean hs = !ScaRuntimePreferencePage.this.classpathViewer.getSelection().isEmpty();
                for (Control c : ScaRuntimePreferencePage.this.enabledWhenClasspathSelected) {
                    c.setEnabled(hs);
                }
            }
        });
        this.masterConfigViewer.getTable().notifyListeners(13, new Event());
        this.classpathViewer.getTable().notifyListeners(13, new Event());
        return container;
    }

    private void addClasspathTable(TabFolder tabFolder) {
        TabItem item = new TabItem(tabFolder, 0);
        item.setText(Messages.ScaRuntimePreferencePage_3);
        Composite comp = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 7;
        comp.setLayout((Layout)layout);
        item.setControl((Control)comp);
        Label l = new Label(comp, 0);
        l.setText(Messages.ScaRuntimePreferencePage_4);
        this.enabledWhenConfigSelected.add((Control)l);
        Composite subC = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        subC.setLayout((Layout)layout);
        subC.setLayoutData((Object)new GridData(1808));
        Table table = new Table(subC, 34818);
        table.setLayoutData((Object)new GridData(1808));
        this.classpathViewer = new TableViewer(table);
        this.classpathViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.classpathViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            Image libImg = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.deployment", (String)"icons/obj16/jar_l_obj.gif").createImage();
            Image folderImg = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.deployment", (String)"icons/obj16/packagefolder_obj.gif").createImage();

            public String getText(Object element) {
                Path path = new Path((String)element);
                return String.valueOf(path.lastSegment()) + " - " + path.removeLastSegments(1).toString();
            }

            public Image getImage(Object element) {
                String s = (String)element;
                if (s.endsWith(".jar") || s.endsWith(".zip")) {
                    return this.libImg;
                }
                return this.folderImg;
            }

            public void dispose() {
                this.libImg.dispose();
                this.folderImg.dispose();
                super.dispose();
            }
        });
        Composite buttons = new Composite(subC, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(1040));
        Button addLibraryButton = new Button(buttons, 8);
        this.enabledWhenConfigSelected.add((Control)addLibraryButton);
        addLibraryButton.setText(Messages.ScaRuntimePreferencePage_13);
        addLibraryButton.setLayoutData((Object)new GridData(768));
        addLibraryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(ScaRuntimePreferencePage.this.getShell(), 2);
                dlg.setText(Messages.ScaRuntimePreferencePage_14);
                dlg.setFilterNames(new String[]{"Archive file (*.jar, *.zip)"});
                dlg.setFilterExtensions(new String[]{"*.jar;*.zip;"});
                if (dlg.open() != null) {
                    File parent = new File(dlg.getFilterPath());
                    String[] stringArray = dlg.getFileNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filename = stringArray[n2];
                        File chosenFile = new File(parent, filename);
                        ScaRuntimePreferencePage.this.selectedConfig.getClasspath().add(chosenFile.getAbsolutePath());
                        ++n2;
                    }
                    ScaRuntimePreferencePage.this.classpathViewer.refresh();
                    ScaRuntimePreferencePage.this.classpathViewer.getTable().setFocus();
                }
            }
        });
        Button addClassFolderButton = new Button(buttons, 8);
        this.enabledWhenConfigSelected.add((Control)addClassFolderButton);
        addClassFolderButton.setText(Messages.ScaRuntimePreferencePage_19);
        addClassFolderButton.setLayoutData((Object)new GridData(768));
        addClassFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(ScaRuntimePreferencePage.this.getShell(), 0);
                dlg.setText(Messages.ScaRuntimePreferencePage_20);
                String fn = dlg.open();
                if (fn != null) {
                    String s = new File(fn).getAbsolutePath();
                    ScaRuntimePreferencePage.this.selectedConfig.getClasspath().add(s);
                    ScaRuntimePreferencePage.this.classpathViewer.refresh();
                    ScaRuntimePreferencePage.this.classpathViewer.setSelection((ISelection)new StructuredSelection((Object)s));
                    ScaRuntimePreferencePage.this.classpathViewer.getTable().setFocus();
                }
            }
        });
        Button removeClasspathEntryButton = new Button(buttons, 8);
        this.enabledWhenClasspathSelected.add((Control)removeClasspathEntryButton);
        removeClasspathEntryButton.setText(Messages.ScaRuntimePreferencePage_10);
        removeClasspathEntryButton.setLayoutData((Object)new GridData(768));
        removeClasspathEntryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaRuntimePreferencePage.this.removeClasspathEntries();
            }
        });
        this.classpathViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    ScaRuntimePreferencePage.this.removeClasspathEntries();
                }
            }
        });
    }

    protected void removeClasspathEntries() {
        if (!this.classpathViewer.getSelection().isEmpty() && this.selectedConfig != null) {
            List selection = ((IStructuredSelection)this.classpathViewer.getSelection()).toList();
            this.selectedConfig.getClasspath().removeAll(selection);
            this.classpathViewer.refresh();
        }
    }

    protected void removeMasterLaunchConfiguration() {
        if (!this.masterConfigViewer.getSelection().isEmpty()) {
            Object o = ((IStructuredSelection)this.masterConfigViewer.getSelection()).getFirstElement();
            this.beans.remove(o);
            this.masterConfigViewer.refresh();
        }
    }

    private void addMainClassText(TabFolder tabFolder) {
        TabItem item = new TabItem(tabFolder, 0);
        item.setText(Messages.ScaRuntimePreferencePage_21);
        Composite comp = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 7;
        comp.setLayout((Layout)layout);
        item.setControl((Control)comp);
        Label l = new Label(comp, 0);
        l.setText(Messages.ScaRuntimePreferencePage_22);
        this.enabledWhenConfigSelected.add((Control)l);
        this.mainClassText = new Text(comp, 2052);
        this.enabledWhenConfigSelected.add((Control)this.mainClassText);
        this.mainClassText.setLayoutData((Object)new GridData(768));
        this.mainClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScaRuntimePreferencePage.this.selectedConfig != null) {
                    ScaRuntimePreferencePage.this.selectedConfig.setMainClass(ScaRuntimePreferencePage.this.mainClassText.getText());
                }
            }
        });
        l = new Label(comp, 0);
        l.setText(Messages.ScaRuntimePreferencePage_23);
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 10;
        l.setLayoutData((Object)layoutData);
        this.enabledWhenConfigSelected.add((Control)l);
        this.programArgsText = new Text(comp, 2114);
        this.enabledWhenConfigSelected.add((Control)this.programArgsText);
        this.programArgsText.setLayoutData((Object)new GridData(1808));
        this.programArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScaRuntimePreferencePage.this.selectedConfig != null) {
                    ScaRuntimePreferencePage.this.selectedConfig.setProgramArguments(ScaRuntimePreferencePage.this.programArgsText.getText());
                }
            }
        });
    }

    private void addMasterConfigTable(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.ScaRuntimePreferencePage_24);
        Composite subC = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        subC.setLayout((Layout)layout);
        subC.setLayoutData((Object)new GridData(768));
        Table masterConfigTable = new Table(subC, 2052);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        masterConfigTable.setLayoutData((Object)gd);
        this.masterConfigViewer = new TableViewer(masterConfigTable);
        this.masterConfigViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.masterConfigViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ScaMasterLaunchConfigDesc)element).getName();
            }
        });
        this.beans = ScaRuntimePreferencePage.getRuntimesFromPreferences();
        this.masterConfigViewer.setInput(this.beans);
        Composite buttons = new Composite(subC, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(buttons, 8);
        addButton.setText(Messages.ScaRuntimePreferencePage_8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dlg = ScaRuntimePreferencePage.this.getConfigurationInputDialog(null);
                if (dlg.open() == 0) {
                    HashSet<String> initialCP = new HashSet<String>();
                    if (ScaRuntimePreferencePage.this.scaDeploymentPluginPath != null) {
                        initialCP.add(ScaRuntimePreferencePage.this.scaDeploymentPluginPath);
                    }
                    ScaMasterLaunchConfigDesc desc = new ScaMasterLaunchConfigDesc(dlg.getValue(), "", "${composite_name}", initialCP);
                    ScaRuntimePreferencePage.this.beans.add(desc);
                    ScaRuntimePreferencePage.this.masterConfigViewer.refresh();
                    ScaRuntimePreferencePage.this.masterConfigViewer.setSelection((ISelection)new StructuredSelection((Object)desc));
                    ScaRuntimePreferencePage.this.masterConfigViewer.getTable().setFocus();
                }
            }
        });
        Button editButton = new Button(buttons, 8);
        this.enabledWhenConfigSelected.add((Control)editButton);
        editButton.setText(Messages.ScaRuntimePreferencePage_9);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                ScaMasterLaunchConfigDesc desc;
                InputDialog dlg;
                if (ScaRuntimePreferencePage.this.masterConfigViewer.getSelection() != null && !ScaRuntimePreferencePage.this.masterConfigViewer.getSelection().isEmpty() && (dlg = ScaRuntimePreferencePage.this.getConfigurationInputDialog((desc = (ScaMasterLaunchConfigDesc)(o = ((IStructuredSelection)ScaRuntimePreferencePage.this.masterConfigViewer.getSelection()).getFirstElement())).getName())).open() == 0) {
                    try {
                        Utils.updateScaLaunchConfigurationName(desc.getName(), dlg.getValue());
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                    desc.setName(dlg.getValue());
                    ScaRuntimePreferencePage.this.masterConfigViewer.update((Object)desc, null);
                }
            }
        });
        Button removeButton = new Button(buttons, 8);
        this.enabledWhenConfigSelected.add((Control)removeButton);
        removeButton.setText(Messages.ScaRuntimePreferencePage_10);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaRuntimePreferencePage.this.removeMasterLaunchConfiguration();
            }
        });
        this.masterConfigViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    ScaRuntimePreferencePage.this.removeMasterLaunchConfiguration();
                }
            }
        });
    }

    public static List<ScaMasterLaunchConfigDesc> getRuntimesFromPreferences() {
        String prefs = ScaDeploymentPlugin.getDefault().getPreferenceStore().getString("org.eclipse.stp.sca.deployment.masterLaunchConfigurations");
        if (prefs.length() == 0) {
            return new ArrayList<ScaMasterLaunchConfigDesc>();
        }
        ByteArrayInputStream iStream = new ByteArrayInputStream(Base64.decode((byte[])prefs.getBytes()));
        try {
            ObjectInputStream o = new ObjectInputStream(iStream);
            return (List)o.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<ScaMasterLaunchConfigDesc>();
        }
    }

    protected void savePreferences() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(oStream);
            o.writeObject(this.beans);
            o.close();
            byte[] bytes = Base64.encode((byte[])oStream.toByteArray());
            String prefs = new String(bytes);
            this.getPreferenceStore().setValue("org.eclipse.stp.sca.deployment.masterLaunchConfigurations", prefs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.savePreferences();
        super.performApply();
    }

    private InputDialog getConfigurationInputDialog(String initialValue) {
        return new InputDialog(this.getShell(), Messages.ScaRuntimePreferencePage_26, Messages.ScaRuntimePreferencePage_27, initialValue, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return Messages.ScaRuntimePreferencePage_28;
                }
                for (ScaMasterLaunchConfigDesc bean : ScaRuntimePreferencePage.this.beans) {
                    if (!bean.getName().equals(newText)) continue;
                    return Messages.ScaRuntimePreferencePage_29;
                }
                return null;
            }
        });
    }

    public static List<String> getMasterLaunchConfigurationNames() {
        List<ScaMasterLaunchConfigDesc> descs = ScaRuntimePreferencePage.getRuntimesFromPreferences();
        ArrayList<String> result = new ArrayList<String>(descs.size());
        for (ScaMasterLaunchConfigDesc desc : descs) {
            result.add(desc.getName());
        }
        return result;
    }

    public static ScaMasterLaunchConfigDesc getMasterLaunchConfiguration(String name) {
        List<ScaMasterLaunchConfigDesc> descs = ScaRuntimePreferencePage.getRuntimesFromPreferences();
        for (ScaMasterLaunchConfigDesc desc : descs) {
            if (!desc.getName().equals(name)) continue;
            return desc;
        }
        return null;
    }

    static /* synthetic */ TableViewer access$0(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.masterConfigViewer;
    }

    static /* synthetic */ TableViewer access$1(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.classpathViewer;
    }

    static /* synthetic */ List access$2(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.enabledWhenConfigSelected;
    }

    static /* synthetic */ void access$3(ScaRuntimePreferencePage scaRuntimePreferencePage, ScaMasterLaunchConfigDesc scaMasterLaunchConfigDesc) {
        scaRuntimePreferencePage.selectedConfig = scaMasterLaunchConfigDesc;
    }

    static /* synthetic */ Text access$4(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.mainClassText;
    }

    static /* synthetic */ ScaMasterLaunchConfigDesc access$5(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.selectedConfig;
    }

    static /* synthetic */ Text access$6(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.programArgsText;
    }

    static /* synthetic */ List access$7(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.enabledWhenClasspathSelected;
    }

    static /* synthetic */ InputDialog access$8(ScaRuntimePreferencePage scaRuntimePreferencePage, String string) {
        return scaRuntimePreferencePage.getConfigurationInputDialog(string);
    }

    static /* synthetic */ String access$9(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.scaDeploymentPluginPath;
    }

    static /* synthetic */ List access$10(ScaRuntimePreferencePage scaRuntimePreferencePage) {
        return scaRuntimePreferencePage.beans;
    }
}

