/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.jdt.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.sca.BaseReference;
import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.JavaInterface;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.diagram.jdt.Messages;
import org.eclipse.stp.sca.diagram.providers.ScaElementTypes;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CreateJavaInterfaceAction
implements IObjectActionDelegate {
    private IJavaProject javaProject;
    private IWorkbenchPart part;
    private ShapeNodeEditPart shapeNodeEP;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        Shell shell = this.part.getSite().getShell();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaProject}, (int)11);
        String filter = "?";
        try {
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)scope, (int)4, (boolean)true, (String)filter);
            if (dlg.open() == 0) {
                IType type = (IType)dlg.getResult()[0];
                String selection = type.getFullyQualifiedName();
                this.createJavaInterface(selection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createJavaInterface(String selection) throws Exception {
        JavaInterface ji = ScaFactory.eINSTANCE.createJavaInterface();
        CompoundCommand cc = null;
        if (this.shapeNodeEP.resolveSemanticElement() instanceof ComponentService) {
            cc = this.createJavaInterface(ji, selection, ScaElementTypes.JavaInterface_3014);
        } else if (this.shapeNodeEP.resolveSemanticElement() instanceof ComponentReference) {
            cc = this.createJavaInterface(ji, selection, ScaElementTypes.JavaInterface_3019);
        } else if (this.shapeNodeEP.resolveSemanticElement() instanceof Service) {
            cc = this.createJavaInterface(ji, selection, ScaElementTypes.JavaInterface_3002);
        } else if (this.shapeNodeEP.resolveSemanticElement() instanceof Reference) {
            cc = this.createJavaInterface(ji, selection, ScaElementTypes.JavaInterface_3007);
        }
        this.shapeNodeEP.getDiagramEditDomain().getDiagramCommandStack().execute((org.eclipse.gef.commands.Command)cc);
        JavaInterface ji2 = null;
        if (this.shapeNodeEP.resolveSemanticElement() instanceof BaseService) {
            ji2 = (JavaInterface)((BaseService)this.shapeNodeEP.resolveSemanticElement()).getInterface();
        } else if (this.shapeNodeEP.resolveSemanticElement() instanceof BaseReference) {
            ji2 = (JavaInterface)((BaseReference)this.shapeNodeEP.resolveSemanticElement()).getInterface();
        }
        SetCommand sc = new SetCommand((EditingDomain)this.shapeNodeEP.getEditingDomain(), (EObject)ji2, (EStructuralFeature)ScaPackage.eINSTANCE.getJavaInterface_Interface(), (Object)selection);
        this.shapeNodeEP.getEditingDomain().getCommandStack().execute((Command)sc);
    }

    private CompoundCommand createJavaInterface(JavaInterface ji, String selection, IElementType jiElementType) {
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(jiElementType)), Node.class, ((IHintedType)jiElementType).getSemanticHint(), this.shapeNodeEP.getDiagramPreferencesHint());
        CreateViewAndElementRequest req = new CreateViewAndElementRequest(viewDescriptor);
        CompoundCommand cmd = new CompoundCommand(Messages.CreateJavaImplementationAction_1);
        cmd.add(this.shapeNodeEP.getCommand((Request)req));
        return cmd;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o == null) {
            action.setEnabled(false);
            return;
        }
        this.shapeNodeEP = (ShapeNodeEditPart)o;
        if (!this.canExecute(this.shapeNodeEP.resolveSemanticElement())) {
            action.setEnabled(false);
            return;
        }
        this.javaProject = this.getJavaProject(this.shapeNodeEP.resolveSemanticElement());
        if (this.javaProject == null) {
            action.setEnabled(false);
            return;
        }
    }

    private IJavaProject getJavaProject(EObject eo) {
        IProject p;
        block5: {
            IResource r;
            block4: {
                String path = eo.eResource().getURI().toPlatformString(false);
                path = path.replaceFirst("platform:/resource", "");
                try {
                    r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (r != null && r instanceof IFile) break block4;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            p = r.getProject();
            if (p.hasNature("org.eclipse.jdt.core.javanature")) break block5;
            return null;
        }
        return JavaCore.create((IProject)p);
    }

    private boolean canExecute(EObject eo) {
        if (eo == null) {
            return false;
        }
        BaseService service = null;
        BaseReference reference = null;
        if (eo instanceof BaseService) {
            service = (BaseService)eo;
        } else if (eo instanceof BaseReference) {
            reference = (BaseReference)eo;
        } else {
            return false;
        }
        if (service == null && reference == null) {
            return false;
        }
        if (service == null && reference != null && reference.getInterface() != null) {
            return false;
        }
        return service == null || reference != null || service.getInterface() == null;
    }
}

