/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.formeditor.pages.includes;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stp.sca.common.jdt.utils.DomUtils;
import org.eclipse.stp.sca.formeditor.Messages;
import org.eclipse.stp.sca.formeditor.ScaFormEditor;
import org.eclipse.stp.sca.formeditor.explorer.ScaResourceExplorer;
import org.eclipse.stp.sca.formeditor.pages.AbstractPage;
import org.eclipse.stp.sca.formeditor.pages.includes.IncludeBean;
import org.eclipse.stp.sca.formeditor.pages.includes.IncludeBeanLabelProvider;
import org.eclipse.stp.sca.formeditor.pages.includes.IncludesDetails;
import org.eclipse.stp.sca.formeditor.ui.ScaCustomSwt;
import org.eclipse.stp.sca.formeditor.ui.TableViewerControl;
import org.eclipse.stp.sca.xmleditor.utils.IncludesUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludesMaster
extends MasterDetailsBlock {
    private AbstractPage page;
    private final List<IncludeBean> alreadyIncluded = new ArrayList<IncludeBean>();
    private TableViewerControl includesControl;
    private IncludesUtils includesUtils;

    public IncludesMaster(AbstractPage page) {
        this.page = page;
        IFile editedFile = ((ScaFormEditor)page.getEditor()).getEditedFile();
        IProject project = editedFile.getProject();
        this.includesUtils = IncludesUtils.createIncludesUtils((IProject)project);
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginTop = 10;
        container.setLayout((Layout)layout);
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(container, toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.IncludesMaster_0);
        section.setDescription(Messages.IncludesMaster_1);
        section.descriptionVerticalSpacing = 10;
        section.setLayoutData((Object)new GridData(1808));
        section.setLayout((Layout)new GridLayout());
        Composite part = sac.getComposite();
        part.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        part.setLayout((Layout)layout);
        this.includesControl = new TableViewerControl(part, toolkit, false, true);
        this.includesControl.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.includesControl.setLabelProvider(new IncludeBeanLabelProvider());
        SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.includesControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.updateIncludesList();
        this.includesControl.setInput(this.alreadyIncluded.toArray());
        this.includesControl.getRemove().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                IStructuredSelection selection = (IStructuredSelection)IncludesMaster.this.includesControl.getViewerSelection();
                if (!selection.isEmpty() && (o = selection.getFirstElement()) instanceof IncludeBean) {
                    Node node = ((IncludeBean)o).getNode();
                    IncludesMaster.this.page.removeElement((Element)node);
                }
            }
        });
        this.includesControl.getAdd().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QName qName;
                IncludesMaster.this.updateIncludesList();
                IFile editedFile = ((ScaFormEditor)IncludesMaster.this.page.getEditor()).getEditedFile();
                IProject project = editedFile.getProject();
                ScaResourceExplorer dlg = new ScaResourceExplorer(IncludesMaster.this.page.getSite().getShell(), project);
                dlg.setFilter(ScaResourceExplorer.SCA_COMPOSITES);
                dlg.setExpandAll(true);
                List<IResource> resourcesToHide = IncludesMaster.this.getIncludedFiles();
                resourcesToHide.add((IResource)editedFile);
                dlg.setResourcesToHide(resourcesToHide);
                if (dlg.open() == 0 && (qName = dlg.getResultAsQName()) != null) {
                    IncludesMaster.this.page.startTransaction();
                    Element includeElement = IncludesMaster.this.page.addElement("include", "http://www.osoa.org/xmlns/sca/1.0");
                    IncludesMaster.this.page.addOrSetAttribute(includeElement, "name", qName.toString());
                    IncludesMaster.this.page.stopTransaction();
                }
                IncludesMaster.this.update();
            }
        });
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.registerPage(IncludeBean.class, (IDetailsPage)new IncludesDetails(this.includesUtils));
    }

    public void updateIncludesList() {
        List possibleInclusions = this.includesUtils.getIFiles();
        ArrayList<IncludeBean> includeBeans = new ArrayList<IncludeBean>(possibleInclusions.size());
        IFile editedFile = ((ScaFormEditor)this.page.getEditor()).getEditedFile();
        for (IFile file : possibleInclusions) {
            QName qName = this.includesUtils.getQName(file);
            if (file.equals((Object)editedFile)) continue;
            long stamp = file.getModificationStamp();
            includeBeans.add(new IncludeBean(file, qName, stamp));
        }
        this.alreadyIncluded.clear();
        NodeList includeNodes = this.page.getDocument().getElementsByTagNameNS("*", "include");
        int i = 0;
        while (i < includeNodes.getLength()) {
            NamedNodeMap attributes = includeNodes.item(i).getAttributes();
            String includeName = null;
            int j = 0;
            while (j < attributes.getLength()) {
                Node nameNode = attributes.item(j);
                if (nameNode.getNodeName().equalsIgnoreCase("name")) {
                    includeName = nameNode.getNodeValue();
                    break;
                }
                ++j;
            }
            if (includeName == null) {
                IncludeBean bean = new IncludeBean(null, null, -1L);
                bean.setNode(includeNodes.item(i));
                this.alreadyIncluded.add(bean);
            } else {
                String nsUri = "";
                String localPart = "";
                Pattern namespacePattern = Pattern.compile("\\{.+\\}");
                Matcher m = namespacePattern.matcher(includeName);
                if (m.find()) {
                    nsUri = includeName.substring(m.start() + 1, m.end() - 1);
                    int namespaceEndPosition = includeName.lastIndexOf("}");
                    localPart = includeName.substring(namespaceEndPosition + 1);
                } else {
                    String[] parts = includeName.split(":");
                    if (parts.length == 1) {
                        localPart = includeName;
                        nsUri = includeNodes.item(i).getNamespaceURI();
                    } else {
                        localPart = parts[1];
                        nsUri = DomUtils.lookupNamespaceURI((String)parts[0], (Node)includeNodes.item(i));
                    }
                }
                QName qName = new QName(nsUri, localPart);
                IncludeBean associatedBean = this.lookupIncludeBean(qName, includeBeans);
                if (associatedBean == null) {
                    associatedBean = new IncludeBean(null, qName, -1L);
                }
                associatedBean.setNode(includeNodes.item(i));
                this.alreadyIncluded.add(associatedBean);
            }
            ++i;
        }
        includeBeans.removeAll(this.alreadyIncluded);
    }

    public void update() {
        this.updateIncludesList();
        if (!this.includesControl.isDisposed()) {
            this.includesControl.setInput(this.alreadyIncluded.toArray());
            this.includesControl.refreshViewer();
        }
    }

    private IncludeBean lookupIncludeBean(QName qName, List<IncludeBean> includeBeans) {
        for (IncludeBean bean : includeBeans) {
            if (!bean.getQName().equals(qName)) continue;
            return bean;
        }
        return null;
    }

    protected List<IResource> getIncludedFiles() {
        ArrayList<IResource> includedFiles = new ArrayList<IResource>();
        for (IncludeBean bean : this.alreadyIncluded) {
            includedFiles.add((IResource)bean.getFile());
        }
        return includedFiles;
    }

    static /* synthetic */ TableViewerControl access$0(IncludesMaster includesMaster) {
        return includesMaster.includesControl;
    }

    static /* synthetic */ AbstractPage access$1(IncludesMaster includesMaster) {
        return includesMaster.page;
    }
}

