/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.stp.sca.ontology.view.OntologyViewPlugin;
import org.eclipse.stp.sca.ontology.view.search.OntologySearchResult;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OntologyToolTip
extends ToolTip {
    private String[] keywords = new String[0];

    public OntologyToolTip(Control control) {
        super(control);
        this.setPopupDelay(200);
    }

    public Point getLocation(Point tipSize, Event event) {
        int x = event.x - tipSize.x - 10;
        int y = event.y + 3;
        return ((Control)event.widget).toDisplay(x, y);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        TreeItem item;
        OntologySearchResult bean = null;
        if (event.widget instanceof Tree && (item = ((Tree)event.widget).getItem(new Point(event.x, event.y))).getData() != null && item.getData() instanceof OntologySearchResult) {
            bean = (OntologySearchResult)item.getData();
        }
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        FormColors colors = toolkit.getColors();
        Color top = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        Form form = toolkit.createForm(parent);
        form.setText(bean != null ? bean.getName() : "");
        form.setTextBackground(new Color[]{top, bot}, new int[]{100}, true);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        form.getBody().setLayout((Layout)layout);
        FormText formImage = toolkit.createFormText(form.getBody(), false);
        formImage.setText("<form><p><img href=\"image\"/> " + (bean != null ? bean.getName() : "") + "</p></form>", true, false);
        Image image = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/ontology.gif").createImage();
        formImage.setImage("image", image);
        GridData td = new GridData();
        td.horizontalSpan = 2;
        td.verticalIndent = 10;
        formImage.setLayoutData((Object)td);
        FormText text = toolkit.createFormText(form.getBody(), true);
        String desc = bean != null ? bean.getDescription() : "";
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            Matcher m = Pattern.compile(keyword, 2).matcher(desc);
            while (m.find()) {
                desc = String.valueOf(desc.substring(0, m.start())) + "<b>" + m.group() + "</b>" + desc.substring(m.end());
            }
            ++n2;
        }
        text.setText("<form><p>" + desc + "</p></form>", true, false);
        td = new GridData();
        td.horizontalSpan = 2;
        td.verticalIndent = 10;
        td.widthHint = 200;
        text.setLayoutData((Object)td);
        return parent;
    }

    public void updateKeywordsToHighlight(String query) {
        this.keywords = query.split("(\\s)+");
    }
}

