/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.validation.jbiBinding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.sca.BaseReference;
import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.domainmodel.frascati.JBIBinding;
import org.eclipse.stp.sca.validation.Messages;

public class JbiBindingAttributesAndModeValidation
extends AbstractModelConstraint {
    private String check(JBIBinding jbiBinding) {
        EObject container = jbiBinding.eContainer();
        String suffix = "";
        if (container.eContainer() instanceof Component) {
            suffix = String.valueOf(((Component)container.eContainer()).getName()) + "/";
        }
        if (container instanceof BaseService) {
            String location = String.valueOf(Messages.JbiBindingAttributesAndModeValidation_3) + suffix + ((BaseService)container).getName() + "'.";
            return this.checkInProvide(jbiBinding, location);
        }
        if (container instanceof BaseReference) {
            String location = String.valueOf(Messages.JbiBindingAttributesAndModeValidation_5) + suffix + ((BaseReference)container).getName() + "'.";
            return this.checkInConsume(jbiBinding, location);
        }
        return null;
    }

    private String checkInConsume(JBIBinding jbiBinding, String location) {
        boolean serviceIsEmpty = this.isEmpty(jbiBinding.getServiceName());
        boolean serviceNsIsEmpty = this.isEmpty(jbiBinding.getServiceNamespace());
        boolean endpointIsEmpty = this.isEmpty(jbiBinding.getEndpointName());
        if (serviceIsEmpty && !serviceNsIsEmpty) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_7) + location;
        }
        if (!serviceIsEmpty && serviceNsIsEmpty) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_8) + location;
        }
        if (serviceIsEmpty && !endpointIsEmpty) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_9) + location;
        }
        if (!serviceIsEmpty && endpointIsEmpty) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_10) + location;
        }
        return null;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private String checkInProvide(JBIBinding jbiBinding, String location) {
        if (this.isEmpty(jbiBinding.getServiceName())) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_7) + location;
        }
        if (this.isEmpty(jbiBinding.getServiceNamespace())) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_8) + location;
        }
        if (this.isEmpty(jbiBinding.getEndpointName())) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_13) + location;
        }
        if (this.isEmpty(jbiBinding.getWsdl())) {
            return String.valueOf(Messages.JbiBindingAttributesAndModeValidation_14) + location;
        }
        return null;
    }

    public IStatus validate(IValidationContext ctx) {
        String errorMsg;
        EObject objectToCheck = ctx.getTarget();
        EMFEventType typeEvenement = ctx.getEventType();
        if (typeEvenement == EMFEventType.NULL && objectToCheck instanceof JBIBinding && (errorMsg = this.check((JBIBinding)objectToCheck)) != null) {
            return ctx.createFailureStatus(new Object[]{errorMsg});
        }
        return ctx.createSuccessStatus();
    }
}

