/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlContextualDom {
    private Document doc;
    private Node lastNode;
    private PositionStatus status = PositionStatus.OTHER;
    private Attr lastAttr;
    private boolean rightAfterOpeningMarkUp = false;
    private String endOfAttributeValue;
    private int offset;

    public PositionStatus getStatus() {
        return this.status;
    }

    public String getEndOfAttributeValue() {
        return this.endOfAttributeValue;
    }

    public Document getDoc() {
        return this.doc;
    }

    public Node getLastNode() {
        return this.lastNode;
    }

    public Attr getLastAttr() {
        return this.lastAttr;
    }

    public boolean isRightAfterOpeningMarkUp() {
        return this.rightAfterOpeningMarkUp;
    }

    public XmlContextualDom(int offset, String xmlString) {
        this.offset = offset;
        this.parseViewerUntilOffset(offset, xmlString);
    }

    public XmlContextualDom(int offset, ITextViewer viewer) {
        this.offset = offset;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        String xmlString = viewer.getDocument().get();
        this.parseViewerUntilOffset(offset, xmlString);
    }

    private void parseViewerUntilOffset(int offset, String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.doc.setXmlVersion("1.0");
            this.doc.setXmlStandalone(true);
            int index = 0;
            Document currentNode = this.doc;
            while (index < offset) {
                NodeAndOffset nao = this.readMarkup(xmlString, index, currentNode);
                index = nao.index;
                Node node = currentNode = nao.node != null ? nao.node : currentNode;
                if (index - 1 >= offset || xmlString.charAt(index - 1) != '>') continue;
                this.status = PositionStatus.ELEMENT_VALUE;
            }
            this.lastNode = currentNode;
        }
        catch (Exception e) {
            this.status = PositionStatus.CORRUPTED;
        }
    }

    private NodeAndOffset readMarkup(String xmlString, int index, Node currentNode) throws SAXException {
        this.status = PositionStatus.ELEMENT_VALUE;
        char c = xmlString.charAt(index);
        while (Character.isWhitespace(c) && index < this.offset) {
            c = xmlString.charAt(++index);
        }
        if (index >= this.offset) {
            return new NodeAndOffset(index, currentNode);
        }
        if (c != '<') {
            String value = "";
            while (index < this.offset && c != '<') {
                value = String.valueOf(value) + c;
                c = xmlString.charAt(++index);
            }
            currentNode.setNodeValue(value.trim());
            return new NodeAndOffset(index, currentNode);
        }
        if (++index >= this.offset) {
            this.status = PositionStatus.ELEMENT_NAME;
            this.rightAfterOpeningMarkUp = true;
            return new NodeAndOffset(index);
        }
        c = xmlString.charAt(index);
        switch (c) {
            case '/': {
                return this.readEndingMarkup(xmlString, index, currentNode);
            }
            case '?': {
                return this.readPIMarkup(xmlString, index, currentNode);
            }
            case '!': {
                return this.readCommentOrCDataMarkup(xmlString, index, currentNode);
            }
        }
        return this.readEffectiveMarkup(xmlString, index, currentNode);
    }

    /*
     * Unable to fully structure code
     */
    private NodeAndOffset readCommentOrCDataMarkup(String xmlString, int index, Node currentNode) throws SAXException {
        this.status = PositionStatus.OTHER;
        if (++index >= this.offset) {
            return new NodeAndOffset(index);
        }
        c = xmlString.charAt(index);
        if (++index >= this.offset) {
            return new NodeAndOffset(index);
        }
        c2 = xmlString.charAt(index);
        if (c != c2 || c2 != '-' && c2 != '[') {
            throw new SAXException("Found an invalid sequence of symbols \"<!" + c + c2 + "\" (position = " + index + ").");
        }
        patternFound = false;
        ** GOTO lbl19
        {
            ++index;
            do {
                if (index < this.offset && (c = xmlString.charAt(index)) != c2) continue block0;
                if (++index >= this.offset) {
                    return new NodeAndOffset(index);
                }
                if (c2 != xmlString.charAt(index)) continue;
                patternFound = true;
lbl19:
                // 3 sources

            } while (!patternFound && index < this.offset);
        }
        if (++index >= this.offset) {
            return new NodeAndOffset(index);
        }
        if (xmlString.charAt(index) != '>') {
            throw new SAXException("Found a '" + c2 + c2 + "' sequence not followed by '>' (position = " + index + ").");
        }
        return new NodeAndOffset(index + 1);
    }

    private NodeAndOffset readPIMarkup(String xmlString, int index, Node currentNode) throws SAXException {
        this.status = PositionStatus.OTHER;
        ++index;
        while (index < this.offset && xmlString.charAt(index) != '?') {
            ++index;
        }
        if (++index >= this.offset) {
            return new NodeAndOffset(index);
        }
        if (xmlString.charAt(index) == '>') {
            return new NodeAndOffset(index + 1);
        }
        throw new SAXException("Found a '?' symbol in a processing instruction and not followed by '>' (position =" + index + ").");
    }

    /*
     * Unable to fully structure code
     */
    private NodeAndOffset readEndingMarkup(String xmlString, int index, Node currentNode) {
        this.status = PositionStatus.INSIDE_MARK_UP;
        c = 32;
        ++index;
        if (true) ** GOTO lbl7
        do {
            ++index;
lbl7:
            // 2 sources

            if (index >= this.offset) break;
            v0 = xmlString.charAt(index);
            c = v0;
        } while (v0 != '>');
        if (c == 62) {
            this.status = PositionStatus.OTHER;
        }
        return new NodeAndOffset(index + 1, currentNode.getParentNode());
    }

    /*
     * Unable to fully structure code
     */
    private NodeAndOffset readEffectiveMarkup(String xmlString, int index, Node currentNode) throws SAXException {
        block24: {
            elementName = "";
            c = '\n';
            while (index < this.offset && Character.isWhitespace(xmlString.charAt(index))) {
                ++index;
            }
            break block24;
            while (true) {
                elementName = String.valueOf(elementName) + xmlString.charAt(index);
                ++index;
                break;
            }
        }
        if (index < this.offset) {
            v0 = xmlString.charAt(index);
            c = v0;
            if (v0 != '/' && c != '>' && !Character.isWhitespace(c)) ** continue;
        }
        offsetInEndOfMarkup = this.offset - index;
        endOfMarkup = "";
        isSngleMarkupBeforeOffset = false;
        isInAttrValue = false;
        while (index < xmlString.length()) {
            if ((c = xmlString.charAt(index++)) == '\'' || c == '\"') {
                v1 = isInAttrValue = isInAttrValue == false;
            }
            if (c == '>' || c == '<' && !isInAttrValue) {
                if (!endOfMarkup.endsWith("/")) break;
                endOfMarkup = endOfMarkup.substring(0, endOfMarkup.length() - 1);
                isSngleMarkupBeforeOffset = index - 1 < this.offset;
                break;
            }
            endOfMarkup = String.valueOf(endOfMarkup) + c;
        }
        offsetSides = new String[]{};
        offsetSides = offsetInEndOfMarkup > 0 && endOfMarkup.length() >= offsetInEndOfMarkup ? new String[]{endOfMarkup.substring(0, offsetInEndOfMarkup), endOfMarkup.substring(offsetInEndOfMarkup)} : new String[]{endOfMarkup};
        if (offsetSides.length == 2 && Character.isWhitespace(ch = offsetSides[0].charAt(offsetSides[0].length() - 1))) {
            offsetSides[1] = String.valueOf(ch) + offsetSides[1];
        }
        attrPattern = Pattern.compile("(\\s){1}([\\w:])*(\\s)*=(\\s)*['\"]([^'\"])*['\"]", 8);
        attributes = new LinkedHashMap<String, String>();
        i = 0;
        while (i < offsetSides.length) {
            matcher = attrPattern.matcher(offsetSides[i]);
            while (matcher.find()) {
                attrPart = matcher.group();
                offsetSides[i] = offsetSides[i].replace(attrPart, "");
                attrParts = attrPart.split("=");
                key = attrParts[0].trim();
                attrValue = attrParts[1].trim();
                attrValue = attrValue.substring(1, attrValue.length() - 1);
                attributes.put(key, attrValue);
            }
            ++i;
        }
        if (offsetSides[0].trim().length() == 0) {
            attributes.put("", "");
            this.status = PositionStatus.ATTRIBUTE_NAME;
        } else {
            parts = offsetSides[0].split("=");
            if (parts.length == 1) {
                lastChar = parts[0].charAt(parts[0].length() - 1);
                this.status = Character.isWhitespace(lastChar) != false ? PositionStatus.INSIDE_MARK_UP : PositionStatus.ATTRIBUTE_NAME;
                if (Character.isWhitespace(parts[0].charAt(0))) {
                    attributes.put(parts[0].trim(), "");
                }
            } else if (parts.length == 2) {
                value = parts[1].trim();
                value = value.length() > 0 ? value.substring(1) : value;
                this.status = parts[1].matches("(\\s)*['\"]([^'\"]*)") != false ? PositionStatus.ATTRIBUTE_VALUE : PositionStatus.INSIDE_MARK_UP;
                if (Character.isWhitespace(parts[0].charAt(0))) {
                    attributes.put(parts[0].trim(), value);
                }
            } else {
                throw new SAXException(Messages.XmlContextualDom_0);
            }
        }
        if (offsetSides.length == 2 && this.status == PositionStatus.ATTRIBUTE_VALUE) {
            this.endOfAttributeValue = offsetSides[1].trim();
            this.endOfAttributeValue = this.endOfAttributeValue.substring(0, this.endOfAttributeValue.length() - 1);
        }
        if (this.lastAttr != null && this.lastAttr.getName().startsWith("xmlns")) {
            if (this.status == PositionStatus.ATTRIBUTE_NAME) {
                this.status = PositionStatus.NS_DECLARATION;
            } else if (this.status == PositionStatus.ATTRIBUTE_VALUE) {
                this.status = PositionStatus.NS_URI;
            }
        }
        elt = this.createElement(currentNode, elementName, attributes);
        if (offsetInEndOfMarkup <= 0) {
            this.status = PositionStatus.ELEMENT_NAME;
        }
        if (isSngleMarkupBeforeOffset) {
            return new NodeAndOffset(index, currentNode);
        }
        return new NodeAndOffset(index, elt);
    }

    private Element createElement(Node parentNode, String elementName, Map<String, String> attributes) throws SAXException {
        Element elt;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (String key : attributes.keySet()) {
            if (!key.startsWith("xmlns")) continue;
            String prefix = key.length() > 5 ? key.substring(6) : key.substring(5);
            namespaces.put(prefix, attributes.get(key));
        }
        ArrayList<Attr> attributeNodes = new ArrayList<Attr>();
        Iterator<String> it = attributes.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Attr attr = null;
            if (key.startsWith("xmlns")) {
                attr = this.doc.createAttributeNS("http://www.w3.org/2000/xmlns/", key);
                if (!it.hasNext() && this.status == PositionStatus.ATTRIBUTE_NAME) {
                    this.status = PositionStatus.NS_DECLARATION;
                } else if (!it.hasNext() && this.status == PositionStatus.ATTRIBUTE_VALUE) {
                    this.status = PositionStatus.NS_URI;
                }
            } else if (key.length() > 0) {
                String[] parts = key.split(":");
                if (parts.length == 2) {
                    String uri = this.resolveNamespaceUri(parentNode, parts[0], namespaces);
                    attr = this.doc.createAttributeNS(uri, key);
                } else {
                    attr = this.doc.createAttribute(key);
                }
            }
            this.lastAttr = attr;
            if (attr == null) continue;
            attr.setNodeValue(attributes.get(key));
            attributeNodes.add(attr);
        }
        String[] parts = elementName.split(":");
        if (parts.length == 2) {
            String uri = this.resolveNamespaceUri(parentNode, parts[0], namespaces);
            elt = this.doc.createElementNS(uri, elementName);
        } else {
            elt = this.doc.createElement(elementName);
        }
        parentNode.appendChild(elt);
        for (Attr attr : attributeNodes) {
            elt.setAttributeNode(attr);
        }
        return elt;
    }

    private String resolveNamespaceUri(Node parentNode, String nsPrefix, Map<String, String> namespaces) throws SAXException {
        String uri;
        String string = uri = namespaces != null ? namespaces.get(nsPrefix) : null;
        if (uri == null && parentNode != null && this.doc.getDocumentElement() != null) {
            uri = parentNode.lookupNamespaceURI(nsPrefix);
        }
        if (uri == null) {
            throw new SAXException("Unresolved namespace prefix '" + nsPrefix + "' in " + parentNode.toString() + ".");
        }
        return uri;
    }

    public String toString() {
        String result = "\n";
        result = String.valueOf(result) + "Status: " + this.status.toString() + "\n";
        if (this.lastNode != null) {
            result = String.valueOf(result) + "Last Node: " + this.lastNode.toString() + "\nAttrs";
            int i = 0;
            while (i < this.lastNode.getAttributes().getLength()) {
                result = String.valueOf(result) + "\n\t" + this.lastNode.getAttributes().item(i).toString();
                ++i;
            }
        } else {
            result = String.valueOf(result) + "Last Node: null";
        }
        if (this.status == PositionStatus.ATTRIBUTE_NAME || this.status == PositionStatus.ATTRIBUTE_VALUE || this.status == PositionStatus.NS_DECLARATION || this.status == PositionStatus.NS_URI) {
            result = String.valueOf(result) + "\nLast Attribute: " + (this.lastAttr == null ? "null" : this.lastAttr.toString());
        }
        if (this.status == PositionStatus.ATTRIBUTE_VALUE || this.status == PositionStatus.NS_URI) {
            result = String.valueOf(result) + "\nAttribute Value after the offset: " + this.endOfAttributeValue;
        }
        return result;
    }

    public String printDocument() {
        String result = "\nDOM:\n-----\n";
        try {
            DOMSource domSource = new DOMSource(this.doc);
            StringWriter writer = new StringWriter();
            StreamResult sr = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(domSource, sr);
            result = String.valueOf(result) + writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private class NodeAndOffset {
        private Node node;
        private int index;

        public NodeAndOffset(int index, Node node) {
            this.index = index;
            this.node = node;
        }

        public NodeAndOffset(int index) {
            this.index = index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PositionStatus {
        ELEMENT_NAME,
        ELEMENT_VALUE,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE,
        NS_DECLARATION,
        NS_URI,
        INSIDE_MARK_UP,
        CORRUPTED,
        OTHER;

    }
}

