/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.stp.sca.xmleditor.completion.XmlContextualDom;
import org.eclipse.stp.sca.xmleditor.utils.IncludesUtils;
import org.eclipse.stp.sca.xmleditor.utils.ResourceExplorer;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtttributeValueProposalMaker {
    private IFile editedFile;
    private IncludesUtils includesUtils;
    private Map<String, String> generatedIncludeNs = new HashMap<String, String>();
    private XmlContextualDom contextualDom;

    public AtttributeValueProposalMaker() {
        this.initializeInclusionElements();
    }

    private void initializeInclusionElements() {
        this.editedFile = ResourceExplorer.getIFileFromEditor();
        IProject project = this.editedFile.getProject();
        this.includesUtils = IncludesUtils.createIncludesUtils(project);
    }

    public ICompletionProposal[] makeProposals(Document domDoc, XmlContextualDom contextualDom, String markupName, String attributeName, String attributeValue, int offset) {
        this.contextualDom = contextualDom;
        try {
            if (markupName.equalsIgnoreCase("service")) {
                return this.provideServiceMarkupProposals(domDoc, offset, attributeName, attributeValue);
            }
            if (markupName.equalsIgnoreCase("reference")) {
                return this.provideReferenceMarkupProposals(domDoc, offset, attributeName, attributeValue);
            }
            if (markupName.equalsIgnoreCase("wire")) {
                return this.provideWireMarkupProposals(domDoc, offset, attributeName, attributeValue);
            }
            if (markupName.equalsIgnoreCase("include")) {
                return this.provideIncludesMarkupProposals(domDoc, offset, attributeName, attributeValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ICompletionProposal[] provideWireMarkupProposals(Document domDoc, int offset, String attributeName, String attributeValue) {
        if (attributeName.equalsIgnoreCase("source")) {
            String[] referenceNames = ScaUtils.getPromotions(domDoc, false);
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            String[] stringArray = referenceNames;
            int n = referenceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String referenceName = stringArray[n2];
                if (referenceName.startsWith(attributeValue)) {
                    String s = this.contextualDom.getEndOfAttributeValue();
                    int replacementLength = attributeValue.length() + (s == null ? 0 : s.length());
                    result.add(new CompletionProposal(referenceName, offset - attributeValue.length(), replacementLength, referenceName.length()));
                }
                ++n2;
            }
            ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
            return result.toArray(proposals);
        }
        if (attributeName.equalsIgnoreCase("target")) {
            String[] serviceNames = ScaUtils.getPromotions(domDoc, true);
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            String[] stringArray = serviceNames;
            int n = serviceNames.length;
            int n3 = 0;
            while (n3 < n) {
                String serviceName = stringArray[n3];
                if (serviceName.startsWith(attributeValue)) {
                    String s = this.contextualDom.getEndOfAttributeValue();
                    int replacementLength = attributeValue.length() + (s == null ? 0 : s.length());
                    result.add(new CompletionProposal(serviceName, offset - attributeValue.length(), replacementLength, serviceName.length()));
                }
                ++n3;
            }
            ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
            return result.toArray(proposals);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] provideReferenceMarkupProposals(Document domDoc, int offset, String attributeName, String attributeValue) {
        String[] referenceNames = attributeName.equalsIgnoreCase("promote") ? ScaUtils.getPromotions(domDoc, false) : (attributeName.equalsIgnoreCase("target") ? ScaUtils.getPromotions(domDoc, true) : new String[]{});
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        String[] stringArray = referenceNames;
        int n = referenceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceName = stringArray[n2];
            if (referenceName.startsWith(attributeValue)) {
                String s = this.contextualDom.getEndOfAttributeValue();
                int replacementLength = attributeValue.length() + (s == null ? 0 : s.length());
                result.add(new CompletionProposal(referenceName, offset - attributeValue.length(), replacementLength, referenceName.length()));
            }
            ++n2;
        }
        ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
        return result.toArray(proposals);
    }

    private ICompletionProposal[] provideServiceMarkupProposals(Document domDoc, int offset, String attributeName, String attributeValue) {
        String[] serviceNames = attributeName.equalsIgnoreCase("promote") ? ScaUtils.getPromotions(domDoc, true) : new String[]{};
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        String[] stringArray = serviceNames;
        int n = serviceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceName = stringArray[n2];
            if (serviceName.startsWith(attributeValue)) {
                String s = this.contextualDom.getEndOfAttributeValue();
                int replacementLength = attributeValue.length() + (s == null ? 0 : s.length());
                result.add(new CompletionProposal(serviceName, offset - attributeValue.length(), replacementLength, serviceName.length()));
            }
            ++n2;
        }
        ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
        return result.toArray(proposals);
    }

    private List<QName> getIncludedFiles(Document domDoc) {
        ArrayList<QName> includeQNames = new ArrayList<QName>();
        NodeList includes = domDoc.getElementsByTagNameNS("*", "include");
        int i = 0;
        while (i < includes.getLength()) {
            QName includeQName = ScaUtils.getIncludeQName(includes.item(i));
            if (includeQName != null) {
                includeQNames.add(includeQName);
            }
            ++i;
        }
        return includeQNames;
    }

    private ICompletionProposal[] provideIncludesMarkupProposals(Document domDoc, int offset, String attributeName, String attributeValue) {
        try {
            this.initializeInclusionElements();
            List<QName> qNames = this.includesUtils.getQNames();
            List<QName> alreadyIncluded = this.getIncludedFiles(domDoc);
            QName currentQName = this.includesUtils.getQName(this.editedFile);
            if (currentQName != null) {
                alreadyIncluded.add(currentQName);
            }
            ArrayList<QName> toPropose = new ArrayList<QName>(qNames);
            toPropose.removeAll(alreadyIncluded);
            ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
            for (QName qName : toPropose) {
                String s;
                String nsUri = qName.getNamespaceURI();
                String nsPrefix = this.contextualDom.getLastNode().lookupPrefix(nsUri);
                if (nsPrefix == null && (nsPrefix = this.generatedIncludeNs.get(nsUri)) == null) {
                    int num = this.generatedIncludeNs.size();
                    nsPrefix = "include" + num;
                    s = this.contextualDom.getEndOfAttributeValue();
                    String currentNs = String.valueOf(attributeValue) + (s != null ? s : "");
                    boolean nsAlreadyExisting = true;
                    while (nsAlreadyExisting) {
                        if (this.contextualDom.getLastNode().lookupNamespaceURI(nsPrefix) != null) {
                            String associatedUri = this.contextualDom.getLastNode().lookupNamespaceURI(nsPrefix);
                            if (nsUri.equals(associatedUri)) continue;
                            nsPrefix = "include" + ++num;
                            continue;
                        }
                        if (currentNs.startsWith(nsPrefix)) {
                            nsPrefix = "include" + ++num;
                            continue;
                        }
                        nsAlreadyExisting = false;
                    }
                    this.generatedIncludeNs.put(nsUri, nsPrefix);
                }
                String proposal = nsPrefix.length() == 0 ? qName.getLocalPart() : (this.generatedIncludeNs.containsKey(nsUri) ? String.valueOf(nsPrefix) + ":" + qName.getLocalPart() + "\" xmlns:" + nsPrefix + "=\"" + qName.getNamespaceURI() : String.valueOf(nsPrefix) + ":" + qName.getLocalPart());
                if (!qName.getLocalPart().startsWith(attributeValue) && !nsPrefix.startsWith(attributeValue)) continue;
                s = this.contextualDom.getEndOfAttributeValue();
                int replacementLength = attributeValue.length() + (s == null ? 0 : s.length());
                proposals.add(new CompletionProposal(proposal, offset - attributeValue.length(), replacementLength, proposal.length(), null, qName.getLocalPart(), null, "<b>{" + qName.getNamespaceURI() + "}</b> " + qName.getLocalPart()));
            }
            ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
            return proposals.toArray(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ICompletionProposal[0];
        }
    }
}

