/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlItem;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlPlatform
extends ScaXmlItem
implements Externalizable {
    public final Set<ScaXmlNamespace> namespaces = new HashSet<ScaXmlNamespace>();
    public final List<ScaXmlElement> bindings = new ArrayList<ScaXmlElement>();
    public final List<ScaXmlElement> implementations = new ArrayList<ScaXmlElement>();
    public final List<ScaXmlElement> interfaces = new ArrayList<ScaXmlElement>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToBindings = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToImplementations = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToInterfaces = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();

    public ScaXmlPlatform() {
    }

    public ScaXmlPlatform(String name) {
        this.name = name;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.namespaces.addAll((Set)in.readObject());
        for (ScaXmlNamespace ns : this.namespaces) {
            ns.setPlatform(this);
        }
        this.bindings.addAll((List)in.readObject());
        for (ScaXmlElement elt : this.bindings) {
            elt.setPlatform(this);
        }
        this.implementations.addAll((List)in.readObject());
        for (ScaXmlElement elt : this.implementations) {
            elt.setPlatform(this);
        }
        this.interfaces.addAll((List)in.readObject());
        for (ScaXmlElement elt : this.interfaces) {
            elt.setPlatform(this);
        }
        Map bindMapIds = (Map)in.readObject();
        this.nsToBindings.putAll(this.getMappingToElements(bindMapIds, ScaXmlElementType.bindings));
        Map implMapIds = (Map)in.readObject();
        this.nsToImplementations.putAll(this.getMappingToElements(implMapIds, ScaXmlElementType.implementations));
        Map interfMapIds = (Map)in.readObject();
        this.nsToInterfaces.putAll(this.getMappingToElements(interfMapIds, ScaXmlElementType.interfaces));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.namespaces);
        out.writeObject(this.bindings);
        out.writeObject(this.implementations);
        out.writeObject(this.interfaces);
        Map<ScaXmlNamespace, List<Integer>> bindMapIds = this.getMappingToIds(this.nsToBindings);
        out.writeObject(bindMapIds);
        Map<ScaXmlNamespace, List<Integer>> implMapIds = this.getMappingToIds(this.nsToImplementations);
        out.writeObject(implMapIds);
        Map<ScaXmlNamespace, List<Integer>> interfMapIds = this.getMappingToIds(this.nsToInterfaces);
        out.writeObject(interfMapIds);
    }

    private Map<ScaXmlNamespace, List<Integer>> getMappingToIds(Map<ScaXmlNamespace, List<ScaXmlElement>> association) {
        HashMap<ScaXmlNamespace, List<Integer>> nsToElementIds = new HashMap<ScaXmlNamespace, List<Integer>>();
        for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : association.entrySet()) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (ScaXmlElement elt : entry.getValue()) {
                ids.add(elt.getId());
            }
            nsToElementIds.put(entry.getKey(), ids);
        }
        return nsToElementIds;
    }

    private Map<ScaXmlNamespace, List<ScaXmlElement>> getMappingToElements(Map<ScaXmlNamespace, List<Integer>> association, ScaXmlElementType type) {
        HashMap<ScaXmlNamespace, List<ScaXmlElement>> nsToElements = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();
        List<ScaXmlElement> elementList = type == ScaXmlElementType.bindings ? this.bindings : (type == ScaXmlElementType.implementations ? this.implementations : this.interfaces);
        HashMap<Integer, ScaXmlElement> idsToElements = new HashMap<Integer, ScaXmlElement>();
        for (ScaXmlElement scaXmlElement : elementList) {
            idsToElements.put(scaXmlElement.getId(), scaXmlElement);
        }
        for (Map.Entry entry : association.entrySet()) {
            ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
            for (Integer eltId : (List)entry.getValue()) {
                ScaXmlElement elt = (ScaXmlElement)idsToElements.get(eltId);
                if (elt == null) continue;
                elements.add(elt);
            }
            nsToElements.put((ScaXmlNamespace)entry.getKey(), elements);
        }
        return nsToElements;
    }

    public void remove(ScaXmlItem element) {
        this.bindings.remove(element);
        this.implementations.remove(element);
        this.interfaces.remove(element);
        for (List<ScaXmlElement> set : this.nsToBindings.values()) {
            set.remove(element);
        }
        for (List<ScaXmlElement> set : this.nsToImplementations.values()) {
            set.remove(element);
        }
        for (List<ScaXmlElement> set : this.nsToInterfaces.values()) {
            set.remove(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaXmlElementType {
        bindings,
        implementations,
        interfaces;

    }
}

