/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ElementEditionDialog
extends Dialog {
    private ScaXmlElement newElement;
    private ScaXmlElement parent;
    private Text nameText;
    private Spinner minSpinner;
    private Spinner maxSpinner;
    private Button unboundedButton;
    private Label errorLabel;

    public ElementEditionDialog(Shell parentShell, ScaXmlPlatform.ScaXmlElementType elementType, ScaXmlElement parent) {
        super(parentShell);
        this.parent = parent;
        String type = elementType.toString();
        if (type != null && type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(NLS.bind((String)Messages.ElementEditionDialog_1, (Object)this.parent.getName()));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 20;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText(Messages.ElementEditionDialog_2);
        this.nameText = new Text(container, 2052);
        if (this.newElement != null && this.newElement.getName() != null) {
            this.nameText.setText(this.newElement.getName());
        } else {
            this.nameText.setText(Messages.ElementEditionDialog_3);
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ElementEditionDialog.this.validate();
            }
        });
        new Label(container, 0).setText(Messages.ElementEditionDialog_4);
        this.minSpinner = new Spinner(container, 2048);
        this.minSpinner.setMinimum(0);
        if (this.newElement != null) {
            this.minSpinner.setSelection(this.newElement.getMinOccurs());
        }
        GridData spinnerLayoutData = new GridData();
        spinnerLayoutData.widthHint = 60;
        this.minSpinner.setLayoutData((Object)spinnerLayoutData);
        this.minSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementEditionDialog.this.validate();
            }
        });
        new Label(container, 0).setText(Messages.ElementEditionDialog_5);
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.maxSpinner = new Spinner(buttonContainer, 2048);
        this.maxSpinner.setMinimum(1);
        if (this.newElement != null) {
            this.maxSpinner.setSelection(this.newElement.getMaxOccurs());
        } else {
            this.maxSpinner.setSelection(1);
        }
        spinnerLayoutData = new GridData();
        spinnerLayoutData.widthHint = 60;
        this.maxSpinner.setLayoutData((Object)spinnerLayoutData);
        this.maxSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementEditionDialog.this.validate();
            }
        });
        this.unboundedButton = new Button(buttonContainer, 32);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 10;
        layoutData.verticalIndent = 2;
        this.unboundedButton.setLayoutData((Object)layoutData);
        new Label(buttonContainer, 0).setText(Messages.ElementEditionDialog_6);
        if (this.newElement != null) {
            this.unboundedButton.setSelection(this.newElement.isUnbounded());
            if (this.newElement.isUnbounded()) {
                this.maxSpinner.setEnabled(false);
            }
        }
        this.unboundedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ElementEditionDialog.this.unboundedButton.getSelection()) {
                    ElementEditionDialog.this.maxSpinner.setEnabled(false);
                } else {
                    ElementEditionDialog.this.maxSpinner.setEnabled(true);
                }
            }
        });
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 10;
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setLayoutData((Object)layoutData);
        this.nameText.setFocus();
        this.nameText.setSelection(this.nameText.getText().length());
        return container;
    }

    protected Point getInitialSize() {
        return new Point(400, 200);
    }

    protected void okPressed() {
        if (this.newElement != null) {
            this.newElement.setName(this.nameText.getText());
        } else {
            this.newElement = new ScaXmlElement(this.nameText.getText(), this.parent);
        }
        this.newElement.setMinOccurs(this.minSpinner.getSelection());
        this.newElement.setMaxOccurs(this.maxSpinner.getSelection());
        this.newElement.setUnbounded(this.unboundedButton.getSelection());
        super.okPressed();
    }

    public ScaXmlElement getNewElement() {
        return this.newElement;
    }

    public void setNewElement(ScaXmlElement newElement) {
        this.newElement = newElement;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void validate() {
        int maxValue;
        ScaXmlElement elt2;
        String name = this.nameText.getText();
        if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            this.updateStatus(Messages.ElementEditionDialog_7);
            return;
        }
        for (ScaXmlElement elt2 : this.parent.children) {
            if (!elt2.getName().equals(name) || this.newElement != null && elt2.getId() == this.newElement.getId()) continue;
            this.updateStatus(Messages.ElementEditionDialog_8);
            return;
        }
        elt2 = this.parent;
        while (elt2 != null) {
            if (elt2.getName().equals(name)) {
                this.updateStatus(Messages.ElementEditionDialog_9);
                return;
            }
            elt2 = elt2.getParent();
        }
        if (name.equalsIgnoreCase("service") || name.equals("reference") || name.equals("component") || name.equals("composite")) {
            this.updateStatus(NLS.bind((String)Messages.ElementEditionDialog_14, (Object)name));
            return;
        }
        int minValue = this.minSpinner.getSelection();
        if (minValue > (maxValue = this.maxSpinner.getSelection())) {
            this.updateStatus(Messages.ElementEditionDialog_16);
            return;
        }
        this.updateStatus(null);
    }

    public void updateStatus(String msg) {
        if (msg != null) {
            this.errorLabel.setText(msg);
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(false);
        } else {
            this.errorLabel.setText("");
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(true);
        }
    }

    static /* synthetic */ Button access$0(ElementEditionDialog elementEditionDialog) {
        return elementEditionDialog.unboundedButton;
    }

    static /* synthetic */ Spinner access$1(ElementEditionDialog elementEditionDialog) {
        return elementEditionDialog.maxSpinner;
    }
}

