/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stp.sca.xmleditor.utils.ResourceExplorer;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.eclipse.stp.sca.xmleditor.utils.filters.SkippedResources;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludesUtils {
    private static SAXBuilder builder = new SAXBuilder();
    private static DOMOutputter format = new DOMOutputter();
    private List<IProject> projects = new ArrayList<IProject>();

    protected IncludesUtils(IProject project) {
        this.projects.add(project);
        try {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject ref = iProjectArray[n2];
                this.projects.add(ref);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IncludesUtils createIncludesUtils(IProject project) {
        if (project != null) {
            return new IncludesUtils(project);
        }
        return null;
    }

    public QName getQName(IFile file) {
        String namespaceUri;
        String compositeName;
        block3: {
            org.w3c.dom.Document document = this.getDOM(file);
            try {
                Node compositeNode = ScaUtils.getScaTopNode(document);
                compositeName = ScaUtils.getAttributeValue(compositeNode, "name");
                namespaceUri = ScaUtils.getAttributeValue(compositeNode, "targetNamespace");
                if (!"".equals(namespaceUri)) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new QName(namespaceUri, compositeName);
    }

    public List<QName> getQNames(IFile[] files) {
        ArrayList<QName> result = new ArrayList<QName>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            QName qName = this.getQName(file);
            if (qName != null) {
                result.add(qName);
            }
            ++n2;
        }
        return result;
    }

    public List<QName> getQNames(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getQNames(files.toArray(iFiles));
    }

    public List<QName> getQNames() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            List<IFile> pIFiles = ResourceExplorer.getFiles(project, "composite");
            pIFiles = SkippedResources.filterAllowedFiles(pIFiles);
            iFiles.addAll(pIFiles);
        }
        return this.getQNames(iFiles);
    }

    public IFile getIFile(QName qName) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            List<IFile> pIFiles = ResourceExplorer.getFiles(project, "composite");
            pIFiles = SkippedResources.filterAllowedFiles(pIFiles);
            files.addAll(pIFiles);
        }
        for (IFile file : files) {
            QName fileQName = this.getQName(file);
            try {
                if (fileQName == null || !qName.equals(fileQName)) continue;
                return file;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<IFile> getIFiles(QName[] qNames) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        QName[] qNameArray = qNames;
        int n = qNames.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            IFile file = this.getIFile(name);
            if (file != null) {
                result.add(file);
            }
            ++n2;
        }
        return result;
    }

    public List<IFile> getIFiles(List<QName> qNames) {
        QName[] names = new QName[qNames.size()];
        return this.getIFiles(qNames.toArray(names));
    }

    public List<IFile> getIFiles() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            List<IFile> pIFiles = ResourceExplorer.getFiles(project, "composite");
            pIFiles = SkippedResources.filterAllowedFiles(pIFiles);
            iFiles.addAll(pIFiles);
        }
        return iFiles;
    }

    public org.w3c.dom.Document getDOM(IFile file) {
        try {
            IPath fullPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(file.getFullPath());
            File inputFile = new File(fullPath.toString());
            Document jDomDocument = builder.build(inputFile);
            return format.output(jDomDocument);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<org.w3c.dom.Document> getDOMs(IFile[] files) {
        ArrayList<org.w3c.dom.Document> result = new ArrayList<org.w3c.dom.Document>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            org.w3c.dom.Document document = this.getDOM(file);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<org.w3c.dom.Document> getDOMs(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getDOMs(files.toArray(iFiles));
    }

    public List<org.w3c.dom.Document> getDOMs() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            List<IFile> pIFiles = ResourceExplorer.getFiles(project, "composite");
            pIFiles = SkippedResources.filterAllowedFiles(pIFiles);
            iFiles.addAll(pIFiles);
        }
        return this.getDOMs(iFiles);
    }

    public org.w3c.dom.Document getDOMbyQName(QName name) {
        IFile file = this.getIFile(name);
        if (file != null) {
            return this.getDOM(file);
        }
        return null;
    }

    public List<org.w3c.dom.Document> getDOMsByQName(QName[] names) {
        ArrayList<org.w3c.dom.Document> result = new ArrayList<org.w3c.dom.Document>();
        QName[] qNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            org.w3c.dom.Document document = this.getDOMbyQName(name);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<org.w3c.dom.Document> getDOMsByQName(List<QName> names) {
        QName[] qNames = new QName[names.size()];
        return this.getDOMsByQName(names.toArray(qNames));
    }

    public static IFile getIncludedFile(Object node, IProject project) {
        if (!ScaUtils.isIncludeNode(node)) {
            return null;
        }
        QName qName = ScaUtils.getIncludeQName((Node)node);
        if (qName == null) {
            return null;
        }
        IncludesUtils includesUtils = new IncludesUtils(project);
        return includesUtils.getIFile(qName);
    }
}

