/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils.filters;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectUtils {
    public static IJavaProject getJavaProject(IProject iProject) {
        try {
            if (iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)iProject);
                return javaProject;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Set<IFolder> getBinaryFolders(IJavaProject javaProject) {
        TreeSet<IFolder> binaryFolders = new TreeSet<IFolder>();
        try {
            IFolder folder;
            IPath outputPath = javaProject.getOutputLocation();
            if (outputPath != null && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                binaryFolders.add(folder);
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder2;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (outputPath = entry.getOutputLocation()) != null && (folder2 = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                    binaryFolders.add(folder2);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return binaryFolders;
    }

    public static boolean isBinaryFolder(IFolder folder) {
        IProject iProject = folder.getProject();
        IJavaProject javaProject = JavaProjectUtils.getJavaProject(iProject);
        if (javaProject == null) {
            return false;
        }
        Set<IFolder> binaryFolders = JavaProjectUtils.getBinaryFolders(javaProject);
        return binaryFolders.contains(folder);
    }
}

