/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.eclipse.stp.ui.xef.schema.AbstractAnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.ui.xef.schema.SchemaValueComponent;
import org.eclipse.stp.ui.xef.schema.SchemaValueType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaAttribute
extends AbstractAnnotatedElement
implements AnnotatedElement,
SchemaValueComponent {
    private final XSAttributeDeclaration ctx;
    private String defaultValue;
    private String exampleValue;
    private String fixed;
    private boolean required;
    private String filterId;
    private String fieldEditorId;
    private String units;
    private String pattern;
    private String contextValueID;
    private String contextDataID;
    private String contextXPath;

    SchemaAttribute(XSAttributeDeclaration attrDeclaration) {
        this.ctx = attrDeclaration;
        this.handleAnnotations(attrDeclaration.getAnnotation());
    }

    Document handleAnnotations(XSAnnotation annotation) {
        Document domDoc = super.handleAnnotations(annotation);
        if (domDoc == null) {
            return null;
        }
        this.setExample(SchemaAttribute.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "example")));
        this.setFilterId(SchemaAttribute.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "filter")));
        this.setFieldEditorId(SchemaAttribute.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "fieldEditor")));
        this.setPattern(SchemaAttribute.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "pattern")));
        this.setUnits(SchemaAttribute.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "units")));
        NodeList contextElems = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "context");
        if (contextElems.getLength() > 0 && contextElems.item(0) instanceof Element) {
            String contextXPath;
            String contextType = SchemaAttribute.getTextValue(((Element)contextElems.item(0)).getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "values"));
            if (contextType != null) {
                this.setContextValueID(contextType);
            }
            if ((contextXPath = SchemaAttribute.getTextValue(((Element)contextElems.item(0)).getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "dependency"))) != null) {
                this.setContextXPath(contextXPath);
            }
        }
        return domDoc;
    }

    public String getName() {
        return this.ctx.getName();
    }

    public String getContextValueID() {
        return this.contextValueID;
    }

    public void setContextValueID(String id) {
        this.contextValueID = id;
    }

    public String getContextXPath() {
        return this.contextXPath;
    }

    public void setContextXPath(String xpath) {
        this.contextXPath = xpath;
    }

    public String getContextDataID() {
        return this.contextDataID;
    }

    public void setContextDataID(String id) {
        this.contextDataID = id;
    }

    public String getDisplayName() {
        String dn = super.getDisplayName();
        if (dn == null) {
            return this.getName();
        }
        return dn;
    }

    public SchemaValueType getValueType() {
        return new SchemaValueType(this.ctx.getTypeDefinition());
    }

    public String getFixed() {
        return this.fixed;
    }

    void setFixed(String f) {
        this.fixed = f;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    void setDefault(String def) {
        this.defaultValue = def;
    }

    public String getExample() {
        return this.exampleValue;
    }

    void setExample(String ex) {
        this.exampleValue = ex;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String p) {
        this.pattern = p;
    }

    public String[] getContextValues(IContextProvider ctx, String filter) {
        return ctx.getValues(this.contextValueID, filter);
    }

    public Object getContextData(IContextProvider ctx) {
        return ctx.getData(this.contextDataID);
    }

    public String getFilterId() {
        return this.filterId;
    }

    void setFilterId(String fid) {
        this.filterId = fid;
    }

    public String getFieldEditorId() {
        return this.fieldEditorId;
    }

    void setFieldEditorId(String fid) {
        this.fieldEditorId = fid;
    }

    public boolean getRequired() {
        return this.required;
    }

    void setRequired(boolean r) {
        this.required = r;
    }

    public String getUnits() {
        return this.units;
    }

    void setUnits(String u) {
        this.units = u;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaAttribute)) {
            return false;
        }
        SchemaAttribute attr = (SchemaAttribute)obj;
        return this.ctx.equals(attr.ctx);
    }

    public int hashCode() {
        return this.ctx.hashCode();
    }

    public String toString() {
        return String.valueOf(this.ctx.getNamespace()) + ":" + this.ctx.getName();
    }
}

