/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.MultiXMLProvider;
import org.eclipse.stp.xef.ReadOnlyXMLInstanceElement;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLModelFactory {
    private static SAXBuilder builder = new SAXBuilder();
    public static boolean interactive = true;

    private XMLModelFactory() {
    }

    public static List<XMLInstanceElement> getXMLInstanceElements(ISchemaProvider schemaProvider, boolean cacheSchemas, String baseElQName, IFile file) {
        String extension = file.getFileExtension();
        if (extension != null && extension.equals("policy")) {
            InputStream is = null;
            try {
                is = file.getContents(false);
                LinkedList<XMLInstanceElement> elements = new LinkedList<XMLInstanceElement>();
                XMLModelFactory.createFromXML(is, baseElQName, elements, cacheSchemas, schemaProvider);
                LinkedList<XMLInstanceElement> linkedList = elements;
                return linkedList;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                InputStreamHelper.close((InputStream)is);
            }
        }
        return null;
    }

    public static List<XMLInstanceElement> getXMLInstanceElements(ISchemaProvider schemaProvider, boolean cacheSchemas, IXMLProvider ... xmlProviders) throws JDOMException, IOException {
        if (xmlProviders.length == 1) {
            LinkedList<XMLInstanceElement> elements = new LinkedList<XMLInstanceElement>();
            XMLModelFactory.createFromXML(xmlProviders[0].getXML(), xmlProviders[0].getRootElementQName(), elements, cacheSchemas, schemaProvider);
            return elements;
        }
        MultiXMLProvider multiProvider = new MultiXMLProvider(Arrays.asList(xmlProviders));
        LinkedList<XMLInstanceElement> elements = new LinkedList<XMLInstanceElement>();
        XMLModelFactory.createFromXML(multiProvider.getXML(), multiProvider.getRootElementQName(), elements, cacheSchemas, schemaProvider);
        return elements;
    }

    public static synchronized Element createFromXML(String xml, String baseElQName, List<XMLInstanceElement> elements, boolean cacheSchemas, ISchemaProvider ... providers) throws JDOMException, IOException {
        if (xml != null && xml.length() > 0) {
            return XMLModelFactory.createFromXML(new ByteArrayInputStream(xml.getBytes()), baseElQName, elements, cacheSchemas, providers);
        }
        return null;
    }

    private static synchronized Element createFromXML(InputStream xmlIS, String baseElQName, List<XMLInstanceElement> newPolicies, boolean cacheSchemas, ISchemaProvider ... providers) throws JDOMException, IOException {
        Document doc;
        Element root;
        QName rootQName;
        QName qname = QName.valueOf(baseElQName);
        Element baseEl = qname.equals(rootQName = new QName((root = (doc = builder.build(xmlIS)).getRootElement()).getNamespaceURI(), root.getName())) ? root : root.getChild(qname.getLocalPart(), Namespace.getNamespace((String)qname.getNamespaceURI()));
        if (baseEl == null) {
            String errMsg = "The edited document does not conform to the expected format. Expected an element with qname: " + baseElQName;
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No matching document found", (String)errMsg);
            Exception ex = new Exception(String.valueOf(errMsg) + System.getProperty("line.separator") + "Actual document: " + new XMLOutputter(Format.getPrettyFormat()).outputString(doc));
            Status status = new Status(4, "org.eclipse.stp.xef", 0, errMsg, (Throwable)ex);
            XefPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        for (Element policy : baseEl.getChildren()) {
            SchemaElement schema = SchemaRegistry.getDefault().getSchemaElement(policy.getNamespaceURI(), policy.getName(), cacheSchemas, providers);
            if (schema != null) {
                XMLInstanceElement pi = "http://www.w3.org/ns/ws-policy".equals(schema.getNameSpace()) ? new ReadOnlyXMLInstanceElement(schema, null, policy) : new XMLInstanceElement(schema, null, policy);
                newPolicies.add(pi);
                XMLModelFactory.initNestedElements(policy, pi, providers);
                continue;
            }
            String message = "Could not find a schema for the policy " + new QName(policy.getNamespaceURI(), policy.getName()).toString() + "." + "\n\nRemoved this policy from the policy document.";
            if (interactive) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No schema found for template", (String)message);
                continue;
            }
            throw new IOException(message);
        }
        Element newBase = new Element(baseEl.getName(), baseEl.getNamespacePrefix(), baseEl.getNamespaceURI());
        for (Namespace namespace : baseEl.getAdditionalNamespaces()) {
            newBase.addNamespaceDeclaration(namespace);
        }
        return newBase;
    }

    private static void initNestedElements(Element policyXML, XMLInstanceElement pi, ISchemaProvider ... providers) {
        String basedOn = XMLInstanceElement.findBasedOn(policyXML);
        if (basedOn != null) {
            pi.setBasedOnSnippet(basedOn);
        }
        ArrayList<Element> detachedElements = new ArrayList<Element>(policyXML.getChildren().size());
        for (Element child : new ArrayList(policyXML.getChildren())) {
            detachedElements.add((Element)child.detach());
        }
        if (pi.getTemplate() != null && pi.getTemplate().isSequenceOfAny()) {
            pi.setEmbeddedElements(detachedElements);
        } else {
            for (Element child : detachedElements) {
                boolean readonly;
                SchemaElement schema = null;
                if (pi.getTemplate() != null) {
                    schema = pi.getTemplate().getNestedElement(child.getName());
                }
                boolean bl = readonly = schema == null;
                if (pi instanceof ReadOnlyXMLInstanceElement) {
                    readonly = true;
                }
                if (schema == null) {
                    schema = SchemaRegistry.getDefault().getSchemaElement(child.getNamespaceURI(), child.getName(), true, providers);
                }
                XMLInstanceElement piChild = readonly ? new ReadOnlyXMLInstanceElement(schema, pi, child) : new XMLInstanceElement(schema, pi, child);
                pi.addChild(piChild, false);
                XMLModelFactory.initNestedElements(child, piChild, providers);
            }
        }
    }
}

