/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.stp.bpmn.diagram.ui.RoundedSchemeBorder;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;

public class SubProcessFigure
extends RoundedRectangle
implements HandleBounds {
    private boolean _isLoop;
    private boolean _isTransaction;

    public SubProcessFigure() {
        this.setBorder((Border)new RoundedSchemeBorder());
    }

    public boolean isLoop() {
        return this._isLoop;
    }

    public void setIsLoop(boolean isLoop) {
        this._isLoop = isLoop;
    }

    public boolean isTransaction() {
        return this._isTransaction;
    }

    public void setIsTransaction(boolean isTransaction) {
        this._isTransaction = isTransaction;
    }

    public Rectangle getHandleBounds() {
        Rectangle r = this.getBounds().getCopy().crop(this.getBorder().getInsets((IFigure)this));
        if (this.getParent() != null && this.getParent().getParent() != null) {
            int borderHeight = 0;
            for (Object child : this.getChildren()) {
                if (!(child instanceof SubProcessBorderFigure)) continue;
                borderHeight = ((SubProcessBorderFigure)((Object)child)).getBorderHeight();
                break;
            }
            if (borderHeight != 0) {
                r.height = r.height - borderHeight + 15;
            }
        }
        return r;
    }

    protected void fillShape(Graphics graphics) {
        graphics.fillRoundRectangle(this.getHandleBounds(), this.corner.width, this.corner.height);
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle f = Rectangle.SINGLETON;
        Rectangle r = this.getHandleBounds();
        f.x = r.x + this.lineWidth / 2;
        f.y = r.y + this.lineWidth / 2;
        f.width = r.width - this.lineWidth;
        f.height = r.height - this.lineWidth;
        graphics.drawRoundRectangle(f, this.corner.width, this.corner.height);
    }

    public void paint(Graphics graphics) {
        if (this.getLocalBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getLocalBackgroundColor());
        }
        if (this.getLocalForegroundColor() != null) {
            graphics.setForegroundColor(this.getLocalForegroundColor());
        }
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        graphics.pushState();
        try {
            this.paintBorder(graphics);
            this.paintFigure(graphics);
            graphics.restoreState();
            this.paintClientArea(graphics);
        }
        finally {
            graphics.popState();
        }
    }
}

