/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.swt.graphics.Cursor;

public class GroupDragTracker
extends DragEditPartsTrackerEx {
    public GroupDragTracker(IGraphicalEditPart sourceEditPart) {
        super((EditPart)sourceEditPart);
    }

    private BpmnDiagramEditPart getDiagramEditPart(IGraphicalEditPart part) {
        if (part instanceof BpmnDiagramEditPart) {
            return (BpmnDiagramEditPart)part;
        }
        if (part == null) {
            throw new IllegalArgumentException("Invalid hierarchy");
        }
        return this.getDiagramEditPart((IGraphicalEditPart)part.getParent());
    }

    protected boolean updateTargetUnderMouse() {
        boolean updated = super.updateTargetUnderMouse();
        EditPart targetEP = super.getTargetEditPart();
        if ((GraphicalEditPart)targetEP != null && targetEP == this.getSourceEditPart().getParent()) {
            Rectangle target = ((GraphicalEditPart)targetEP).getFigure().getBounds().getCopy();
            Rectangle source = ((GraphicalEditPart)this.getSourceEditPart()).getFigure().getBounds().getCopy();
            Point loc = this.getLocation().getCopy();
            Viewport vp = ((ScalableFreeformRootEditPart)((GraphicalEditPart)this.getSourceEditPart()).getViewer().getRootEditPart()).getZoomManager().getViewport();
            source.setLocation(loc);
            vp.translateToAbsolute((Translatable)source);
            if (!target.contains(source)) {
                this.setTargetEditPart((EditPart)this.getDiagramEditPart((IGraphicalEditPart)super.getTargetEditPart()));
                updated = true;
            }
        }
        return updated;
    }

    protected Cursor calculateCursor() {
        Command command = this.getCurrentCommand();
        if (command == null || !command.canExecute()) {
            return this.getDisabledCursor();
        }
        if (this.isInState(4) || this.isInState(32)) {
            if (this.isMove()) {
                return SharedCursors.HAND;
            }
            return SharedCursors.CURSOR_TREE_MOVE;
        }
        return super.calculateCursor();
    }
}

