/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMHelper {
    private static final Logger LOG = Logger.getLogger(DOMHelper.class);

    public static QName resolveReferenceQName(Element context, String colonizedName) {
        QName portTypeQName = null;
        String prefix = null;
        String ncName = null;
        int index = colonizedName.indexOf(58);
        if (-1 == index) {
            ncName = colonizedName;
            prefix = "";
        } else {
            prefix = colonizedName.substring(0, index);
            if (index != colonizedName.length()) {
                ncName = colonizedName.substring(index + 1);
            }
        }
        String nsURI = DOMHelper.resolvePrefix(context, prefix);
        if (nsURI != null) {
            portTypeQName = new QName(nsURI, ncName);
        } else {
            LOG.warn((Object)("Unable to resolve [" + prefix + "] prefix to URI"));
        }
        return portTypeQName;
    }

    public static void reloadPrefixesForNode(Element context, Map prefixMap) {
        NamedNodeMap attribs = context.getAttributes();
        int nAttribs = attribs.getLength();
        int i = 0;
        while (i < nAttribs) {
            String stringValue = attribs.item(i).getNodeName();
            String prefixValue = stringValue.startsWith("xmlns:") ? stringValue.substring("xmlns:".length()) : (stringValue.compareTo("xmlns") == 0 ? "" : null);
            if (prefixValue != null && prefixMap.get(prefixValue) == null) {
                String ns = attribs.item(i).getNodeValue();
                prefixMap.put(prefixValue, ns);
            }
            ++i;
        }
    }

    public static String resolveNamespace(Element context, String uri) {
        String prefix = null;
        Element actualContext = context;
        while (actualContext != null && prefix == null) {
            NamedNodeMap attribs = context.getAttributes();
            int nAttribs = attribs.getLength();
            HashMap prefixMap = new HashMap(nAttribs);
            DOMHelper.reloadPrefixesForNode(context, prefixMap);
            for (Map.Entry objEntry : prefixMap.entrySet()) {
                String objUri = (String)objEntry.getValue();
                if (objUri.compareTo(uri) != 0) continue;
                prefix = (String)objEntry.getKey();
            }
            if (prefix != null) continue;
            Node parentNode = actualContext.getParentNode();
            if (parentNode.getNodeType() == 1) {
                actualContext = (Element)parentNode;
                prefix = DOMHelper.resolvePrefix(actualContext, prefix);
                continue;
            }
            actualContext = null;
        }
        return prefix;
    }

    public static String resolvePrefix(Element context, String prefix) {
        String ns = null;
        Element actualContext = context;
        while (actualContext != null && ns == null) {
            NamedNodeMap attribs = context.getAttributes();
            int nAttribs = attribs.getLength();
            HashMap prefixMap = new HashMap(nAttribs);
            DOMHelper.reloadPrefixesForNode(context, prefixMap);
            ns = (String)prefixMap.get(prefix);
            if (ns != null) continue;
            Node parentNode = actualContext.getParentNode();
            if (parentNode.getNodeType() == 1) {
                actualContext = (Element)parentNode;
                ns = DOMHelper.resolvePrefix(actualContext, prefix);
                continue;
            }
            actualContext = null;
        }
        return ns;
    }
}

