/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.core.impl.service.DOMHelper;
import org.eclipse.stp.common.validator.core.impl.service.InlineSchemaHelper;
import org.eclipse.stp.common.validator.core.impl.service.MessageHelper;
import org.eclipse.stp.common.validator.core.impl.service.XPathHelper;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericValidator
implements IValidator {
    private static final Logger LOG = Logger.getLogger(GenericValidator.class);
    private static final String PARTNER_LINK_ROLE_NAME_SERVICE = "service";
    private static final String PARTNER_LINK_ROLE_NAME_CALLBACK = "callback";
    private static final String PARTNER_LINK_XPATH = "/wsdl:definitions/plnk:partnerLinkType";
    private static final String SETTING_PROP_FILE = "/sop.validation.properties";
    private static final String PROP_INLINE_VALIDATION_NAME = "org.eclipse.stp.common.validator.core.impl.service.GenericValidator.InlineSchema";
    private boolean propInlineValidation = true;
    private MessageHelper messageHelper = new MessageHelper();
    private InlineSchemaHelper schemaHelper = null;

    public void validateSPDX(QName inputSourceID, Document inputDoc, IReporter pReporter) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", false);
            Definition def = reader.readWSDL(null, inputDoc);
            Map servicesMap = def.getServices();
            for (Service serviceObj : servicesMap.values()) {
                if (serviceObj == null) continue;
                Map portsMap = serviceObj.getPorts();
                for (Port portObj : portsMap.values()) {
                    Binding bindingObj;
                    if (portObj == null || (bindingObj = portObj.getBinding()) != null && !bindingObj.isUndefined()) continue;
                    if (bindingObj != null) {
                        this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_PORT_WRONG_BINDING_REFERENCE, pReporter, new String[]{portObj.getName(), bindingObj.getQName().getNamespaceURI(), bindingObj.getQName().getLocalPart()}, inputSourceID);
                        continue;
                    }
                    this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_PORT_WRONG_BINDING_REFERENCE, pReporter, new String[]{portObj.getName(), "", ""}, inputSourceID);
                }
            }
        }
        catch (WSDLException e) {
            this.messageHelper.reportError(MessageTypeEnum.OTHER_ERROR, pReporter, new String[]{"Unable to load the document model as WSDL document: " + e.getMessage()}, (Object)e);
        }
    }

    private Element getPartnerLinkElement(Document inputDoc) {
        Element partnerLinkElement = null;
        Node node = XPathHelper.getXPathResultNode(inputDoc.getDocumentElement(), PARTNER_LINK_XPATH);
        if (node != null && node instanceof Element) {
            partnerLinkElement = (Element)node;
        }
        return partnerLinkElement;
    }

    private void validatePartnerPortTypes(QName inputSourceID, QName portTypeCallbackQName, PortType servicePortType, Document inputDoc, IReporter pReporter) {
        String callbackPortType = portTypeCallbackQName.getLocalPart();
        Element callbackElement = null;
        callbackElement = (Element)XPathHelper.getXPathResultNode(inputDoc.getDocumentElement(), "/wsdl:definitions/wsdl:portType[@name = '" + callbackPortType + "']");
        NodeList nodes = null;
        nodes = XPathHelper.getXPathResultList(callbackElement, "./wsdl:operation[not(@sdx:partnerOperation)]");
        int i = 0;
        while (i < nodes.getLength()) {
            Element opElem = (Element)nodes.item(i);
            String opName = opElem.getAttribute("name");
            this.messageHelper.reportWarning(MessageTypeEnum.PARTNER_LINK_GENERIC_PARTNER_OP_NOT_SPECIFIED, pReporter, new String[]{opName, callbackPortType}, inputSourceID);
            ++i;
        }
        nodes = XPathHelper.getXPathResultList(callbackElement, "./wsdl:operation/@sdx:partnerOperation");
        HashSet<String> partnersSet = new HashSet<String>();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Attr opAttr = (Attr)nodes.item(i2);
            partnersSet.add(opAttr.getValue());
            ++i2;
        }
        LOG.debug((Object)("callback portType [" + callbackPortType + "] references [" + partnersSet + "] partner operations"));
        String servicePortName = servicePortType.getQName().getLocalPart();
        for (String name : partnersSet) {
            Operation partnerOpObj = servicePortType.getOperation(name, null, null);
            if (partnerOpObj == null) {
                this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_PARTNER_OP_NON_EXISTING, pReporter, new String[]{callbackPortType, name, servicePortName}, inputSourceID);
                continue;
            }
            if (partnerOpObj.getInput() != null && partnerOpObj.getOutput() == null && partnerOpObj.getFaults().size() == 0) continue;
            this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_PARTNER_OP_NOT_ONEWAY, pReporter, new String[]{callbackPortType, name, servicePortName}, inputSourceID);
        }
        nodes = XPathHelper.getXPathResultList(callbackElement, "./wsdl:operation[@sdx:faultOperation]/@sdx:partnerOperation");
        HashSet<String> faultPartnersSet = new HashSet<String>();
        int i3 = 0;
        while (i3 < nodes.getLength()) {
            Attr opAttr = (Attr)nodes.item(i3);
            if (!faultPartnersSet.contains(opAttr.getValue())) {
                faultPartnersSet.add(opAttr.getValue());
            } else {
                this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_DUP_FAULTS, pReporter, new String[]{callbackPortType, opAttr.getValue()}, inputSourceID);
            }
            ++i3;
        }
    }

    private boolean validatePartnerLinkReferences(QName inputSourceID, QName portTypeServiceQName, QName portTypeCallbackQName, Definition def, IReporter pReporter) {
        boolean hasNoErrors = true;
        Map portTypes = def.getPortTypes();
        if (portTypes.get(portTypeServiceQName) != null) {
            LOG.debug((Object)"The service port type object found");
        } else {
            LOG.error((Object)("The service port type object [" + portTypeServiceQName + "] not found"));
            this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_WRONG_PORT_TYPE_REFERENCE, pReporter, new String[]{PARTNER_LINK_ROLE_NAME_SERVICE, portTypeServiceQName.toString()}, inputSourceID);
            hasNoErrors = false;
        }
        if (portTypes.get(portTypeCallbackQName) != null) {
            LOG.debug((Object)"The callback port type object found");
        } else {
            LOG.error((Object)("The callback port type object [" + portTypeCallbackQName + "] not found"));
            this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_WRONG_PORT_TYPE_REFERENCE, pReporter, new String[]{PARTNER_LINK_ROLE_NAME_CALLBACK, portTypeCallbackQName.toString()}, inputSourceID);
            hasNoErrors = false;
        }
        if (portTypeServiceQName.equals(portTypeCallbackQName)) {
            LOG.error((Object)"The same Port Type cannot be user in both 'service' and 'callback roles'");
            this.messageHelper.reportError(MessageTypeEnum.PARTNER_LINK_GENERIC_SAME_PORT_TYPE_REFERENCE, pReporter, new String[]{portTypeCallbackQName.toString()}, inputSourceID);
            hasNoErrors = false;
        }
        return hasNoErrors;
    }

    private void validatePartnerLink(QName inputSourceID, Document inputDoc, Definition def, IReporter pReporter) throws SOPValidationException {
        QName portTypeServiceQName = null;
        QName portTypeCallbackQName = null;
        Element partnerLinkElem = null;
        try {
            partnerLinkElem = this.getPartnerLinkElement(inputDoc);
            if (partnerLinkElem != null) {
                Element serviceElem = null;
                Element callbackElem = null;
                serviceElem = (Element)XPathHelper.getXPathResultNode(partnerLinkElem, "./plnk:role[@name = 'service']/plnk:portType");
                callbackElem = (Element)XPathHelper.getXPathResultNode(partnerLinkElem, "./plnk:role[@name = 'callback']/plnk:portType");
                String portTypeService = serviceElem.getAttribute("name");
                String portTypeCallback = callbackElem.getAttribute("name");
                LOG.debug((Object)("Service Port Type = [" + portTypeService + "]"));
                LOG.debug((Object)("Callback Port Type = [" + portTypeCallback + "]"));
                portTypeServiceQName = DOMHelper.resolveReferenceQName(serviceElem, portTypeService);
                portTypeCallbackQName = DOMHelper.resolveReferenceQName(callbackElem, portTypeCallback);
                LOG.debug((Object)("QName Service Port Type: [" + portTypeServiceQName + "]"));
                LOG.debug((Object)("QName Callback Port Type: [" + portTypeCallbackQName + "]"));
                if (portTypeServiceQName != null && portTypeCallbackQName != null) {
                    if (this.validatePartnerLinkReferences(inputSourceID, portTypeServiceQName, portTypeCallbackQName, def, pReporter)) {
                        PortType servicePortType = def.getPortType(portTypeServiceQName);
                        this.validatePartnerPortTypes(inputSourceID, portTypeCallbackQName, servicePortType, inputDoc, pReporter);
                    }
                } else {
                    LOG.error((Object)"Unable to resolve QName's of Port Types referenced by Partner Link");
                }
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Unexpected problem during Partner Link Validation: " + e.getMessage()), e);
        }
    }

    public void validateInlineSchema(QName inputSourceID, Definition def, IReporter pReporter) {
        LOG.debug((Object)"Validating Inline-Schema");
        if (!this.schemaHelper.preparseInlineGrammars()) {
            for (String err : this.schemaHelper.getErrorsList()) {
                this.messageHelper.reportError(MessageTypeEnum.INLINE_SCHEMA_ERROR, pReporter, new String[]{err}, inputSourceID);
            }
        }
    }

    public void validateSDX(IValidationObject valObj, IReporter pReporter) throws SOPValidationException {
        block18: {
            QName inputSourceID = valObj.getID().getQName();
            try {
                Document inputDoc = valObj.getInput();
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", true);
                reader.setFeature("javax.wsdl.importDocuments", false);
                Definition def = reader.readWSDL(null, inputDoc);
                LOG.debug((Object)"The WSDL Definition reloaded");
                this.schemaHelper = new InlineSchemaHelper(inputDoc, valObj.getID().getURI());
                if (this.propInlineValidation) {
                    this.validateInlineSchema(inputSourceID, def, pReporter);
                }
                this.validatePartnerLink(inputSourceID, inputDoc, def, pReporter);
                LOG.debug((Object)"Checking port types declared in SDX");
                Map portTypes = def.getPortTypes();
                if (portTypes != null && portTypes.size() != 0) {
                    for (PortType portTypeObj : portTypes.values()) {
                        if (portTypeObj != null && !portTypeObj.isUndefined()) {
                            LOG.debug((Object)("Processing [" + portTypeObj.getQName() + "] port type"));
                            List operationsList = portTypeObj.getOperations();
                            for (Operation opObj : operationsList) {
                                if (opObj != null && !opObj.isUndefined()) {
                                    LOG.debug((Object)("Processing [" + opObj.getName() + "] operation"));
                                    Input objInput = opObj.getInput();
                                    Output objOutput = opObj.getOutput();
                                    Map mapFaults = opObj.getFaults();
                                    Message objMsg = null;
                                    if (objInput != null && (objMsg = objInput.getMessage()) != null && objMsg.isUndefined()) {
                                        this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_WRONG_MESSAGE_REFERENCE, pReporter, new String[]{"input", opObj.getName(), objMsg.getQName().toString()}, inputSourceID);
                                    }
                                    if (objOutput != null && (objMsg = objOutput.getMessage()) != null && objMsg.isUndefined()) {
                                        this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_WRONG_MESSAGE_REFERENCE, pReporter, new String[]{"output", opObj.getName(), objMsg.getQName().toString()}, inputSourceID);
                                    }
                                    if (mapFaults == null) continue;
                                    for (Fault objFault : mapFaults.values()) {
                                        if (objFault == null || (objMsg = objFault.getMessage()) == null || !objMsg.isUndefined()) continue;
                                        this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_FAULT_WRONG_MESSAGE_REFERENCE, pReporter, new String[]{objFault.getName(), opObj.getName(), objMsg.getQName().toString()}, inputSourceID);
                                    }
                                    continue;
                                }
                                LOG.warn((Object)("Undefined operation encoutered during processing of [" + portTypeObj.getQName() + "] Port Type"));
                            }
                            continue;
                        }
                        LOG.warn((Object)"Undefined port type encoutered during processing of SDX");
                    }
                } else {
                    LOG.warn((Object)"The Service Description does not contain any Port Type definition");
                }
                Map mapMessages = def.getMessages();
                if (mapMessages == null) break block18;
                for (Message msgObj : mapMessages.values()) {
                    if (msgObj != null && !msgObj.isUndefined()) {
                        if (msgObj.getParts().size() == 0) continue;
                        for (Part objPart : msgObj.getParts().values()) {
                            QName partElement = objPart.getElementName();
                            QName partType = objPart.getTypeName();
                            if (partType == null && partElement == null) {
                                this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_MESSAGE_PART_NO_REFERENCES, pReporter, new String[]{objPart.getName(), msgObj.getQName().toString()}, inputSourceID);
                            }
                            if (partType != null && partElement != null) {
                                this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_MESSAGE_PART_BOTH_ELEMENT_AND_TYPE, pReporter, new String[]{objPart.getName(), msgObj.getQName().toString()}, inputSourceID);
                            }
                            if (partElement == null || !this.propInlineValidation || this.schemaHelper.lookupElement(partElement)) continue;
                            this.messageHelper.reportError(MessageTypeEnum.WSDL_GENERIC_MESSAGE_PART_WRONG_ELEM_REFERENCE, pReporter, new String[]{msgObj.getQName().getLocalPart(), partElement.toString()}, inputSourceID);
                        }
                        continue;
                    }
                    LOG.warn((Object)"Undefined message object encoutered during scanning messages of the SDX");
                }
            }
            catch (WSDLException e) {
                this.messageHelper.reportError(MessageTypeEnum.WSDL_ERROR, pReporter, new String[]{e.getMessage()}, inputSourceID);
            }
            catch (ContextInitializationException e) {
                this.messageHelper.reportError(MessageTypeEnum.WSDL_ERROR, pReporter, new String[]{e.getMessage()}, inputSourceID);
            }
        }
    }

    private void reloadProperties() {
        Properties settings = new Properties();
        InputStream is = this.getClass().getResourceAsStream(SETTING_PROP_FILE);
        if (is != null) {
            try {
                settings.load(is);
                String propValue = settings.getProperty(PROP_INLINE_VALIDATION_NAME);
                if (propValue != null) {
                    Boolean boolValue = Boolean.valueOf(propValue);
                    this.propInlineValidation = boolValue;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unexpected exception while loading the validation properties: " + e.getMessage()), (Throwable)e);
            }
        } else {
            LOG.warn((Object)"properties file [/sop.validation.properties] not found, assuming default values");
        }
        LOG.debug((Object)("The [org.eclipse.stp.common.validator.core.impl.service.GenericValidator.InlineSchema] = [" + this.propInlineValidation + "]"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(IValidationContext pValidationContext, IReporter pReporter) throws SOPValidationException {
        LOG.debug((Object)"The Generic WSDL Validator invoked");
        this.reloadProperties();
        IValidationObject valObj = pValidationContext.getObject();
        if (valObj == null) {
            throw new SOPValidationException("Empty object for validation");
        }
        LOG.debug((Object)("The Symbolic Name of the object to be validated is [" + valObj.getID().getSymbolicName() + "]"));
        Document inputDocument = null;
        try {
            inputDocument = valObj.getInput();
        }
        catch (ContextInitializationException e) {
            throw new SOPValidationException("Unable to load the document model", e);
        }
        if (inputDocument == null) throw new SOPValidationException("The empty document model loaded from context");
        if (valObj.getID().getType().equals(ValidationObjectTypeEnum.SDX_TYPE)) {
            LOG.debug((Object)"Validating Service Description Document");
            this.validateSDX(valObj, pReporter);
            return;
        } else {
            if (!valObj.getID().getType().equals(ValidationObjectTypeEnum.SPDX_TYPE)) throw new SOPValidationException("Unsupported document type [" + valObj.getID().getType().getName() + "]");
            LOG.debug((Object)"Validating Service Provider Description Document");
            this.validateSPDX(valObj.getID().getQName(), inputDocument, pReporter);
        }
    }
}

