/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.im.in.bpmn2im.BpmnDiagramUtils;
import org.eclipse.stp.im.in.bpmn2im.ui.providers.BpmnPoolContentProvider;
import org.eclipse.stp.im.in.bpmn2im.ui.providers.BpmnPoolLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBpmnPoolsDialog
extends TitleAreaDialog {
    private Composite aComposite = null;
    private SashForm internalSash = null;
    private Table tablePools = null;
    private TableViewer tbvPools = null;
    private List<Pool> thePools = null;
    private List<String> selectedPools = null;
    private int status = 0;

    public ListBpmnPoolsDialog(Shell parentShell, IFile bpmnFile) {
        super(parentShell);
        Resource resourceBpmn = BpmnDiagramUtils.getResourceFromIFile(bpmnFile);
        BpmnDiagram bpmnDiagram = BpmnDiagramUtils.getBpmnDiagramFromResource(resourceBpmn);
        this.thePools = bpmnDiagram.getPools();
        this.selectedPools = new ArrayList<String>();
    }

    public void create() {
        super.create();
        this.setTitle(" Bpmn Pools/Process ");
        this.setMessage(" Select Bpmn Pools/Process  ");
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        this.internalSash = new SashForm(parent, 0x800200);
        this.internalSash.setLayoutData((Object)new GridData(1808));
        final ListBpmnPoolsDialog theDialog = this;
        this.tablePools = new Table((Composite)this.internalSash, 67586);
        this.tablePools.setLinesVisible(true);
        this.tablePools.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tablePools, 16384);
        column.setText("Name");
        column.setWidth(100);
        column = new TableColumn(this.tablePools, 16384);
        column.setText("Technology");
        column.setWidth(200);
        this.tbvPools = new TableViewer(this.tablePools);
        this.tbvPools.setContentProvider((IContentProvider)new BpmnPoolContentProvider());
        this.tbvPools.setLabelProvider((IBaseLabelProvider)new BpmnPoolLabelProvider());
        this.tbvPools.setInput(this.thePools);
        this.aComposite = new Composite((Composite)this.internalSash, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        this.aComposite.setLayout((Layout)layout);
        this.aComposite.setLayoutData((Object)new GridData(768));
        Button btnSelectAll = new Button(this.aComposite, 0x800000);
        btnSelectAll.setText(" Select All ");
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        btnSelectAll.setLayoutData((Object)data);
        Button btnSelect = new Button(this.aComposite, 0x800000);
        btnSelect.setText(" OK ");
        data = new GridData(768);
        data.horizontalSpan = 1;
        btnSelect.setLayoutData((Object)data);
        Button btnCancel = new Button(this.aComposite, 0x800000);
        btnCancel.setText(" Cancel ");
        data = new GridData(768);
        data.horizontalSpan = 1;
        btnCancel.setLayoutData((Object)data);
        btnSelect.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selectedItems = theDialog.tablePools.getSelection();
                ListBpmnPoolsDialog.this.selectedPools = new ArrayList();
                if (selectedItems == null || selectedItems.length == 0) {
                    MessageDialog.openInformation((Shell)ListBpmnPoolsDialog.this.getShell(), (String)"Bpmn Pools/Processes", (String)" No Pools Selected ");
                    return;
                }
                int i = 0;
                while (i < selectedItems.length) {
                    ListBpmnPoolsDialog.this.selectedPools.add(((Pool)selectedItems[i].getData()).getID());
                    ++i;
                }
                ListBpmnPoolsDialog.this.close();
            }
        });
        btnSelectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                theDialog.tablePools.selectAll();
                theDialog.tbvPools.refresh(true);
            }
        });
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                theDialog.tablePools.deselectAll();
                theDialog.tbvPools.refresh(true);
                ListBpmnPoolsDialog.this.selectedPools = null;
                theDialog.status = 1;
                ListBpmnPoolsDialog.this.close();
            }
        });
        this.internalSash.setWeights(new int[]{60, 40});
        this.tablePools.selectAll();
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public List<String> getSelectedPools() {
        return this.selectedPools;
    }

    public void setSelectedPools(List<String> selectedPools) {
        this.selectedPools = selectedPools;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

