/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.resources.datasources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.im.resources.IImResource;
import org.eclipse.stp.im.resources.IImResourceConfigurator;
import org.eclipse.stp.im.resources.IImResourceImporter;
import org.eclipse.stp.im.resources.ImResourcesActivator;
import org.eclipse.stp.im.resources.datasources.DataSourceImResource;
import org.eclipse.stp.im.resources.datasources.DetailDatasourceDialog;
import org.eclipse.stp.im.resources.datasources.ImTitleAreaDialog;
import org.eclipse.stp.im.resources.datasources.SelectImResourcesDialog;
import org.eclipse.stp.im.resources.datasources.ViewConfigurationDialog;
import org.eclipse.stp.im.resources.ui.providers.IImResourceContentProvider;
import org.eclipse.stp.im.resources.ui.providers.IImResourceLabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListDatasourcesDialog
extends ImTitleAreaDialog {
    private Composite aComposite = null;
    private SashForm internalSash = null;
    private Table tableDatasources = null;
    private TableViewer tbvDatasources = null;
    private List<IImResource> theDatasources = new ArrayList<IImResource>();
    private CCombo exportersCombo = null;
    private CCombo importersCombo = null;

    public ListDatasourcesDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("IntermediateModel Datasources Repository ");
        this.setMessage(" Datasource Definitions / Import / Export  ");
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        this.internalSash = new SashForm(parent, 0x800200);
        this.internalSash.setLayoutData((Object)new GridData(1808));
        final ListDatasourcesDialog theDialog = this;
        this.theDatasources = ImResourcesActivator.getDataSources();
        this.tableDatasources = new Table((Composite)this.internalSash, 67586);
        this.tableDatasources.setLinesVisible(true);
        this.tableDatasources.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tableDatasources, 16384);
        column.setText("Name");
        column.setWidth(200);
        column = new TableColumn(this.tableDatasources, 16384);
        column.setText("Driver");
        column.setWidth(200);
        column = new TableColumn(this.tableDatasources, 16384);
        column.setText("Url");
        column.setWidth(200);
        column = new TableColumn(this.tableDatasources, 16384);
        column.setText("User");
        column.setWidth(200);
        column = new TableColumn(this.tableDatasources, 16384);
        column.setText("Password");
        column.setWidth(100);
        this.tbvDatasources = new TableViewer(this.tableDatasources);
        this.tbvDatasources.setContentProvider((IContentProvider)new IImResourceContentProvider());
        this.tbvDatasources.setLabelProvider((IBaseLabelProvider)new IImResourceLabelProvider());
        this.tbvDatasources.setInput(this.theDatasources);
        this.tableDatasources.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] tis = theDialog.tableDatasources.getSelection();
                    DataSourceImResource selected = (DataSourceImResource)tis[0].getData();
                    boolean confirm = MessageDialog.openConfirm((Shell)ListDatasourcesDialog.this.getShell(), (String)"Intermediate Model", (String)("This will remove datasource " + selected.getId() + "from IM Resources are you sure ? "));
                    if (confirm) {
                        ImResourcesActivator.deleteDatasource(selected);
                        theDialog.tbvDatasources.setInput(ImResourcesActivator.getDataSources());
                        theDialog.tbvDatasources.refresh();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.aComposite = new Composite((Composite)this.internalSash, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        this.aComposite.setLayout((Layout)layout);
        this.aComposite.setLayoutData((Object)new GridData(768));
        String imgAddDatasourcePath = "icons" + File.separator + "database_add.gif";
        Image addDatasorceImage = ImResourcesActivator.getImageDescriptor(imgAddDatasourcePath).createImage();
        CLabel aLabel = new CLabel(this.aComposite, 16384);
        aLabel.setText(" Add a new datasource ");
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        aLabel.setLayoutData((Object)data);
        Button btnAddSpagicDatasource = new Button(this.aComposite, 0x800000);
        btnAddSpagicDatasource.setImage(addDatasorceImage);
        btnAddSpagicDatasource.setText(" Add Datasource ");
        data = new GridData(768);
        data.horizontalSpan = 1;
        btnAddSpagicDatasource.setLayoutData((Object)data);
        this.importersCombo = new CCombo(this.aComposite, 0x800800);
        data = new GridData(768);
        String[] names = ImResourcesActivator.getIImResourceImportersNames();
        int i = 0;
        while (i < names.length) {
            this.importersCombo.add(names[i]);
            ++i;
        }
        data.horizontalSpan = 1;
        this.importersCombo.setLayoutData((Object)data);
        Button btnImport = new Button(this.aComposite, 0x800000);
        btnImport.setText(" Import ");
        data = new GridData(768);
        data.horizontalSpan = 1;
        btnImport.setLayoutData((Object)data);
        this.exportersCombo = new CCombo(this.aComposite, 0x800800);
        data = new GridData(768);
        String[] names2 = ImResourcesActivator.getIImResourceConfiguratorsNames();
        int i2 = 0;
        while (i2 < names2.length) {
            this.exportersCombo.add(names2[i2]);
            ++i2;
        }
        data.horizontalSpan = 1;
        this.exportersCombo.setLayoutData((Object)data);
        Button btnExport = new Button(this.aComposite, 0x800000);
        btnExport.setText(" Export ");
        data = new GridData(768);
        data.horizontalSpan = 1;
        btnExport.setLayoutData((Object)data);
        btnExport.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String resourceConfiguratorName = ListDatasourcesDialog.this.exportersCombo.getText();
                IImResourceConfigurator resCfg = ImResourcesActivator.getIImResourceConfiguratorByName(resourceConfiguratorName);
                ArrayList<IImResource> selectedDataSources = new ArrayList<IImResource>();
                TableItem[] selectedItems = theDialog.tableDatasources.getSelection();
                if (selectedItems == null || selectedItems.length == 0) {
                    MessageDialog.openInformation((Shell)ListDatasourcesDialog.this.getShell(), (String)"ImResource", (String)" Select Local Resourcse to Export ");
                    return;
                }
                int i = 0;
                while (i < selectedItems.length) {
                    selectedDataSources.add((IImResource)selectedItems[i].getData());
                    ++i;
                }
                if (selectedDataSources != null && selectedDataSources.size() > 0) {
                    ViewConfigurationDialog viewConfigurationDialog = new ViewConfigurationDialog(ListDatasourcesDialog.this.getShell(), resCfg.getConfiguration(selectedDataSources, "datasource"));
                    viewConfigurationDialog.open();
                }
            }
        });
        btnAddSpagicDatasource.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DetailDatasourceDialog dsDialog = new DetailDatasourceDialog(ListDatasourcesDialog.this.getShell());
                dsDialog.open();
                DataSourceImResource dsBean = dsDialog.getDatasourceBean();
                if (dsBean != null) {
                    ImResourcesActivator.addDataSource(dsBean);
                    theDialog.tbvDatasources.setInput(ImResourcesActivator.getDataSources());
                    theDialog.tbvDatasources.refresh();
                }
            }
        });
        btnImport.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    String importerName = ListDatasourcesDialog.this.importersCombo.getText();
                    IImResourceImporter resImporter = ImResourcesActivator.getIImResourceImporterByName(importerName);
                    List<IImResource> dsListFromImporter = resImporter.importResources("datasource");
                    if (dsListFromImporter == null || dsListFromImporter.size() == 0) {
                        return;
                    }
                    SelectImResourcesDialog selectionDsDialog = new SelectImResourcesDialog(ListDatasourcesDialog.this.getShell(), "Datasources List from ServiceMix", dsListFromImporter);
                    selectionDsDialog.open();
                    List<IImResource> choosedResources = selectionDsDialog.getSelectedImResources();
                    if (choosedResources != null) {
                        for (IImResource res : choosedResources) {
                            if (ImResourcesActivator.getImResourceByIdAndType(res.getId(), "datasource") != null) {
                                if (!MessageDialog.openConfirm((Shell)ListDatasourcesDialog.this.getShell(), (String)"Spagic", (String)("Datasource [" + res.getId() + "] is already defined in Spagic Studio, Update with configurations found in running smx ?"))) continue;
                                ImResourcesActivator.deleteDatasource(res);
                                ImResourcesActivator.addDataSource(res);
                                continue;
                            }
                            ImResourcesActivator.addDataSource(res);
                        }
                        theDialog.tbvDatasources.setInput(ImResourcesActivator.getDataSources());
                        theDialog.tbvDatasources.refresh();
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)ListDatasourcesDialog.this.getShell(), (String)"Spagic", (String)"Cannot contact smx server to get datasourceList");
                }
            }
        });
        this.internalSash.setWeights(new int[]{60, 40});
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }
}

