/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.stp.im.runtime.ExpressionImpl;
import org.eclipse.stp.im.runtime.IExpression;
import org.eclipse.stp.im.runtime.IProcessProperties;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.IService;
import org.eclipse.stp.im.runtime.IServiceBinding;
import org.eclipse.stp.im.runtime.ProcessPropertiesImpl;
import org.eclipse.stp.im.runtime.PropertyImpl;
import org.eclipse.stp.im.runtime.ServiceBindingImpl;
import org.eclipse.stp.im.runtime.ServiceImpl;
import org.eclipse.stp.im.runtime.comboproviders.IComboProvider;
import org.eclipse.stp.im.runtime.property.listeners.IPropertyListener;
import org.eclipse.stp.im.util.ImLogger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntime
implements IRuntime {
    public String id = null;
    public String name = null;
    public String version = null;
    public String nsprefix = null;
    public String nsuri = null;
    public Map<String, IServiceBinding> serviceBindings = null;
    public Map<String, IComboProvider> comboProviders = null;
    private String runtimeSpecific = null;
    private IProcessProperties processProperties = null;
    Map<String, String> runtimeSpecificForExtension = null;
    public List<IExpression> expressions = null;
    public List<IService> services = null;
    private Map<String, String> dnDMatchingProperties = null;
    private String bundleId = null;

    public AbstractRuntime() {
    }

    public AbstractRuntime(String bundleId) {
        this.bundleId = bundleId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getNsprefix() {
        return this.nsprefix;
    }

    @Override
    public void setNsprefix(String nsprefix) {
        this.nsprefix = nsprefix;
    }

    @Override
    public String getNsuri() {
        return this.nsuri;
    }

    @Override
    public void setNsuri(String nsuri) {
        this.nsuri = nsuri;
    }

    @Override
    public Map<String, IServiceBinding> getServiceBindings() {
        return this.serviceBindings;
    }

    @Override
    public void init(File f) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(f);
            this.initBaseProperties(document);
            this.initComboProviders(document);
            this.initProcessProperties(document);
            this.initBindings(document);
            this.initServices(document);
            this.initExpressions(document);
            this.initRuntimeSpecific(document);
            this.initDnDMatchingProperties(document);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initRuntimeSpecific(Document document) throws Exception {
        String xPath = "/runtime/runtime-specific";
        Node node = AbstractRuntime.selectSingleNode(document, xPath);
        if (node != null) {
            this.runtimeSpecific = this.getStringFromNode(node);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("<runtime-specific>\n");
            sb.append("</runtime-specific>\n");
            this.runtimeSpecific = sb.toString();
        }
    }

    @Override
    public void addRuntimeSpecificForExtension(String extensionId, String extensionRuntimeSpecific) {
        if (this.runtimeSpecificForExtension == null) {
            this.runtimeSpecificForExtension = new HashMap<String, String>();
        }
        this.runtimeSpecificForExtension.put(extensionId, extensionRuntimeSpecific);
    }

    @Override
    public String getRuntimeSpecific() {
        return this.runtimeSpecific;
    }

    @Override
    public Map<String, String> getDnDMatchingProperties() {
        return this.dnDMatchingProperties;
    }

    private String getStringFromNode(Node node) throws Exception {
        OutputFormat format = new OutputFormat();
        String XML_HEADER_DEFAULT_ENCODING = "ISO-8859-1";
        format.setEncoding(XML_HEADER_DEFAULT_ENCODING);
        format.setIndenting(true);
        format.setIndent(3);
        format.setLineWidth(0);
        format.setLineSeparator("\n");
        format.setPreserveEmptyAttributes(true);
        StringWriter result = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)result, format);
        switch (node.getNodeType()) {
            case 9: {
                serializer.serialize((Document)node);
                break;
            }
            case 1: {
                serializer.serialize((Element)node);
                break;
            }
            case 11: {
                serializer.serialize((DocumentFragment)node);
            }
        }
        System.out.print(result.toString());
        return result.toString();
    }

    public void initBaseProperties(Document document) throws Exception {
        String xPath = "/runtime";
        Node node = AbstractRuntime.selectSingleNode(document, xPath);
        this.name = AbstractRuntime.getAttributeValue(node, "name");
        this.id = AbstractRuntime.getAttributeValue(node, "id");
        this.nsprefix = AbstractRuntime.getAttributeValue(node, "nsprefix");
        this.nsuri = AbstractRuntime.getAttributeValue(node, "nsuri");
        this.version = AbstractRuntime.getAttributeValue(node, "version");
    }

    protected IServiceBinding createServiceBindingFromNode(Node aNode) {
        ServiceBindingImpl sb = new ServiceBindingImpl(AbstractRuntime.getAttributeValue(aNode, "name"), this.getId());
        sb.setRegisteringBundleId(this.bundleId);
        String icon = AbstractRuntime.getAttributeValue(aNode, "icon");
        if (icon != null && icon.trim().length() > 0) {
            sb.setIconPath(icon);
        }
        return sb;
    }

    protected IExpression createExpressionFromNode(Node aNode) {
        ExpressionImpl expr = new ExpressionImpl(AbstractRuntime.getAttributeValue(aNode, "name"), this.getId());
        expr.setType(AbstractRuntime.getAttributeValue(aNode, "type"));
        expr.setRegisteringBundleId(this.bundleId);
        String icon = AbstractRuntime.getAttributeValue(aNode, "icon");
        if (icon != null && icon.trim().length() > 0) {
            expr.setIconPath(icon);
        }
        return expr;
    }

    public void initDnDMatchingProperties(Document document) throws Exception {
        String xPath = "/runtime/dnd-file-property-handler/match";
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        this.dnDMatchingProperties = new HashMap<String, String>();
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            n = nodes.item(i);
            this.dnDMatchingProperties.put(AbstractRuntime.getAttributeValue(n, "extension"), AbstractRuntime.getAttributeValue(n, "propertyName"));
            ++i;
        }
    }

    public void initExpressions(Document document) throws Exception {
        String xPath = "/runtime/expressions/expression";
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        this.expressions = new ArrayList<IExpression>();
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            n = nodes.item(i);
            this.expressions.add(this.createExpressionFromNode(n));
            ++i;
        }
        for (IExpression expression : this.expressions) {
            this.populateExpressionProperties(expression, document);
        }
    }

    public void initServices(Document document) throws Exception {
        String xPath = "/runtime/im-services/im-service";
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        this.services = new ArrayList<IService>();
        ServiceImpl aService = null;
        String name = null;
        String icon = null;
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            n = nodes.item(i);
            name = AbstractRuntime.getAttributeValue(n, "name");
            icon = AbstractRuntime.getAttributeValue(n, "icon");
            aService = new ServiceImpl(name, "Description for " + name, AbstractRuntime.getAttributeValue(n, "bindings"));
            aService.setEmfServiceEntity(AbstractRuntime.getAttributeValue(n, "emf-service-entity"));
            aService.setRegisteringBundleId(this.bundleId);
            if (icon != null && icon.trim().length() > 0) {
                aService.setIconPath(icon);
            }
            this.services.add(aService);
            ++i;
        }
    }

    public void initProcessProperties(Document document) throws Exception {
        this.processProperties = new ProcessPropertiesImpl(this.getId());
        this.processProperties.setRegisteringBundleId(this.bundleId);
        String xPathProp = "/runtime/process-properties/property";
        List<IProperty> serviceBindingProperties = this.selectProperties(document, xPathProp);
        this.processProperties.setDefinedProperties(serviceBindingProperties);
    }

    public void initBindings(Document document) throws Exception {
        String xPath = "/runtime/service-bindings/service-binding";
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        this.serviceBindings = new HashMap<String, IServiceBinding>();
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            n = nodes.item(i);
            this.serviceBindings.put(AbstractRuntime.getAttributeValue(n, "name"), this.createServiceBindingFromNode(n));
            ++i;
        }
        for (IServiceBinding sb : this.serviceBindings.values()) {
            this.populateServiceBindingProperties(sb, document);
        }
    }

    protected void initComboProviders(Document document) throws Exception {
        this.comboProviders = new HashMap<String, IComboProvider>();
        String xPath = "/runtime/combo-providers/combo-provider";
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        Object initParamsForComboProvider = null;
        String comboProviderName = null;
        String comboProviderType = null;
        Class<?> providerClass = null;
        Constructor<?> constructor = null;
        Class[] constructorParameterTypes = new Class[]{Map.class};
        HashMap<String, String> parametersOfThisCombo = null;
        IComboProvider comboProvider = null;
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            n = nodes.item(i);
            comboProviderName = AbstractRuntime.getAttributeValue(n, "name");
            comboProviderType = AbstractRuntime.getAttributeValue(n, "type");
            NodeList nodesOfComboProviderParameters = AbstractRuntime.selectNodes(document, "/runtime/combo-providers/combo-provider[@name='" + comboProviderName + "']/combo-provider-parameter");
            parametersOfThisCombo = new HashMap<String, String>();
            Node n2 = null;
            int j = 0;
            while (j < nodesOfComboProviderParameters.getLength()) {
                n2 = nodesOfComboProviderParameters.item(j);
                parametersOfThisCombo.put(AbstractRuntime.getAttributeValue(n2, "name"), AbstractRuntime.getAttributeValue(n2, "value"));
                ++j;
            }
            try {
                providerClass = Class.forName(comboProviderType);
                constructor = providerClass.getConstructor(constructorParameterTypes);
                comboProvider = (IComboProvider)constructor.newInstance(parametersOfThisCombo);
                this.comboProviders.put(comboProviderName, comboProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public IComboProvider getNamedComboProvider(String name) {
        return this.comboProviders.get(name);
    }

    protected List<IProperty> selectProperties(Document document, String xPath) throws Exception {
        NodeList nodes = AbstractRuntime.selectNodes(document, xPath);
        PropertyImpl aProperty = null;
        ArrayList<IProperty> propertyConfigs = new ArrayList<IProperty>();
        Node n = null;
        int i = 0;
        while (i < nodes.getLength()) {
            String modifyListener;
            n = nodes.item(i);
            aProperty = new PropertyImpl();
            aProperty.setLabel(AbstractRuntime.getAttributeValue(n, "label"));
            aProperty.setName(AbstractRuntime.getAttributeValue(n, "name"));
            aProperty.setDefaultValue(AbstractRuntime.getAttributeValue(n, "defaultValue"));
            aProperty.setRequired(AbstractRuntime.getAttributeValue(n, "required"));
            String visibleCondition = AbstractRuntime.getAttributeValue(n, "visibleCondition");
            if (visibleCondition != null && visibleCondition.trim().length() > 0) {
                aProperty.setVisibleUnderCondition(true);
                aProperty.setVisibleCondition(visibleCondition);
            } else {
                aProperty.setVisibleUnderCondition(false);
            }
            String uiCategory = AbstractRuntime.getAttributeValue(n, "uicategory");
            if (uiCategory != null && uiCategory.trim().length() > 0) {
                aProperty.setUiCategoratory(uiCategory);
            }
            aProperty.setEditable(Boolean.valueOf(AbstractRuntime.getAttributeValue(n, "editable")));
            aProperty.setPropertyEditor(AbstractRuntime.getAttributeValue(n, "propertyEditor"));
            aProperty.setMapKey(AbstractRuntime.getAttributeValue(n, "mapKey"));
            aProperty.setMapFields(AbstractRuntime.getAttributeValue(n, "mapFields"));
            aProperty.setMapFieldsEditors(AbstractRuntime.getAttributeValue(n, "mapFieldsEditors"));
            aProperty.setDependentProperty(AbstractRuntime.getAttributeValue(n, "dependentProperty"));
            if (aProperty.isCombo()) {
                String comboName = AbstractRuntime.getAttributeValue(n, "comboProvider");
                aProperty.setComboProviderName(comboName);
                IComboProvider comboProvider = this.getNamedComboProvider(AbstractRuntime.getAttributeValue(n, "comboProvider"));
                if (comboProvider != null) {
                    aProperty.setComboProvider(comboProvider);
                }
            }
            if ((modifyListener = AbstractRuntime.getAttributeValue(n, "modifyListener")) != null && modifyListener.trim().length() > 0) {
                try {
                    IPropertyListener propertyListener = (IPropertyListener)Class.forName(modifyListener).newInstance();
                    aProperty.setPropertyListener(propertyListener);
                }
                catch (Exception e) {
                    ImLogger.error((String)"org.eclipse.stp.im.runtime", (String)e.getMessage(), (Throwable)e);
                }
            }
            propertyConfigs.add(aProperty);
            ++i;
        }
        return propertyConfigs;
    }

    protected void populateServiceBindingProperties(IServiceBinding sb, Document document) throws Exception {
        String xPath = "/runtime/service-bindings/service-binding[@name='" + sb.getName() + "']/property";
        List<IProperty> serviceBindingProperties = this.selectProperties(document, xPath);
        sb.setDefinedProperties(serviceBindingProperties);
    }

    protected void populateExpressionProperties(IExpression expression, Document document) throws Exception {
        String xPath = "/runtime/expressions/expression[@name='" + expression.getName() + "']/property";
        List<IProperty> expressionProperties = this.selectProperties(document, xPath);
        expression.setDefinedProperties(expressionProperties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<IService> getServices() {
        return this.services;
    }

    @Override
    public List<IExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public IExpression getExpressionWithName(String expressionName) {
        for (IExpression expr : this.expressions) {
            if (!expr.getName().equalsIgnoreCase(expressionName)) continue;
            return expr;
        }
        return null;
    }

    private static Node selectSingleNode(Node document, String xPath) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (Node)xpath.evaluate(xPath, document, XPathConstants.NODE);
    }

    private static NodeList selectNodes(Node document, String xPath) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.evaluate(xPath, document, XPathConstants.NODESET);
    }

    private static String getAttributeValue(Node n, String attributeName) {
        try {
            Node attributeNode = n.getAttributes().getNamedItem(attributeName);
            return attributeNode != null ? attributeNode.getNodeValue() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getExtendedRuntimeId() {
        return null;
    }

    @Override
    public boolean isRuntimeExtension() {
        return false;
    }

    @Override
    public Map<String, String> getRuntimeSpecificForExtension() {
        return this.runtimeSpecificForExtension;
    }

    @Override
    public void setRuntimeSpecificForExtension(Map<String, String> runtimeSpecificForExtension) {
        this.runtimeSpecificForExtension = runtimeSpecificForExtension;
    }

    @Override
    public Map<String, IComboProvider> getComboProviders() {
        return this.comboProviders;
    }

    @Override
    public IProcessProperties getProcessProperties() {
        return this.processProperties;
    }
}

